/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.tiles;

import java.util.Locale;
import net.mehvahdjukaar.moonlight.api.block.ISoftFluidTankProvider;
import net.mehvahdjukaar.moonlight.api.block.ItemDisplayTile;
import net.mehvahdjukaar.moonlight.api.client.model.ExtraModelData;
import net.mehvahdjukaar.moonlight.api.client.model.IExtraModelDataProvider;
import net.mehvahdjukaar.moonlight.api.client.model.ModelDataKey;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluid;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidTank;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.supplementaries.common.block.ModBlockProperties;
import net.mehvahdjukaar.supplementaries.common.block.blocks.ClockBlock;
import net.mehvahdjukaar.supplementaries.common.items.AbstractMobContainerItem;
import net.mehvahdjukaar.supplementaries.common.items.components.MobContainerView;
import net.mehvahdjukaar.supplementaries.common.items.components.SoftFluidTankView;
import net.mehvahdjukaar.supplementaries.common.misc.mob_container.IMobContainerProvider;
import net.mehvahdjukaar.supplementaries.common.misc.mob_container.MobContainer;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModComponents;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModSounds;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class JarBlockTile
extends ItemDisplayTile
implements IMobContainerProvider,
ISoftFluidTankProvider,
IExtraModelDataProvider {
    public static final ModelDataKey<ResourceKey<SoftFluid>> FLUID = ModBlockProperties.FLUID;
    public static final ModelDataKey<Float> FILL_LEVEL = ModBlockProperties.FILL_LEVEL;
    private final MobContainer mobContainer;
    private SoftFluidTank fluidHolder;

    public JarBlockTile(BlockPos pos, BlockState state) {
        super(ModRegistry.JAR_TILE.get(), pos, state, 12);
        AbstractMobContainerItem item = (AbstractMobContainerItem)state.getBlock().asItem();
        this.mobContainer = new MobContainer(item.getMobContainerWidth(), item.getMobContainerHeight(), true);
    }

    public void addExtraModelData(ExtraModelData.Builder builder) {
        if (!this.fluidHolder.isEmpty()) {
            builder.with(FLUID, (Object)((ResourceKey)this.fluidHolder.getFluid().getHolder().unwrapKey().get())).with(FILL_LEVEL, (Object)Float.valueOf(this.fluidHolder.getHeight(1.0f)));
        }
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput componentInput) {
        MobContainerView mobView;
        super.applyImplicitComponents(componentInput);
        SoftFluidTankView fluidView = (SoftFluidTankView)componentInput.get(ModComponents.SOFT_FLUID_CONTENT.get());
        if (fluidView != null) {
            fluidView.apply(this.fluidHolder);
        }
        if ((mobView = (MobContainerView)componentInput.get(ModComponents.MOB_HOLDER_CONTENT.get())) != null) {
            mobView.apply(this.mobContainer);
        }
    }

    protected void collectImplicitComponents(DataComponentMap.Builder components) {
        super.collectImplicitComponents(components);
        if (!this.fluidHolder.isEmpty()) {
            components.set(ModComponents.SOFT_FLUID_CONTENT.get(), (Object)SoftFluidTankView.of(this.fluidHolder));
        }
        if (!this.mobContainer.isEmpty()) {
            components.set(ModComponents.MOB_HOLDER_CONTENT.get(), (Object)MobContainerView.of(this.mobContainer));
        }
    }

    public void removeComponentsFromTag(CompoundTag tag) {
        super.removeComponentsFromTag(tag);
        tag.remove("fluid");
        tag.remove("MobHolder");
        tag.remove("BucketHolder");
    }

    public void updateTileOnInventoryChanged() {
        this.level.updateNeighborsAt(this.worldPosition, this.getBlockState().getBlock());
        int light = this.fluidHolder.getFluidValue().getLuminosity();
        if (light != (Integer)this.getBlockState().getValue((Property)ModBlockProperties.LIGHT_LEVEL_0_15)) {
            this.level.setBlock(this.worldPosition, (BlockState)this.getBlockState().setValue((Property)ModBlockProperties.LIGHT_LEVEL_0_15, (Comparable)Integer.valueOf(light)), 2);
        }
    }

    public void updateClientVisualsOnLoad() {
        super.updateClientVisualsOnLoad();
        this.requestModelReload();
    }

    public boolean handleInteraction(Player player, InteractionHand hand, Level level, BlockPos pos) {
        ItemStack handStack = player.getItemInHand(hand);
        ItemStack displayedStack = this.getDisplayedItem();
        if (this.canInteractWithSoftFluidTank() && this.fluidHolder.interactWithPlayer(player, hand, level, pos)) {
            return true;
        }
        if (this.tryAddingItem(handStack, player, hand)) {
            return true;
        }
        if (this.isEmpty() && this.fluidHolder.isEmpty() && this.mobContainer.interactWithBucket(handStack, level, player.blockPosition(), player, hand)) {
            return true;
        }
        if (!player.isShiftKeyDown() && CommonConfigs.Functional.JAR_EAT.get().booleanValue()) {
            if (this.fluidHolder.tryDrinkUpFluid(player, level)) {
                return true;
            }
            if (displayedStack.has(DataComponents.FOOD) && player.canEat(false) && !player.isCreative()) {
                player.eat(level, displayedStack);
                return true;
            }
        }
        return this.handleExtractItem(player, hand);
    }

    public ItemStack extractItem() {
        for (int j = this.getContainerSize() - 1; j >= 0; --j) {
            ItemStack s = this.getItem(j);
            if (s.isEmpty()) continue;
            this.removeItemNoUpdate(j);
            return s;
        }
        return ItemStack.EMPTY;
    }

    public boolean handleExtractItem(Player player, InteractionHand hand) {
        if (!player.getItemInHand(hand).isEmpty()) {
            return false;
        }
        ItemStack extracted = this.extractItem();
        if (!extracted.isEmpty()) {
            Utils.swapItem((Player)player, (InteractionHand)hand, (ItemStack)extracted);
            return true;
        }
        return false;
    }

    public boolean tryAddingItem(ItemStack stack, @Nullable Player player, InteractionHand handIn) {
        ItemStack handStack = stack.copy();
        handStack.setCount(1);
        if (this.tryAddingItem(handStack)) {
            if (player != null) {
                ItemStack returnStack = ItemStack.EMPTY;
                Level level = player.level();
                level.playSound(player, this.worldPosition, ModSounds.JAR_COOKIE.get(), SoundSource.BLOCKS, 1.0f, 0.9f + level.random.nextFloat() * 0.1f);
                player.awardStat(Stats.ITEM_USED.get((Object)handStack.getItem()));
                if (!player.isCreative()) {
                    Utils.swapItem((Player)player, (InteractionHand)handIn, (ItemStack)returnStack);
                }
            }
            return true;
        }
        return false;
    }

    public boolean tryAddingItem(ItemStack itemstack) {
        for (int i = 0; i < this.getItems().size(); ++i) {
            if (!this.canPlaceItem(i, itemstack)) continue;
            this.setItem(i, itemstack);
            return true;
        }
        return false;
    }

    public void clearAllContents() {
        this.fluidHolder.clear();
        this.mobContainer.clear();
        this.setItems(NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY));
    }

    public boolean isPonyJar() {
        if (this.hasCustomName()) {
            Component c = this.getCustomName();
            return c != null && c.getString().toLowerCase(Locale.ROOT).contains("cum");
        }
        return false;
    }

    private SoftFluidTank getOrCreateFluidTank(HolderLookup.Provider registries) {
        if (this.fluidHolder == null) {
            int capacity = CommonConfigs.Functional.JAR_CAPACITY.get();
            this.fluidHolder = SoftFluidTank.create((int)capacity, (HolderLookup.Provider)registries);
        }
        return this.fluidHolder;
    }

    public SoftFluidTank getSoftFluidTank() {
        return this.fluidHolder;
    }

    public void setLevel(Level level) {
        super.setLevel(level);
        this.getOrCreateFluidTank((HolderLookup.Provider)level.registryAccess());
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.getOrCreateFluidTank(registries).load(tag, registries);
        this.mobContainer.load(tag, registries);
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        this.getOrCreateFluidTank(registries).save(tag, registries);
        this.mobContainer.save(tag, registries);
    }

    public boolean hasContent() {
        return !this.isEmpty() || !this.mobContainer.isEmpty() || !this.fluidHolder.isEmpty();
    }

    public boolean isFull() {
        return this.getItems().stream().noneMatch(ItemStack::isEmpty);
    }

    public boolean canPlaceItemThroughFace(int index, ItemStack stack, @Nullable Direction direction) {
        return this.canPlaceItem(index, stack);
    }

    public boolean canPlaceItem(int index, ItemStack stack) {
        if (this.getItem(index).getCount() < this.getMaxStackSize() && CommonConfigs.Functional.JAR_COOKIES.get().booleanValue() && this.fluidHolder.isEmpty() && this.mobContainer.isEmpty()) {
            return stack.is(ModTags.COOKIES);
        }
        return false;
    }

    public boolean canTakeItemThroughFace(int index, ItemStack stack, Direction direction) {
        return true;
    }

    @Override
    public MobContainer getMobContainer() {
        return this.mobContainer;
    }

    @Override
    public Direction getDirection() {
        return (Direction)this.getBlockState().getValue((Property)ClockBlock.FACING);
    }

    public static void tick(Level pLevel, BlockPos pPos, BlockState pState, JarBlockTile tile) {
        tile.mobContainer.tick(pLevel, pPos);
    }

    public boolean canInteractWithSoftFluidTank() {
        return CommonConfigs.Functional.JAR_LIQUIDS.get() != false && this.isEmpty() && (this.mobContainer.isEmpty() || this.isPonyJar());
    }
}

