/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.tiles;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.worldgen.LocatedStructure;
import net.mehvahdjukaar.supplementaries.common.worldgen.RoadSignFeature;
import net.mehvahdjukaar.supplementaries.common.worldgen.StructureLocator;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class BlockGeneratorBlockTile
extends BlockEntity {
    private static final ExecutorService EXECUTORS = Executors.newCachedThreadPool();
    private CompletableFuture<List<LocatedStructure>> threadResult;
    private boolean firstTick = true;
    private RoadSignFeature.Config config = null;

    public BlockGeneratorBlockTile(BlockPos pos, BlockState state) {
        super(ModRegistry.BLOCK_GENERATOR_TILE.get(), pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, BlockGeneratorBlockTile tile) {
        if (tile.firstTick) {
            tile.firstTick = false;
            tile.threadResult = CompletableFuture.supplyAsync(() -> StructureLocator.findNearestStructures((ServerLevel)level, ModTags.ROAD_SIGN_DESTINATIONS, pos, 250, false, 2, (int)CommonConfigs.Building.ROAD_SIGN_MAX_SEARCHES.get(), (boolean)CommonConfigs.Building.ROAD_SIGN_EXIT_EARLY.get()), EXECUTORS).exceptionally(exception -> {
                BlockGeneratorBlockTile.throwError(pos, exception);
                return null;
            });
            return;
        }
        if (tile.config == null || tile.threadResult == null || tile.threadResult.isCompletedExceptionally()) {
            level.removeBlock(pos, false);
            return;
        }
        if (tile.threadResult.isDone()) {
            try {
                RoadSignFeature.applyPostProcess(tile.config, (ServerLevel)level, pos, tile.threadResult.get());
            }
            catch (Exception e) {
                level.removeBlock(pos, false);
                BlockGeneratorBlockTile.throwError(pos, e);
            }
        }
    }

    private static void throwError(BlockPos pos, Throwable exception) {
        Supplementaries.LOGGER.error("Failed to generate road sign at {}: {}", (Object)pos, (Object)exception);
    }

    public void setConfig(RoadSignFeature.Config c) {
        this.config = c;
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        if (this.config != null) {
            RegistryOps ops = registries.createSerializationContext((DynamicOps)NbtOps.INSTANCE);
            tag.put("config", (Tag)RoadSignFeature.Config.CODEC.encodeStart((DynamicOps)ops, (Object)this.config).getOrThrow());
        }
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        if (tag.contains("config")) {
            RegistryOps ops = registries.createSerializationContext((DynamicOps)NbtOps.INSTANCE);
            this.config = (RoadSignFeature.Config)((Pair)RoadSignFeature.Config.CODEC.decode((DynamicOps)ops, (Object)tag.get("config")).getOrThrow()).getFirst();
        }
    }
}

