/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.faucet;

import net.mehvahdjukaar.moonlight.api.fluids.SoftFluid;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidStack;
import net.mehvahdjukaar.supplementaries.common.block.faucet.FaucetSource;
import net.mehvahdjukaar.supplementaries.common.block.faucet.FluidOffer;
import net.mehvahdjukaar.supplementaries.common.fluids.FiniteFluid;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.Nullable;

class LiquidBlockInteraction
implements FaucetSource.Fluid {
    LiquidBlockInteraction() {
    }

    @Override
    @Nullable
    public FluidOffer getProvidedFluid(Level level, BlockPos pos, Direction dir, FluidState source) {
        if (source.isEmpty() || !source.isSource() || source.getType() instanceof FiniteFluid) {
            return null;
        }
        return FluidOffer.of(SoftFluidStack.fromFluid((Fluid)source.getType(), (int)SoftFluid.BUCKET_COUNT, (HolderLookup.Provider)level.registryAccess()), source.getType() != Fluids.WATER ? SoftFluid.BUCKET_COUNT : 1);
    }

    @Override
    public void drain(Level level, BlockPos pos, Direction dir, FluidState source, int amount) {
        BlockState state = level.getBlockState(pos);
        if (source.getType() != Fluids.WATER) {
            Block block = state.getBlock();
            if (block instanceof BucketPickup) {
                BucketPickup bp = (BucketPickup)block;
                block = bp.pickupBlock(null, (LevelAccessor)level, pos, state);
            } else {
                level.setBlock(pos, Blocks.AIR.defaultBlockState(), 3);
            }
        }
    }
}

