/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.renderers.entities.models;

import net.mehvahdjukaar.supplementaries.common.entities.PlundererEntity;
import net.minecraft.client.model.IllagerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.monster.AbstractIllager;

public class PlundererModel
extends IllagerModel<PlundererEntity> {
    private final ModelPart skirt;
    private final ModelPart rightArm;
    private final ModelPart leftArm;
    private final ModelPart head;

    public PlundererModel(ModelPart root) {
        super(root);
        this.getHat().visible = true;
        this.skirt = root.getChild("body").getChild("skirt");
        this.rightArm = root.getChild("right_arm");
        this.leftArm = root.getChild("left_arm");
        this.head = root.getChild("head");
    }

    public void prepareMobModel(PlundererEntity entity, float limbSwing, float limbSwingAmount, float partialTick) {
        super.prepareMobModel((Entity)entity, limbSwing, limbSwingAmount, partialTick);
        this.skirt.visible = !entity.isPassenger();
    }

    public void setupAnim(PlundererEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        super.setupAnim((AbstractIllager)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        if (entity.isUsingSpyglass()) {
            boolean useHand;
            boolean rightHanded = entity.getMainArm() == HumanoidArm.RIGHT;
            boolean bl = useHand = entity.getUsedItemHand() == InteractionHand.MAIN_HAND;
            if (useHand == rightHanded) {
                this.rightArm.xRot = Mth.clamp((float)(this.head.xRot - 1.9198622f - (entity.isCrouching() ? 0.2617994f : 0.0f)), (float)-2.4f, (float)3.3f);
                this.rightArm.yRot = this.head.yRot - 0.2617994f;
            } else {
                this.leftArm.xRot = Mth.clamp((float)(this.head.xRot - 1.9198622f - (entity.isCrouching() ? 0.2617994f : 0.0f)), (float)-2.4f, (float)3.3f);
                this.leftArm.yRot = this.head.yRot + 0.2617994f;
            }
        }
    }

    public static LayerDefinition createMesh() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.getRoot();
        PartDefinition partDefinition2 = partDefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -10.0f, -4.0f, 8.0f, 10.0f, 8.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        partDefinition2.addOrReplaceChild("hat", CubeListBuilder.create().texOffs(32, 0).addBox(-4.0f, -10.0f, -4.0f, 8.0f, 10.0f, 8.0f, new CubeDeformation(0.45f)).texOffs(0, 72).addBox(-5.0f, -11.0f, -4.0f, 10.0f, 4.0f, 8.0f, new CubeDeformation(0.5f)), PartPose.ZERO);
        partDefinition2.addOrReplaceChild("nose", CubeListBuilder.create().texOffs(24, 0).addBox(-1.0f, -1.0f, -6.0f, 2.0f, 4.0f, 2.0f), PartPose.offset((float)0.0f, (float)-2.0f, (float)0.0f));
        PartDefinition bodyPart = partDefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(16, 22).addBox(-4.0f, 0.0f, -3.0f, 8.0f, 12.0f, 6.0f).texOffs(0, 40).addBox(-4.0f, 0.0f, -3.0f, 8.0f, 14.0f, 6.0f, new CubeDeformation(0.5f)), PartPose.ZERO);
        bodyPart.addOrReplaceChild("skirt", CubeListBuilder.create().texOffs(0, 60).addBox(-4.0f, 15.0f, -3.0f, 8.0f, 6.0f, 6.0f, new CubeDeformation(0.5f)), PartPose.ZERO);
        PartDefinition partDefinition3 = partDefinition.addOrReplaceChild("arms", CubeListBuilder.create().texOffs(44, 22).addBox(-8.0f, -2.0f, -2.0f, 4.0f, 8.0f, 4.0f).texOffs(40, 38).addBox(-4.0f, 2.0f, -2.0f, 8.0f, 4.0f, 4.0f), PartPose.offsetAndRotation((float)0.0f, (float)3.0f, (float)-1.0f, (float)-0.75f, (float)0.0f, (float)0.0f));
        partDefinition3.addOrReplaceChild("left_shoulder", CubeListBuilder.create().texOffs(44, 22).mirror().addBox(4.0f, -2.0f, -2.0f, 4.0f, 8.0f, 4.0f), PartPose.ZERO);
        partDefinition.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(0, 20).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f), PartPose.offset((float)-2.0f, (float)12.0f, (float)0.0f));
        partDefinition.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(0, 20).mirror().addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f), PartPose.offset((float)2.0f, (float)12.0f, (float)0.0f));
        partDefinition.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(40, 46).addBox(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f), PartPose.offset((float)-5.0f, (float)2.0f, (float)0.0f));
        partDefinition.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(40, 46).mirror().addBox(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f), PartPose.offset((float)5.0f, (float)2.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)64, (int)128);
    }
}

