/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivefarming.util;

import cy.jdkdigital.productivefarming.common.datamap.CropTrait;
import cy.jdkdigital.productivefarming.registry.FarmingDataComponents;
import cy.jdkdigital.productivefarming.registry.FarmingRegistrator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class TraitsHelper {
    public static final String GROWTH = "growth";
    public static final String YIELD = "yield";
    public static final String RESISTANCE = "resistance";
    public static final String MUTABILITY = "mutability";
    static Map<String, List<String>> TRAIT_VALUES = new HashMap<String, List<String>>(){
        {
            this.put(TraitsHelper.GROWTH, List.of("low", "medium", "high", "very_high"));
            this.put(TraitsHelper.YIELD, List.of("low", "medium", "high", "very_high"));
            this.put(TraitsHelper.RESISTANCE, List.of("none", "low", "medium", "high", "very_high"));
            this.put(TraitsHelper.MUTABILITY, List.of("none", "low", "medium", "high", "very_high"));
        }
    };

    public static Component getValueName(String trait, int value) {
        if (!TRAIT_VALUES.containsKey(trait) || TRAIT_VALUES.get(trait).size() <= value) {
            return Component.literal((String)("Invalid trait value " + value + " for " + trait));
        }
        return Component.translatable((String)("productivefarming.trait_value." + TRAIT_VALUES.get(trait).get(value))).withStyle(TraitsHelper.getStyle(trait, value));
    }

    private static ChatFormatting getStyle(String trait, int value) {
        return switch (TRAIT_VALUES.get(trait).get(value)) {
            case "low" -> ChatFormatting.GREEN;
            case "medium" -> ChatFormatting.BLUE;
            case "high" -> ChatFormatting.LIGHT_PURPLE;
            case "very_high" -> ChatFormatting.RED;
            default -> ChatFormatting.DARK_GRAY;
        };
    }

    public static int getMaxValue(String trait) {
        if (TRAIT_VALUES.containsKey(trait)) {
            return TRAIT_VALUES.get(trait).size() - 1;
        }
        return 0;
    }

    public static void setDefaultsOnStack(ItemStack stack) {
        stack.set(FarmingDataComponents.GROWTH, (Object)TraitsHelper.getDefaultTrait((Holder<Item>)stack.getItemHolder(), FarmingDataComponents.GROWTH));
        stack.set(FarmingDataComponents.YIELD, (Object)TraitsHelper.getDefaultTrait((Holder<Item>)stack.getItemHolder(), FarmingDataComponents.YIELD));
        stack.set(FarmingDataComponents.RESISTANCE, (Object)TraitsHelper.getDefaultTrait((Holder<Item>)stack.getItemHolder(), FarmingDataComponents.RESISTANCE));
        stack.set(FarmingDataComponents.MUTABILITY, (Object)TraitsHelper.getDefaultTrait((Holder<Item>)stack.getItemHolder(), FarmingDataComponents.MUTABILITY));
    }

    public static void copyTraitsToStack(ItemStack in, ItemStack stack) {
        stack.set(FarmingDataComponents.GROWTH, (Object)((Integer)in.getOrDefault(FarmingDataComponents.GROWTH, (Object)0)));
        stack.set(FarmingDataComponents.YIELD, (Object)((Integer)in.getOrDefault(FarmingDataComponents.YIELD, (Object)0)));
        stack.set(FarmingDataComponents.RESISTANCE, (Object)((Integer)in.getOrDefault(FarmingDataComponents.RESISTANCE, (Object)0)));
        stack.set(FarmingDataComponents.MUTABILITY, (Object)((Integer)in.getOrDefault(FarmingDataComponents.MUTABILITY, (Object)0)));
    }

    public static int getDefaultTrait(Holder<Item> item, Supplier<DataComponentType<Integer>> trait) {
        CropTrait data = (CropTrait)item.getData(FarmingRegistrator.CROP_TRAITS);
        if (data != null) {
            String traitName;
            return switch (traitName = BuiltInRegistries.DATA_COMPONENT_TYPE.getKey(trait.get()).getPath()) {
                case GROWTH -> data.growth();
                case YIELD -> data.yield();
                case RESISTANCE -> data.resistance();
                case MUTABILITY -> data.mutability();
                default -> throw new IllegalStateException("Unexpected value: " + traitName);
            };
        }
        return 0;
    }
}

