/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivefarming.util;

import com.mojang.datafixers.util.Pair;
import cy.jdkdigital.productivefarming.Config;
import cy.jdkdigital.productivefarming.ProductiveFarming;
import cy.jdkdigital.productivefarming.common.block.entity.ColorfulFlowerBlockEntity;
import cy.jdkdigital.productivefarming.common.block.entity.CropBlockEntity;
import cy.jdkdigital.productivefarming.recipe.CropMutationRecipe;
import cy.jdkdigital.productivefarming.registry.FarmingDataComponents;
import cy.jdkdigital.productivefarming.registry.FarmingRegistrator;
import cy.jdkdigital.productivefarming.registry.ModTags;
import cy.jdkdigital.productivelib.util.ColorUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.fml.ModList;

public class FarmUtil {
    public static Map<ResourceLocation, Integer> VANILLA_FLOWER_COLORS = new HashMap<ResourceLocation, Integer>(){
        {
            this.put(ResourceLocation.parse((String)"minecraft:rose_bush"), -47808);
            this.put(ResourceLocation.parse((String)"minecraft:lilac"), -2190351);
            this.put(ResourceLocation.parse((String)"minecraft:peony"), -2190351);
            this.put(ResourceLocation.parse((String)"minecraft:poppy"), -47808);
            this.put(ResourceLocation.parse((String)"minecraft:cornflower"), -9269263);
            this.put(ResourceLocation.parse((String)"minecraft:alium"), -1519618);
            this.put(ResourceLocation.parse((String)"minecraft:azure_bluet"), -526345);
            this.put(ResourceLocation.parse((String)"minecraft:blue_orchid"), -13644035);
            this.put(ResourceLocation.parse((String)"minecraft:dandelion"), -5041);
            this.put(ResourceLocation.parse((String)"minecraft:lily_of_the_valley"), -1);
            this.put(ResourceLocation.parse((String)"minecraft:oxeye_daisy"), -1);
            this.put(ResourceLocation.parse((String)"minecraft:white_tulip"), -526345);
            this.put(ResourceLocation.parse((String)"minecraft:red_tulip"), -47808);
            this.put(ResourceLocation.parse((String)"minecraft:pink_tulip"), -597249);
            this.put(ResourceLocation.parse((String)"minecraft:orange_tulip"), -942811);
            this.put(ResourceLocation.parse((String)"minecraft:torchflower"), -204201);
            this.put(ResourceLocation.parse((String)"minecraft:wither_rose"), -12438226);
        }
    };
    public static Map<Integer, ResourceLocation> DYE_COLORS = new HashMap<Integer, ResourceLocation>(){
        {
            this.put(-6447721, ResourceLocation.parse((String)"minecraft:light_gray_dye"));
            this.put(-12103854, ResourceLocation.parse((String)"minecraft:gray_dye"));
            this.put(-393218, ResourceLocation.parse((String)"minecraft:white_dye"));
            this.put(-3715395, ResourceLocation.parse((String)"minecraft:magenta_dye"));
            this.put(-14869215, ResourceLocation.parse((String)"minecraft:black_dye"));
            this.put(-8337633, ResourceLocation.parse((String)"minecraft:lime_dye"));
            this.put(-425955, ResourceLocation.parse((String)"minecraft:orange_dye"));
            this.put(-12930086, ResourceLocation.parse((String)"minecraft:light_blue_dye"));
            this.put(-816214, ResourceLocation.parse((String)"minecraft:pink_dye"));
            this.put(-8170446, ResourceLocation.parse((String)"minecraft:brown_dye"));
            this.put(-10585066, ResourceLocation.parse((String)"minecraft:green_dye"));
            this.put(-15295332, ResourceLocation.parse((String)"minecraft:cyan_dye"));
            this.put(-12827478, ResourceLocation.parse((String)"minecraft:blue_dye"));
            this.put(-7785800, ResourceLocation.parse((String)"minecraft:purple_dye"));
            this.put(-47808, ResourceLocation.parse((String)"minecraft:red_dye"));
            this.put(-75715, ResourceLocation.parse((String)"minecraft:yellow_dye"));
        }
    };
    public static Map<Integer, ResourceLocation> DYENAMICS_DYE_COLORS = new HashMap<Integer, ResourceLocation>(){
        {
            this.put(-2997991, ResourceLocation.parse((String)"dyenamics:persimmon_dye"));
            this.put(-19386, ResourceLocation.parse((String)"dyenamics:honey_dye"));
            this.put(-13861505, ResourceLocation.parse((String)"dyenamics:aquamarine_dye"));
            this.put(-560698, ResourceLocation.parse((String)"dyenamics:bubblegum_dye"));
            this.put(-16672561, ResourceLocation.parse((String)"dyenamics:cherenkov_dye"));
            this.put(-7345409, ResourceLocation.parse((String)"dyenamics:icy_blue_dye"));
            this.put(-4220813, ResourceLocation.parse((String)"dyenamics:peach_dye"));
            this.put(-1119818, ResourceLocation.parse((String)"dyenamics:fluorescent_dye"));
            this.put(-4531627, ResourceLocation.parse((String)"dyenamics:conifer_dye"));
            this.put(-9298341, ResourceLocation.parse((String)"dyenamics:wine_dye"));
            this.put(-11122177, ResourceLocation.parse((String)"dyenamics:ultramarine_dye"));
            this.put(-55195, ResourceLocation.parse((String)"dyenamics:rose_dye"));
            this.put(-7739208, ResourceLocation.parse((String)"dyenamics:mint_dye"));
            this.put(-14931855, ResourceLocation.parse((String)"dyenamics:navy_dye"));
            this.put(-2919655, ResourceLocation.parse((String)"dyenamics:amber_dye"));
            this.put(-3932263, ResourceLocation.parse((String)"dyenamics:spring_green_dye"));
            this.put(-7274496, ResourceLocation.parse((String)"dyenamics:maroon_dye"));
            this.put(-2254337, ResourceLocation.parse((String)"dyenamics:lavender_dye"));
        }
    };

    public static String getLatinTranslationKey(Item item) {
        String key = BuiltInRegistries.ITEM.getKey((Object)item).getPath().replace("_seeds", "").replace("_stem", "");
        return "tooltip.productivefarming." + key + ".latin";
    }

    public static void pollinateCrops(Level level, BlockPos pos, int distance, boolean isSpecialPollinator, List<ResourceLocation> uniqueCrops) {
        List<BlockPos> crops = BlockPos.betweenClosedStream((BlockPos)pos.offset(-distance, -distance, -distance), (BlockPos)pos.offset(distance, distance, distance)).map(BlockPos::immutable).toList();
        HashMap flowerMap = new HashMap();
        HashMap cropMap = new HashMap();
        crops.forEach(blockPos -> {
            CropBlock cropBlock;
            Block patt0$temp;
            BlockState state = level.getBlockState(blockPos);
            if (state.is(ModTags.Blocks.POLLINATABLE) && (!((patt0$temp = state.getBlock()) instanceof CropBlock) || (cropBlock = (CropBlock)patt0$temp).isMaxAge(state))) {
                ResourceLocation stateKey = BuiltInRegistries.BLOCK.getKey((Object)state.getBlock());
                cropMap.put(stateKey, blockPos);
                if (state.is(BlockTags.FLOWERS)) {
                    flowerMap.put(stateKey, blockPos);
                }
                if (!uniqueCrops.contains(stateKey)) {
                    uniqueCrops.add(stateKey);
                }
            }
        });
        if (!uniqueCrops.isEmpty()) {
            BlockEntity blockEntity;
            if ((double)level.getRandom().nextFloat() < (Double)Config.SERVER.flowerPropagationChance.get() && flowerMap.size() > 1) {
                String pBeeFlower;
                BlockState newFlower;
                ArrayList keys = new ArrayList(flowerMap.keySet());
                Collections.shuffle(keys);
                List randomFlowers = keys.subList(0, 2);
                int colorA = VANILLA_FLOWER_COLORS.getOrDefault(randomFlowers.getFirst(), 0);
                BlockEntity blockEntity2 = level.getBlockEntity((BlockPos)flowerMap.get(randomFlowers.getFirst()));
                if (blockEntity2 instanceof ColorfulFlowerBlockEntity) {
                    ColorfulFlowerBlockEntity flowerBlockEntity = (ColorfulFlowerBlockEntity)blockEntity2;
                    colorA = flowerBlockEntity.getColor();
                }
                int colorB = VANILLA_FLOWER_COLORS.getOrDefault(randomFlowers.getLast(), 0);
                blockEntity = level.getBlockEntity((BlockPos)flowerMap.get(randomFlowers.getLast()));
                if (blockEntity instanceof ColorfulFlowerBlockEntity) {
                    ColorfulFlowerBlockEntity flowerBlockEntity = (ColorfulFlowerBlockEntity)blockEntity;
                    colorB = flowerBlockEntity.getColor();
                }
                if (colorA == 0) {
                    ProductiveFarming.LOGGER.debug("missing flower color for " + String.valueOf(randomFlowers.getFirst()));
                }
                if (colorB == 0) {
                    ProductiveFarming.LOGGER.debug("missing flower color for " + String.valueOf(randomFlowers.getLast()));
                }
                if (colorA != 0 && colorB != 0 && (newFlower = ((Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)(pBeeFlower = ((ResourceLocation)randomFlowers.getFirst()).getPath().replace("red_tulip", "tulip").replace("orange_tulip", "tulip").replace("white_tulip", "tulip").replace("pink_tulip", "tulip"))))).defaultBlockState()).is(BlockTags.FLOWERS)) {
                    List list = BlockPos.betweenClosedStream((BlockPos)pos.offset(-distance, -distance + 2, -distance), (BlockPos)pos.offset(distance, distance - 2, distance)).map(BlockPos::immutable).collect(Collectors.toList());
                    Collections.shuffle(list);
                    for (BlockPos blockPos2 : list) {
                        if (!level.getBlockState(blockPos2).canBeReplaced() || !newFlower.canSurvive((LevelReader)level, blockPos2) || !level.setBlock(blockPos2, newFlower, 11)) continue;
                        BlockEntity blockEntity3 = level.getBlockEntity(blockPos2);
                        if (blockEntity3 instanceof ColorfulFlowerBlockEntity) {
                            ColorfulFlowerBlockEntity flowerBlockEntity = (ColorfulFlowerBlockEntity)blockEntity3;
                            flowerBlockEntity.setColor(ColorUtil.blend((int)colorA, (int)colorB, (float)Mth.lerp((float)level.random.nextFloat(), (float)0.3f, (float)0.7f)));
                            if (newFlower.is(BlockTags.TALL_FLOWERS)) {
                                level.setBlockAndUpdate(blockPos2.above(), (BlockState)newFlower.setValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF, (Comparable)DoubleBlockHalf.UPPER));
                                BlockEntity blockEntity4 = level.getBlockEntity(blockPos2.above());
                                if (blockEntity4 instanceof ColorfulFlowerBlockEntity) {
                                    ColorfulFlowerBlockEntity flowerBlockEntityAbove = (ColorfulFlowerBlockEntity)blockEntity4;
                                    flowerBlockEntityAbove.setColor(flowerBlockEntity.getColor());
                                }
                            }
                        }
                        return;
                    }
                }
            }
            HashMap matchedRecipes = new HashMap();
            List allRecipes = level.getRecipeManager().getAllRecipesFor((RecipeType)FarmingRegistrator.CROP_MUTATION_TYPE.get());
            allRecipes.forEach(cropPollinationRecipe -> {
                if (!matchedRecipes.containsKey(cropPollinationRecipe)) {
                    uniqueCrops.forEach(cropA -> uniqueCrops.forEach(cropB -> {
                        if (((CropMutationRecipe)cropPollinationRecipe.value()).matches((ResourceLocation)cropA, (ResourceLocation)cropB)) {
                            matchedRecipes.put(cropPollinationRecipe, Pair.of((Object)cropA, (Object)cropB));
                        }
                    }));
                }
            });
            if (!matchedRecipes.isEmpty()) {
                RecipeHolder pickedRecipe = (RecipeHolder)matchedRecipes.keySet().toArray()[level.random.nextInt(matchedRecipes.size())];
                BlockPos targetPos = (BlockPos)cropMap.get(((CropMutationRecipe)pickedRecipe.value()).targetCrop());
                float f = level.random.nextFloat();
                float f2 = ((CropMutationRecipe)pickedRecipe.value()).chance();
                int n = isSpecialPollinator ? 5 : 1;
                if (f <= f2 * (float)n && (blockEntity = level.getBlockEntity(targetPos)) instanceof CropBlockEntity) {
                    CropBlockEntity cropBlockEntity = (CropBlockEntity)blockEntity;
                    cropBlockEntity.setMutation(((CropMutationRecipe)pickedRecipe.value()).mutation());
                }
            }
        }
    }

    public static ItemStack getPollen(ResourceLocation crop) {
        ItemStack pollenStack = new ItemStack((ItemLike)FarmingRegistrator.POLLEN.get());
        pollenStack.set(FarmingDataComponents.POLLEN_BLOCK_COMPONENT, (Object)crop);
        return pollenStack;
    }

    public static ItemStack getDyeFromColor(int color) {
        float bestMatch = 0.0f;
        Map<Integer, ResourceLocation> COLOR_MAP = DYE_COLORS;
        if (ModList.get().isLoaded("dyenamics")) {
            COLOR_MAP.putAll(DYENAMICS_DYE_COLORS);
        }
        ResourceLocation matchedColor = null;
        for (Map.Entry<Integer, ResourceLocation> entry : COLOR_MAP.entrySet()) {
            if (bestMatch != 0.0f && !(FarmUtil.colorDiff(entry.getKey(), color) < bestMatch)) continue;
            bestMatch = FarmUtil.colorDiff(entry.getKey(), color);
            matchedColor = entry.getValue();
        }
        return ((Item)BuiltInRegistries.ITEM.get(matchedColor)).getDefaultInstance();
    }

    private static float colorDiff(int color1, int color2) {
        float[] color1Parts = ColorUtil.getCacheColor((int)color1);
        float[] color2Parts = ColorUtil.getCacheColor((int)color2);
        float redDifference = color1Parts[0] - color2Parts[0];
        float greenDifference = color1Parts[1] - color2Parts[1];
        float blueDifference = color1Parts[2] - color2Parts[2];
        return redDifference * redDifference + greenDifference * greenDifference + blueDifference * blueDifference;
    }
}

