/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivefarming.registry;

import cy.jdkdigital.productivefarming.ProductiveFarming;
import cy.jdkdigital.productivefarming.common.block.AttachedFencedStemBlock;
import cy.jdkdigital.productivefarming.common.block.BerryBushBlock;
import cy.jdkdigital.productivefarming.common.block.ClamBlock;
import cy.jdkdigital.productivefarming.common.block.ColorfulFlowerBlock;
import cy.jdkdigital.productivefarming.common.block.ColorfulFlowerPotBlock;
import cy.jdkdigital.productivefarming.common.block.ColorfulTallFlowerBlock;
import cy.jdkdigital.productivefarming.common.block.ColorfulVineBlock;
import cy.jdkdigital.productivefarming.common.block.CrateBlock;
import cy.jdkdigital.productivefarming.common.block.DoubleCropBlock;
import cy.jdkdigital.productivefarming.common.block.FarmControllerBlock;
import cy.jdkdigital.productivefarming.common.block.FarmHatch;
import cy.jdkdigital.productivefarming.common.block.FeedingTroughBlock;
import cy.jdkdigital.productivefarming.common.block.FencedStemBlock;
import cy.jdkdigital.productivefarming.common.block.GrainCropBlock;
import cy.jdkdigital.productivefarming.common.block.HerbBlock;
import cy.jdkdigital.productivefarming.common.block.MushroomGrowthBlock;
import cy.jdkdigital.productivefarming.common.block.TrellisLeafBlock;
import cy.jdkdigital.productivefarming.common.block.VerticalTrellisLeafBlock;
import cy.jdkdigital.productivefarming.common.block.VineLeafBlock;
import cy.jdkdigital.productivefarming.common.block.WaterCropBlock;
import cy.jdkdigital.productivefarming.common.block.WateringTroughBlock;
import cy.jdkdigital.productivefarming.common.block.entity.ColorfulFlowerBlockEntity;
import cy.jdkdigital.productivefarming.common.block.entity.ColorfulFlowerPotBlockEntity;
import cy.jdkdigital.productivefarming.common.block.entity.FarmControllerBlockEntity;
import cy.jdkdigital.productivefarming.common.block.entity.FarmHatchBlockEntity;
import cy.jdkdigital.productivefarming.common.block.entity.FeedingTroughBlockEntity;
import cy.jdkdigital.productivefarming.common.block.entity.FencedLeafBlockEntity;
import cy.jdkdigital.productivefarming.common.block.entity.FencedStemBlockEntity;
import cy.jdkdigital.productivefarming.common.block.entity.FencedVerticalCropBlockEntity;
import cy.jdkdigital.productivefarming.common.block.entity.MushroomGrowthCropBlockEntity;
import cy.jdkdigital.productivefarming.common.block.entity.SimpleCropBlockEntity;
import cy.jdkdigital.productivefarming.common.block.entity.WateringTroughBlockEntity;
import cy.jdkdigital.productivefarming.common.datamap.CropTrait;
import cy.jdkdigital.productivefarming.common.item.CornPipeItem;
import cy.jdkdigital.productivefarming.common.item.CropBlockItem;
import cy.jdkdigital.productivefarming.common.item.CropItem;
import cy.jdkdigital.productivefarming.common.item.PollenItem;
import cy.jdkdigital.productivefarming.common.item.SeedBagItem;
import cy.jdkdigital.productivefarming.common.item.StemGrowinSeedItem;
import cy.jdkdigital.productivefarming.inventory.FarmControllerContainer;
import cy.jdkdigital.productivefarming.inventory.FeedingTroughContainer;
import cy.jdkdigital.productivefarming.recipe.CropFruitingRecipe;
import cy.jdkdigital.productivefarming.recipe.CropMutationRecipe;
import cy.jdkdigital.productivefarming.recipe.FlowerDyeCraftingRecipe;
import cy.jdkdigital.productivefarming.util.CropConfig;
import cy.jdkdigital.productivefarming.util.FishConfig;
import cy.jdkdigital.productivefarming.util.FlowerConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.food.Foods;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MobBucketItem;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.AttachedStemBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StemBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.neoforged.neoforge.common.DeferredSpawnEggItem;
import net.neoforged.neoforge.common.SoundActions;
import net.neoforged.neoforge.common.extensions.IMenuTypeExtension;
import net.neoforged.neoforge.fluids.BaseFlowingFluid;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.datamaps.DataMapType;

public class FarmingRegistrator {
    public static final FoodProperties LEAFY = new FoodProperties.Builder().nutrition(1).build();
    public static List<CropConfig> VANILLA_CROPS = new ArrayList<CropConfig>(){
        {
            this.add(new CropConfig("wheat", true, null, GrainCropBlock::new));
            this.add(new CropConfig("potato", false, Foods.POTATO, GrainCropBlock::new));
            this.add(new CropConfig("carrot", false, Foods.CARROT, GrainCropBlock::new));
            this.add(new CropConfig("beetroot", true, Foods.BEETROOT, GrainCropBlock::new));
        }
    };
    public static List<CropConfig> CROPS = new ArrayList<CropConfig>(){
        {
            this.add(new CropConfig("arrowroot", false, Foods.POTATO));
            this.add(new CropConfig("arugula", true, LEAFY));
            this.add(new CropConfig("green_bell_pepper", false, Foods.BEETROOT));
            this.add(new CropConfig("yellow_bell_pepper", false, Foods.BEETROOT));
            this.add(new CropConfig("orange_bell_pepper", false, Foods.BEETROOT));
            this.add(new CropConfig("red_bell_pepper", false, Foods.BEETROOT));
            this.add(new CropConfig("black_bell_pepper", false, Foods.BEETROOT));
            this.add(new CropConfig("purple_bell_pepper", false, Foods.BEETROOT));
            this.add(new CropConfig("white_bell_pepper", false, Foods.BEETROOT));
            this.add(new CropConfig("black_beans", false, null));
            this.add(new CropConfig("bok_choy", true, LEAFY));
            this.add(new CropConfig("broccoli", true, LEAFY));
            this.add(new CropConfig("brussels_sprout", true, LEAFY));
            this.add(new CropConfig("burdock_root", false, Foods.BEETROOT));
            this.add(new CropConfig("butterhead_lettuce", true, LEAFY));
            this.add(new CropConfig("cabbage", true, LEAFY));
            this.add(new CropConfig("catnip", true, null));
            this.add(new CropConfig("cauliflower", true, Foods.BEETROOT));
            this.add(new CropConfig("caraway", false, null));
            this.add(new CropConfig("celery", true, LEAFY));
            this.add(new CropConfig("chard", true, LEAFY));
            this.add(new CropConfig("chamomile", true, null));
            this.add(new CropConfig("chili_pepper", false, Foods.BEETROOT));
            this.add(new CropConfig("collard", true, LEAFY));
            this.add(new CropConfig("daikon", true, LEAFY));
            this.add(new CropConfig("eddoe", false, Foods.BEETROOT));
            this.add(new CropConfig("eggplant", false, Foods.BEETROOT));
            this.add(new CropConfig("endive", true, LEAFY));
            this.add(new CropConfig("flax", true, null));
            this.add(new CropConfig("garlic", false, Foods.BEETROOT));
            this.add(new CropConfig("iceberg_lettuce", true, LEAFY));
            this.add(new CropConfig("jalapeno", false, Foods.BEETROOT));
            this.add(new CropConfig("kale", true, LEAFY));
            this.add(new CropConfig("kidney_beans", false, null));
            this.add(new CropConfig("kohlrabi", true, Foods.BEETROOT));
            this.add(new CropConfig("leek", true, Foods.BEETROOT));
            this.add(new CropConfig("lima_beans", false, null));
            this.add(new CropConfig("onion", true, Foods.BEETROOT));
            this.add(new CropConfig("parsnip", true, Foods.BEETROOT));
            this.add(new CropConfig("peas", false, Foods.BEETROOT));
            this.add(new CropConfig("pinto_beans", false, null));
            this.add(new CropConfig("pineapple", false, Foods.BEETROOT));
            this.add(new CropConfig("radish", true, Foods.BEETROOT));
            this.add(new CropConfig("rhubarb", false, Foods.BEETROOT));
            this.add(new CropConfig("romain_lettuce", true, LEAFY));
            this.add(new CropConfig("rutabaga", true, Foods.BEETROOT));
            this.add(new CropConfig("salsify", true, Foods.BEETROOT));
            this.add(new CropConfig("soy_bean", false, Foods.BEETROOT));
            this.add(new CropConfig("spinach", true, LEAFY));
            this.add(new CropConfig("strawberry", false, Foods.SWEET_BERRIES));
            this.add(new CropConfig("sugar_beet", true, Foods.BEETROOT));
            this.add(new CropConfig("sweet_marjoram", true, null));
            this.add(new CropConfig("turnip", true, Foods.BEETROOT));
            this.add(new CropConfig("ulluco", false, Foods.POTATO));
            this.add(new CropConfig("wasabi", true, null));
            this.add(new CropConfig("blue_borage", true, null));
            this.add(new CropConfig("peanuts", false, Foods.BEETROOT));
            this.add(new CropConfig("ginger", false, Foods.BEETROOT));
            this.add(new CropConfig("green_bean", false, Foods.BEETROOT));
            this.add(new CropConfig("spring_onion", true, LEAFY));
            this.add(new CropConfig("sweet_potato", false, Foods.BEETROOT));
            this.add(new CropConfig("lentils", false, null));
            this.add(new CropConfig("chickpeas", false, null));
            this.add(new CropConfig("mustard", false, null));
            this.add(new CropConfig("tea", true, null));
            this.add(new CropConfig("wintergreen", false, BERRY_FOOD));
            this.add(new CropConfig("hops", false, null));
            this.add(new CropConfig("rice", true, null, GrainCropBlock::new));
            this.add(new CropConfig("oats", true, null, GrainCropBlock::new));
            this.add(new CropConfig("barley", true, null, GrainCropBlock::new));
            this.add(new CropConfig("rye", true, null, GrainCropBlock::new));
            this.add(new CropConfig("teff", true, null, GrainCropBlock::new));
            this.add(new CropConfig("amaranth", true, null, DoubleCropBlock::new));
            this.add(new CropConfig("sorghum", true, null, DoubleCropBlock::new));
            this.add(new CropConfig("quinoa", true, null, DoubleCropBlock::new));
            this.add(new CropConfig("agave", false, Foods.SWEET_BERRIES, DoubleCropBlock::new));
            this.add(new CropConfig("ferula", true, Foods.SWEET_BERRIES, DoubleCropBlock::new));
            this.add(new CropConfig("cardamon", false, Foods.SWEET_BERRIES, DoubleCropBlock::new));
            this.add(new CropConfig("cassava", false, null, DoubleCropBlock::new));
            this.add(new CropConfig("pitaya", false, Foods.SWEET_BERRIES, DoubleCropBlock::new));
            this.add(new CropConfig("monstera_deliciosa", false, Foods.SWEET_BERRIES, DoubleCropBlock::new));
            this.add(new CropConfig("tobacco", true, null, DoubleCropBlock::new));
            this.add(new CropConfig("black_pepper", false, null, DoubleCropBlock::new));
            this.add(new CropConfig("jute", true, Foods.BEETROOT, DoubleCropBlock::new));
            this.add(new CropConfig("cotton", true, null, DoubleCropBlock::new));
            this.add(new CropConfig("turmeric", false, null, DoubleCropBlock::new));
            this.add(new CropConfig("black_aztec_corn", false, Foods.BEETROOT, DoubleCropBlock::new, -15132375));
            this.add(new CropConfig("blue_jade_corn", false, Foods.BEETROOT, DoubleCropBlock::new, -7230236));
            this.add(new CropConfig("rainbow_corn", false, Foods.BEETROOT, DoubleCropBlock::new, -5357243));
            this.add(new CropConfig("sugar_pearl_corn", false, Foods.BEETROOT, DoubleCropBlock::new, -1250074));
            this.add(new CropConfig("yellow_dent_corn", false, Foods.BEETROOT, DoubleCropBlock::new, -1392073));
            this.add(new CropConfig("tomatillo", false, Foods.BEETROOT, DoubleCropBlock::new));
            this.add(new CropConfig("huckleberry", false, BERRY_FOOD, DoubleCropBlock::new));
            this.add(new CropConfig("roma_tomato", false, Foods.BEETROOT, DoubleCropBlock::new));
            this.add(new CropConfig("beefsteak_tomato", false, Foods.BEETROOT, DoubleCropBlock::new));
            this.add(new CropConfig("black_beauty_tomato", false, Foods.BEETROOT, DoubleCropBlock::new));
            this.add(new CropConfig("blue_beauty_tomato", false, Foods.BEETROOT, DoubleCropBlock::new));
            this.add(new CropConfig("white_wonder_tomato", false, Foods.BEETROOT, DoubleCropBlock::new));
            this.add(new CropConfig("cherry_tomato", false, Foods.BEETROOT, DoubleCropBlock::new));
            this.add(new CropConfig("chocolate_pear_tomato", false, Foods.BEETROOT, DoubleCropBlock::new));
            this.add(new CropConfig("yellow_pear_tomato", false, Foods.BEETROOT, DoubleCropBlock::new));
            this.add(new CropConfig("sungold_tomato", false, Foods.BEETROOT, DoubleCropBlock::new));
            this.add(new CropConfig("sea_buckthorn", false, Foods.BEETROOT, DoubleCropBlock::new));
            this.add(new CropConfig("konjac", false, Foods.BEETROOT, DoubleCropBlock::new));
            this.add(new CropConfig("okra", false, Foods.BEETROOT, DoubleCropBlock::new));
            this.add(new CropConfig("asparagus", false, Foods.BEETROOT, DoubleCropBlock::new));
            this.add(new CropConfig("artichoke", false, Foods.BEETROOT, DoubleCropBlock::new));
            this.add(new CropConfig("malanga", false, Foods.BEETROOT, DoubleCropBlock::new));
            this.add(new CropConfig("yam", false, Foods.BEETROOT, DoubleCropBlock::new));
            this.add(new CropConfig("water_chestnut", false, null, WaterCropBlock::new));
            this.add(new CropConfig("watercress", false, null, WaterCropBlock::new));
            this.add(new CropConfig("water_caltrop", false, null, WaterCropBlock::new));
        }
    };
    public static List<CropConfig> TRELLIS = new ArrayList<CropConfig>(){
        {
            this.add(new CropConfig("kiwi", false, Foods.BEETROOT, TrellisLeafBlock::new));
            this.add(new CropConfig("goji_berry", false, BERRY_FOOD, TrellisLeafBlock::new));
        }
    };
    public static List<CropConfig> VERTICAL_TRELLIS = new ArrayList<CropConfig>(){
        {
            this.add(new CropConfig("butternut_squash", false, Foods.BEETROOT, VerticalTrellisLeafBlock::new));
            this.add(new CropConfig("spoon_gourd", false, Foods.BEETROOT, VerticalTrellisLeafBlock::new));
            this.add(new CropConfig("luffa", false, Foods.MELON_SLICE, VerticalTrellisLeafBlock::new));
            this.add(new CropConfig("cucumber", false, Foods.MELON_SLICE, VerticalTrellisLeafBlock::new));
            this.add(new CropConfig("vanilla", true, null, VerticalTrellisLeafBlock::new));
            this.add(new CropConfig("zucchini", false, Foods.MELON_SLICE, VerticalTrellisLeafBlock::new));
            this.add(new CropConfig("akebia", false, Foods.APPLE, VerticalTrellisLeafBlock::new));
            this.add(new CropConfig("sarsaparilla", true, null, VerticalTrellisLeafBlock::new));
        }
    };
    public static List<CropConfig> GRAPES = new ArrayList<CropConfig>(){
        {
            this.add(new CropConfig("red_grape", true, Foods.SWEET_BERRIES, VineLeafBlock::new));
            this.add(new CropConfig("green_grape", true, Foods.SWEET_BERRIES, VineLeafBlock::new));
            this.add(new CropConfig("concord_grape", true, Foods.SWEET_BERRIES, VineLeafBlock::new));
            this.add(new CropConfig("cotton_candy_grape", true, Foods.SWEET_BERRIES, VineLeafBlock::new));
        }
    };
    public static List<CropConfig> STEMS = new ArrayList<CropConfig>(){
        {
            this.add(new CropConfig("cantaloupe", true, Foods.MELON_SLICE));
            this.add(new CropConfig("honeydew_melon", true, Foods.MELON_SLICE));
        }
    };
    public static List<CropConfig> HERBS = new ArrayList<CropConfig>(){
        {
            this.add(new CropConfig("basil", true, null, HerbBlock::new));
            this.add(new CropConfig("chives", true, null, HerbBlock::new));
            this.add(new CropConfig("coriander", false, null, HerbBlock::new));
            this.add(new CropConfig("cumin", false, null, HerbBlock::new));
            this.add(new CropConfig("dill", true, null, HerbBlock::new));
            this.add(new CropConfig("fat_hen", true, null, HerbBlock::new));
            this.add(new CropConfig("fenugreek", true, null, HerbBlock::new));
            this.add(new CropConfig("spearmint", true, null, HerbBlock::new));
            this.add(new CropConfig("peppermint", true, null, HerbBlock::new));
            this.add(new CropConfig("watermint", true, null, HerbBlock::new));
            this.add(new CropConfig("lemon_balm", true, null, HerbBlock::new));
            this.add(new CropConfig("lemongrass", true, null, HerbBlock::new));
            this.add(new CropConfig("oregano", true, null, HerbBlock::new));
            this.add(new CropConfig("parsley", true, null, HerbBlock::new));
            this.add(new CropConfig("rosemary", true, null, HerbBlock::new));
            this.add(new CropConfig("sage", true, null, HerbBlock::new));
            this.add(new CropConfig("thyme", true, null, HerbBlock::new));
            this.add(new CropConfig("ostrich_fiddlehead", true, null, HerbBlock::new));
        }
    };
    static final FoodProperties BERRY_FOOD = new FoodProperties.Builder().alwaysEdible().fast().nutrition(1).saturationModifier(0.1f).build();
    public static List<CropConfig> BERRIES = new ArrayList<CropConfig>(){
        {
            this.add(new CropConfig("kadsura", false, BERRY_FOOD, BerryBushBlock::new));
            this.add(new CropConfig("blackberry", false, BERRY_FOOD, BerryBushBlock::new));
            this.add(new CropConfig("blackcurrant", false, BERRY_FOOD, BerryBushBlock::new));
            this.add(new CropConfig("blueberry", false, BERRY_FOOD, BerryBushBlock::new));
            this.add(new CropConfig("boysenberry", false, BERRY_FOOD, BerryBushBlock::new));
            this.add(new CropConfig("cloudberry", false, BERRY_FOOD, BerryBushBlock::new));
            this.add(new CropConfig("cranberry", false, BERRY_FOOD, BerryBushBlock::new));
            this.add(new CropConfig("golden_raspberry", false, BERRY_FOOD, BerryBushBlock::new));
            this.add(new CropConfig("gooseberry", false, BERRY_FOOD, BerryBushBlock::new));
            this.add(new CropConfig("lingoberry", false, BERRY_FOOD, BerryBushBlock::new));
            this.add(new CropConfig("miracle_berry", false, BERRY_FOOD, BerryBushBlock::new));
            this.add(new CropConfig("raspberry", false, BERRY_FOOD, BerryBushBlock::new));
            this.add(new CropConfig("redcurrant", false, BERRY_FOOD, BerryBushBlock::new));
        }
    };
    public static final DeferredHolder<Block, Block> BROWN_MUSHROOM_GROWTH = FarmingRegistrator.registerBlock("brown_mushroom_growth", () -> new MushroomGrowthBlock(new CropConfig("brown_mushroom", false, null), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BROWN_MUSHROOM).replaceable().dynamicShape()), false);
    public static final DeferredHolder<Block, Block> RED_MUSHROOM_GROWTH = FarmingRegistrator.registerBlock("red_mushroom_growth", () -> new MushroomGrowthBlock(new CropConfig("red_mushroom", false, null), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.RED_MUSHROOM).replaceable().dynamicShape()), false);
    public static final DeferredHolder<Block, Block> CRIMSON_FUNGUS_GROWTH = FarmingRegistrator.registerBlock("crimson_fungus_growth", () -> new MushroomGrowthBlock(new CropConfig("crimson_fungus", false, null), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CRIMSON_FUNGUS).replaceable().dynamicShape()), false);
    public static final DeferredHolder<Block, Block> WARPED_FUNGUS_GROWTH = FarmingRegistrator.registerBlock("warped_fungus_growth", () -> new MushroomGrowthBlock(new CropConfig("warped_fungus", false, null), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WARPED_FUNGUS).replaceable().dynamicShape()), false);
    public static List<CropConfig> SHROOMS = new ArrayList<CropConfig>(){
        {
            this.add(new CropConfig("black_truffle", false, null, MushroomGrowthBlock::new));
            this.add(new CropConfig("chanterelle", false, null, MushroomGrowthBlock::new));
            this.add(new CropConfig("laetiporus", false, null, MushroomGrowthBlock::new));
            this.add(new CropConfig("lions_mane", false, null, MushroomGrowthBlock::new));
            this.add(new CropConfig("morel", false, null, MushroomGrowthBlock::new));
            this.add(new CropConfig("oyster_mushroom", false, null, MushroomGrowthBlock::new));
            this.add(new CropConfig("porcini", false, null, MushroomGrowthBlock::new));
            this.add(new CropConfig("portobello", false, null, MushroomGrowthBlock::new));
            this.add(new CropConfig("shiitake", false, null, MushroomGrowthBlock::new));
        }
    };
    public static List<FishConfig> FISHIES = new ArrayList<FishConfig>(){};
    public static List<ResourceLocation> CRATED_CROPS = new ArrayList<ResourceLocation>(){};
    public static List<ResourceLocation> SEED_BAGS = new ArrayList<ResourceLocation>(){
        {
            this.add(ResourceLocation.withDefaultNamespace((String)"pumpkin_seeds"));
            this.add(ResourceLocation.withDefaultNamespace((String)"melon_seeds"));
            this.add(ResourceLocation.withDefaultNamespace((String)"torchflower_seeds"));
            this.add(ResourceLocation.withDefaultNamespace((String)"pitcher_pod"));
        }
    };
    public static List<FlowerConfig> FLOWERS = new ArrayList<FlowerConfig>(){
        {
            this.add(new FlowerConfig("rose_bush", -47808, true, false));
            this.add(new FlowerConfig("lilac", -2190351, true, false));
            this.add(new FlowerConfig("peony", -2190351, true, false));
            this.add(new FlowerConfig("poppy", -47808, false, false));
            this.add(new FlowerConfig("cornflower", -9269263, false, false));
            this.add(new FlowerConfig("alium", -1519618, false, false));
            this.add(new FlowerConfig("azure_bluet", -526345, false, false));
            this.add(new FlowerConfig("blue_orchid", -13644035, false, false));
            this.add(new FlowerConfig("dandelion", -5041, false, false));
            this.add(new FlowerConfig("lily_of_the_valley", -1, false, false));
            this.add(new FlowerConfig("oxeye_daisy", -1, false, false));
            this.add(new FlowerConfig("tulip", -1, false, false));
            this.add(new FlowerConfig("torchflower", -204201, false, false));
            this.add(new FlowerConfig("wither_rose", -12438226, false, false));
            this.add(new FlowerConfig("amaryllis", -6280166, false, false));
            this.add(new FlowerConfig("anemone", -986902, false, false));
            this.add(new FlowerConfig("balloon_flower", -9805884, false, false));
            this.add(new FlowerConfig("black_bearded_iris", -12828090, false, false));
            this.add(new FlowerConfig("cattail", -9020355, true, false));
            this.add(new FlowerConfig("cape_leadwort", -6370845, true, true));
            this.add(new FlowerConfig("chrysanthemum", -2145632, false, false));
            this.add(new FlowerConfig("dahlia", -13750738, false, false));
            this.add(new FlowerConfig("great_lobelia", -11112997, false, false));
            this.add(new FlowerConfig("hellebore", -12692910, false, false));
            this.add(new FlowerConfig("himalayan_poppy", -10693394, true, false));
            this.add(new FlowerConfig("hydrangea", -156234, true, true));
            this.add(new FlowerConfig("motherwort", -4363143, true, false));
            this.add(new FlowerConfig("sea_holly", -12560955, false, false));
            this.add(new FlowerConfig("skullcap", -8631649, false, false));
            this.add(new FlowerConfig("stinging_nettle", -11700945, true, false));
            this.add(new FlowerConfig("valerian_root", -267019, true, false));
            this.add(new FlowerConfig("zinnia", -3497984, true, false));
        }
    };
    public static List<FlowerConfig> VINES = new ArrayList<FlowerConfig>(){
        {
            this.add(new FlowerConfig("blue_jade_vine", -9053232, false, false));
            this.add(new FlowerConfig("butterfly_pea", -12428850, false, false));
            this.add(new FlowerConfig("morning_glory", -8768365, false, false));
        }
    };
    public static DeferredHolder<BlockEntityType<?>, BlockEntityType<FencedVerticalCropBlockEntity>> FENCED_VERTICAL_CROP_BLOCK_ENTITY;
    public static DeferredHolder<BlockEntityType<?>, BlockEntityType<FencedLeafBlockEntity>> FENCED_LEAVES_BLOCK_ENTITY;
    public static DeferredHolder<BlockEntityType<?>, BlockEntityType<FencedStemBlockEntity>> FENCED_STEM_BLOCK_ENTITY;
    public static DeferredHolder<BlockEntityType<?>, BlockEntityType<SimpleCropBlockEntity>> CROP_BLOCK_ENTITY;
    public static DeferredHolder<BlockEntityType<?>, BlockEntityType<ColorfulFlowerBlockEntity>> FLOWER_BLOCK_ENTITY;
    public static DeferredHolder<BlockEntityType<?>, BlockEntityType<ColorfulFlowerPotBlockEntity>> FLOWER_POT_BLOCK_ENTITY;
    public static DeferredHolder<BlockEntityType<?>, BlockEntityType<MushroomGrowthCropBlockEntity>> MUSHROOM_GROWTH_BLOCK_ENTITY;
    static Map<String, Supplier<Block>> registeredBlocks;
    public static final DataMapType<Item, CropTrait> CROP_TRAITS;
    public static final DeferredHolder<Item, Item> POLLEN;
    public static final DeferredHolder<Item, Item> DRIED_LUFFA;
    public static final DeferredHolder<Item, Item> DRIED_TOBACCO;
    public static final DeferredHolder<Item, Item> BLACK_TEA;
    public static final DeferredHolder<Item, Item> CORN_COB_PIPE;
    public static final DeferredHolder<Block, Block> FARM_HATCH;
    public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<FarmHatchBlockEntity>> FARM_HATCH_BLOCK_ENTITY;
    public static final DeferredHolder<Block, Block> FARM_CONTROLLER;
    public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<FarmControllerBlockEntity>> FARM_CONTROLLER_BLOCK_ENTITY;
    public static final DeferredHolder<Block, Block> FEEDING_TROUGH;
    public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<FeedingTroughBlockEntity>> FEEDING_TROUGH_BLOCK_ENTITY;
    public static final DeferredHolder<Block, Block> WATERING_TROUGH;
    public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<WateringTroughBlockEntity>> WATERING_TROUGH_BLOCK_ENTITY;
    public static final DeferredHolder<MenuType<?>, MenuType<FarmControllerContainer>> FARM_CONTROLLER_MENU;
    public static final DeferredHolder<MenuType<?>, MenuType<FeedingTroughContainer>> FEEDING_TROUGH_MENU;
    public static final DeferredHolder<RecipeSerializer<?>, RecipeSerializer<?>> CROP_FRUITING;
    public static final DeferredHolder<RecipeType<?>, RecipeType<CropFruitingRecipe>> CROP_FRUITING_TYPE;
    public static final DeferredHolder<RecipeSerializer<?>, RecipeSerializer<?>> CROP_MUTATION;
    public static final DeferredHolder<RecipeType<?>, RecipeType<CropMutationRecipe>> CROP_MUTATION_TYPE;
    public static final DeferredHolder<RecipeSerializer<?>, RecipeSerializer<?>> FLOWER_DYE_CRAFTING;
    public static final DeferredHolder<Fluid, BaseFlowingFluid.Source> NUTRIENT_WATER;
    public static final ResourceKey<CreativeModeTab> TAB_KEY;
    public static final DeferredHolder<CreativeModeTab, CreativeModeTab> TAB;

    public static void init() {
        VANILLA_CROPS.forEach(crop -> {
            DeferredHolder<Block, Block> cropBlock = FarmingRegistrator.registerBlock(crop.name(), () -> crop.supplier().create((CropConfig)crop, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WHEAT)), false);
            registeredBlocks.put(crop.name(), (Supplier<Block>)cropBlock);
            if (crop.food() != null) {
                CRATED_CROPS.add(ResourceLocation.withDefaultNamespace((String)crop.name()));
            }
            if (crop.hasSeed()) {
                SEED_BAGS.add(ResourceLocation.withDefaultNamespace((String)(crop.name() + "_seeds")));
            }
        });
        CROPS.forEach(crop -> {
            registeredBlocks.put(crop.name(), (Supplier<Block>)FarmingRegistrator.registerPlantableCrop(crop, () -> crop.supplier().create((CropConfig)crop, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WHEAT))));
            if (crop.food() != null) {
                CRATED_CROPS.add(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)crop.name()));
            }
            if (crop.hasSeed()) {
                SEED_BAGS.add(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)(crop.name() + "_seeds")));
            }
        });
        TRELLIS.forEach(crop -> {
            registeredBlocks.put(crop.name() + "_leaves", (Supplier<Block>)FarmingRegistrator.registerBlock(crop.name() + "_leaves", () -> crop.supplier().create((CropConfig)crop, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CHERRY_LEAVES).offsetType(BlockBehaviour.OffsetType.XYZ).dynamicShape()), false));
            registeredBlocks.put(crop.name(), (Supplier<Block>)FarmingRegistrator.registerPlantableCrop(crop, () -> new FencedStemBlock((CropConfig)crop, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.MELON_STEM)), StemGrowinSeedItem::new));
            registeredBlocks.put("attached_" + crop.name() + "_stem", (Supplier<Block>)FarmingRegistrator.registerBlock("attached_" + crop.name() + "_stem", () -> new AttachedFencedStemBlock((CropConfig)crop, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.ATTACHED_MELON_STEM)), false));
            if (crop.food() != null) {
                CRATED_CROPS.add(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)crop.name()));
            }
        });
        VERTICAL_TRELLIS.forEach(crop -> {
            registeredBlocks.put(crop.name(), (Supplier<Block>)FarmingRegistrator.registerPlantableCrop(crop, () -> crop.supplier().create((CropConfig)crop, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CHERRY_LEAVES).offsetType(BlockBehaviour.OffsetType.XYZ).dynamicShape()), StemGrowinSeedItem::new));
            if (crop.food() != null) {
                CRATED_CROPS.add(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)crop.name()));
            }
        });
        GRAPES.forEach(crop -> {
            registeredBlocks.put(crop.name() + "_leaves", (Supplier<Block>)FarmingRegistrator.registerBlock(crop.name() + "_leaves", () -> crop.supplier().create((CropConfig)crop, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CHERRY_LEAVES).offsetType(BlockBehaviour.OffsetType.XYZ).dynamicShape()), false));
            registeredBlocks.put(crop.name(), (Supplier<Block>)FarmingRegistrator.registerPlantableCrop(crop, () -> new FencedStemBlock((CropConfig)crop, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.MELON_STEM)), StemGrowinSeedItem::new));
            registeredBlocks.put("attached_" + crop.name() + "_stem", (Supplier<Block>)FarmingRegistrator.registerBlock("attached_" + crop.name() + "_stem", () -> new AttachedFencedStemBlock((CropConfig)crop, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.ATTACHED_MELON_STEM)), false));
            if (crop.food() != null) {
                CRATED_CROPS.add(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)crop.name()));
            }
        });
        STEMS.forEach(crop -> {
            FarmingRegistrator.registerItem(crop.name() + "_slice", crop.food());
            FarmingRegistrator.registerItem(crop.name() + "_seeds", () -> new CropBlockItem(registeredBlocks.get(crop.name() + "_stem").get(), new Item.Properties()));
            registeredBlocks.put(crop.name(), (Supplier<Block>)FarmingRegistrator.registerBlock(crop.name(), () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.MELON)), true));
            registeredBlocks.put(crop.name() + "_stem", (Supplier<Block>)FarmingRegistrator.registerBlock(crop.name() + "_stem", () -> new StemBlock(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)crop.name())), ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)("attached_" + crop.name() + "_stem"))), ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)(crop.name() + "_seeds"))), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.MELON_STEM)), false));
            registeredBlocks.put("attached_" + crop.name() + "_stem", (Supplier<Block>)FarmingRegistrator.registerBlock("attached_" + crop.name() + "_stem", () -> new AttachedStemBlock(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)(crop.name() + "_stem"))), ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)crop.name())), ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)(crop.name() + "_seeds"))), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.MELON_STEM)), false));
            CRATED_CROPS.add(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)crop.name()));
        });
        HERBS.forEach(crop -> {
            registeredBlocks.put(crop.name(), (Supplier<Block>)FarmingRegistrator.registerPlantableCrop(crop, () -> crop.supplier().create((CropConfig)crop, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SHORT_GRASS).dynamicShape())));
            if (crop.food() != null) {
                CRATED_CROPS.add(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)crop.name()));
            }
        });
        BERRIES.forEach(crop -> {
            registeredBlocks.put(crop.name(), (Supplier<Block>)FarmingRegistrator.registerPlantableCrop(crop, () -> crop.supplier().create((CropConfig)crop, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SWEET_BERRY_BUSH).dynamicShape())));
            if (crop.food() != null) {
                CRATED_CROPS.add(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)crop.name()));
            }
        });
        SHROOMS.forEach(crop -> {
            FarmingRegistrator.registerItem(crop.name(), () -> new CropBlockItem(registeredBlocks.get(crop.name() + "_growth").get(), new Item.Properties()));
            registeredBlocks.put(crop.name() + "_growth", (Supplier<Block>)FarmingRegistrator.registerBlock(crop.name() + "_growth", () -> crop.supplier().create((CropConfig)crop, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BROWN_MUSHROOM).replaceable().dynamicShape()), false));
        });
        FISHIES.forEach(fish -> {
            if (fish.entitySupplier() != null) {
                FarmingRegistrator.registerFishEntity(fish.name(), fish.entitySupplier());
            }
            if (fish.hasBlock()) {
                registeredBlocks.put(fish.name(), (Supplier<Block>)FarmingRegistrator.registerBlock(fish.name(), () -> new ClamBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BRAIN_CORAL)), true));
                CRATED_CROPS.add(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)fish.name()));
            } else {
                FarmingRegistrator.registerItem("raw_" + fish.name());
                CRATED_CROPS.add(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)("raw_" + fish.name())));
            }
            FarmingRegistrator.registerItem("cooked_" + fish.name());
            CRATED_CROPS.add(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)("cooked_" + fish.name())));
        });
        CRATED_CROPS.forEach(crate -> registeredBlocks.put(crate.getPath() + "_crate", (Supplier<Block>)FarmingRegistrator.registerBlock(crate.getPath() + "_crate", () -> new CrateBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BARREL)), true)));
        SEED_BAGS.forEach(seedName -> FarmingRegistrator.registerItem(seedName.getPath() + "_bag", () -> new SeedBagItem((ResourceLocation)seedName, new Item.Properties())));
        FLOWERS.forEach(flowerConfig -> {
            DeferredHolder<Block, Block> flower = FarmingRegistrator.registerBlock(flowerConfig.name(), () -> flowerConfig.isDouble() ? new ColorfulTallFlowerBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.ROSE_BUSH), flowerConfig.baseColor()) : new ColorfulFlowerBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.POPPY), flowerConfig.baseColor()), true);
            registeredBlocks.put(flowerConfig.name(), (Supplier<Block>)flower);
            if (!flowerConfig.isDouble()) {
                DeferredHolder<Block, Block> pottedFlower = FarmingRegistrator.registerBlock("potted_" + flowerConfig.name(), () -> new ColorfulFlowerPotBlock(() -> (FlowerPotBlock)Blocks.FLOWER_POT, (Supplier<? extends Block>)flower, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.POTTED_OAK_SAPLING)), false);
                registeredBlocks.put("potted_" + flowerConfig.name(), (Supplier<Block>)pottedFlower);
                ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)flowerConfig.name()), pottedFlower);
            }
        });
        VINES.forEach(flowerConfig -> {
            DeferredHolder<Block, Block> flower = FarmingRegistrator.registerBlock(flowerConfig.name(), () -> new ColorfulVineBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.VINE), flowerConfig.baseColor()), true);
            registeredBlocks.put(flowerConfig.name(), (Supplier<Block>)flower);
        });
        FENCED_VERTICAL_CROP_BLOCK_ENTITY = ProductiveFarming.BLOCK_ENTITIES.register("fenced_crop", () -> BlockEntityType.Builder.of(FencedVerticalCropBlockEntity::new, (Block[])VERTICAL_TRELLIS.stream().map(cropConfig -> registeredBlocks.get(cropConfig.name()).get()).toList().toArray(new Block[0])).build(null));
        FENCED_LEAVES_BLOCK_ENTITY = ProductiveFarming.BLOCK_ENTITIES.register("fenced_leaves", () -> BlockEntityType.Builder.of(FencedLeafBlockEntity::new, (Block[])Stream.concat(TRELLIS.stream(), GRAPES.stream()).map(cropConfig -> registeredBlocks.get(cropConfig.name() + "_leaves").get()).toList().toArray(new Block[0])).build(null));
        FENCED_STEM_BLOCK_ENTITY = ProductiveFarming.BLOCK_ENTITIES.register("fenced_stem", () -> BlockEntityType.Builder.of(FencedStemBlockEntity::new, (Block[])Stream.concat(TRELLIS.stream(), GRAPES.stream()).map(cropConfig -> List.of(registeredBlocks.get("attached_" + cropConfig.name() + "_stem").get(), registeredBlocks.get(cropConfig.name()).get())).flatMap(Collection::stream).toList().toArray(new Block[0])).build(null));
        CROP_BLOCK_ENTITY = ProductiveFarming.BLOCK_ENTITIES.register("crop", () -> BlockEntityType.Builder.of(SimpleCropBlockEntity::new, (Block[])Stream.concat(CROPS.stream(), Stream.concat(VANILLA_CROPS.stream(), Stream.concat(HERBS.stream(), BERRIES.stream()))).map(cropConfig -> List.of(registeredBlocks.get(cropConfig.name()).get(), registeredBlocks.get(cropConfig.name()).get())).flatMap(Collection::stream).toList().toArray(new Block[0])).build(null));
        FLOWER_BLOCK_ENTITY = ProductiveFarming.BLOCK_ENTITIES.register("flower", () -> BlockEntityType.Builder.of(ColorfulFlowerBlockEntity::new, (Block[])FarmingRegistrator.getFlowers()).build(null));
        FLOWER_POT_BLOCK_ENTITY = ProductiveFarming.BLOCK_ENTITIES.register("potted_flower", () -> BlockEntityType.Builder.of(ColorfulFlowerPotBlockEntity::new, (Block[])FarmingRegistrator.getFlowerPots()).build(null));
        MUSHROOM_GROWTH_BLOCK_ENTITY = ProductiveFarming.BLOCK_ENTITIES.register("mushroom_growth", () -> BlockEntityType.Builder.of(MushroomGrowthCropBlockEntity::new, (Block[])FarmingRegistrator.getShrooms()).build(null));
    }

    public static Block[] getAllCrops() {
        return Stream.concat(GRAPES.stream(), Stream.concat(VERTICAL_TRELLIS.stream(), Stream.concat(TRELLIS.stream(), Stream.concat(BERRIES.stream(), Stream.concat(CROPS.stream(), Stream.concat(VANILLA_CROPS.stream(), HERBS.stream())))))).map(cropConfig -> new ArrayList<Block>(Arrays.asList(registeredBlocks.get(cropConfig.name()).get(), registeredBlocks.getOrDefault(cropConfig.name() + "_leaves", () -> null).get()))).flatMap(Collection::stream).filter(Objects::nonNull).distinct().toList().toArray(new Block[0]);
    }

    public static Block[] getShrooms() {
        ArrayList list = SHROOMS.stream().map(cropConfig -> registeredBlocks.get(cropConfig.name() + "_growth").get()).collect(Collectors.toCollection(ArrayList::new));
        list.addAll(List.of((Block)BROWN_MUSHROOM_GROWTH.get(), (Block)RED_MUSHROOM_GROWTH.get(), (Block)CRIMSON_FUNGUS_GROWTH.get(), (Block)WARPED_FUNGUS_GROWTH.get()));
        return list.toArray(new Block[0]);
    }

    public static Block[] getFlowers() {
        return Stream.concat(FLOWERS.stream(), VINES.stream()).map(cropConfig -> registeredBlocks.get(cropConfig.name()).get()).toList().toArray(new Block[0]);
    }

    public static Block[] getFlowerPots() {
        return FLOWERS.stream().filter(flowerConfig -> !flowerConfig.isDouble()).map(cropConfig -> registeredBlocks.get("potted_" + cropConfig.name()).get()).toList().toArray(new Block[0]);
    }

    public static DeferredHolder<Block, Block> registerPlantableCrop(CropConfig crop, Supplier<Block> supplier) {
        return FarmingRegistrator.registerPlantableCrop(crop, supplier, CropBlockItem::new);
    }

    public static DeferredHolder<Block, Block> registerPlantableCrop(CropConfig crop, Supplier<Block> supplier, CropItemSupplier<BlockItem> item) {
        DeferredHolder<Block, Block> cropBlock = FarmingRegistrator.registerBlock(crop.name(), supplier, false);
        if (crop.hasSeed()) {
            FarmingRegistrator.registerItem(crop.name() + "_seeds", () -> item.create((Block)cropBlock.get(), new Item.Properties()));
            if (crop.food() != null) {
                FarmingRegistrator.registerCropItem(crop.name(), crop.food());
            } else {
                FarmingRegistrator.registerItem(crop.name());
            }
        } else if (crop.food() != null) {
            FarmingRegistrator.registerItem(crop.name(), () -> item.create((Block)cropBlock.get(), new Item.Properties().food(crop.food())));
        } else {
            FarmingRegistrator.registerItem(crop.name(), () -> item.create((Block)cropBlock.get(), new Item.Properties()));
        }
        return cropBlock;
    }

    public static DeferredHolder<Item, Item> registerItem(String name) {
        return FarmingRegistrator.registerItem(name, () -> new Item(new Item.Properties()));
    }

    public static DeferredHolder<Item, Item> registerItem(String name, FoodProperties food) {
        return FarmingRegistrator.registerItem(name, () -> new Item(new Item.Properties().food(food)));
    }

    public static DeferredHolder<Item, Item> registerCropItem(String name, FoodProperties food) {
        return FarmingRegistrator.registerItem(name, () -> new CropItem(new Item.Properties().food(food)));
    }

    public static DeferredHolder<Item, Item> registerItem(String name, Supplier<Item> supplier) {
        return ProductiveFarming.ITEMS.register(name, supplier);
    }

    public static DeferredHolder<Block, Block> registerBlock(String name, Supplier<Block> supplier, boolean hasItem) {
        DeferredHolder block = ProductiveFarming.BLOCKS.register(name, supplier);
        if (hasItem) {
            FarmingRegistrator.registerItem(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
        }
        return block;
    }

    public static <E extends Mob> DeferredHolder<EntityType<?>, EntityType<E>> registerFishEntity(String name, EntityType.EntityFactory<E> supplier) {
        EntityType.Builder builder = EntityType.Builder.of(supplier, (MobCategory)MobCategory.WATER_AMBIENT).sized(0.5f, 0.3f).setTrackingRange(4);
        return FarmingRegistrator.registerEntity(name, builder);
    }

    public static <E extends Mob> DeferredHolder<EntityType<?>, EntityType<E>> registerEntity(String name, EntityType.Builder<E> builder) {
        DeferredHolder entity = ProductiveFarming.ENTITY_TYPES.register(name, () -> builder.build("productivefarming:" + name));
        FarmingRegistrator.registerItem(name + "_spawn_egg", () -> new DeferredSpawnEggItem((Supplier)entity, 1510515, 1214544, new Item.Properties()));
        FarmingRegistrator.registerItem(name + "_bucket", () -> new MobBucketItem((EntityType)entity.get(), (Fluid)Fluids.WATER, SoundEvents.BUCKET_EMPTY_FISH, new Item.Properties()));
        return entity;
    }

    public static DeferredHolder<Fluid, BaseFlowingFluid.Source> registerFluid(String name) {
        DeferredHolder TYPE = ProductiveFarming.FLUID_TYPES.register(name, () -> new FluidType(FluidType.Properties.create().descriptionId("block.productivefarming." + name).fallDistanceModifier(0.0f).canExtinguish(true).canConvertToSource(false).supportsBoating(true).sound(SoundActions.BUCKET_FILL, SoundEvents.BUCKET_FILL).sound(SoundActions.BUCKET_EMPTY, SoundEvents.BUCKET_EMPTY).sound(SoundActions.FLUID_VAPORIZE, SoundEvents.FIRE_EXTINGUISH).canHydrate(true)));
        DeferredHolder FLUID = ProductiveFarming.FLUIDS.register(name, () -> new BaseFlowingFluid.Source(FarmingRegistrator.makeFluidProperties((Supplier<? extends FluidType>)TYPE, name)));
        ProductiveFarming.FLUIDS.register(String.format("flowing_%s", name), () -> new BaseFlowingFluid.Flowing(FarmingRegistrator.makeFluidProperties((Supplier<? extends FluidType>)TYPE, name)));
        FarmingRegistrator.registerItem(String.format("%s_bucket", name), () -> new BucketItem((Fluid)FLUID.get(), new Item.Properties().craftRemainder(Items.BUCKET).stacksTo(1)));
        FarmingRegistrator.registerBlock(name, () -> new LiquidBlock((FlowingFluid)FLUID.get(), BlockBehaviour.Properties.of().strength(100.0f).noCollission().liquid().replaceable().pushReaction(PushReaction.DESTROY).noLootTable().sound(SoundType.EMPTY)), false);
        return FLUID;
    }

    private static BaseFlowingFluid.Properties makeFluidProperties(Supplier<? extends FluidType> fluidType, String name) {
        return new BaseFlowingFluid.Properties(fluidType, (Supplier)DeferredHolder.create((ResourceKey)Registries.FLUID, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)name)), (Supplier)DeferredHolder.create((ResourceKey)Registries.FLUID, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)String.format("flowing_%s", name)))).bucket((Supplier)DeferredHolder.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)String.format("%s_bucket", name)))).block((Supplier)DeferredHolder.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)name))).tickRate(30).slopeFindDistance(4).levelDecreasePerBlock(2);
    }

    static {
        registeredBlocks = new HashMap<String, Supplier<Block>>();
        CROP_TRAITS = DataMapType.builder((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)"crop_traits"), (ResourceKey)Registries.ITEM, CropTrait.CODEC).synced(CropTrait.CODEC, false).build();
        POLLEN = FarmingRegistrator.registerItem("pollen", () -> new PollenItem(new Item.Properties()));
        DRIED_LUFFA = FarmingRegistrator.registerItem("dried_luffa");
        DRIED_TOBACCO = FarmingRegistrator.registerItem("dried_tobacco");
        BLACK_TEA = FarmingRegistrator.registerItem("black_tea");
        CORN_COB_PIPE = FarmingRegistrator.registerItem("corn_cob_pipe", () -> new CornPipeItem(new Item.Properties().stacksTo(1).durability(200)));
        FARM_HATCH = FarmingRegistrator.registerBlock("farm_hatch", () -> new FarmHatch(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE_BRICKS)), true);
        FARM_HATCH_BLOCK_ENTITY = ProductiveFarming.BLOCK_ENTITIES.register("farm_hatch", () -> BlockEntityType.Builder.of(FarmHatchBlockEntity::new, (Block[])new Block[]{(Block)FARM_HATCH.get()}).build(null));
        FARM_CONTROLLER = FarmingRegistrator.registerBlock("farm_controller", () -> new FarmControllerBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE_BRICKS).noOcclusion()), true);
        FARM_CONTROLLER_BLOCK_ENTITY = ProductiveFarming.BLOCK_ENTITIES.register("farm_controller", () -> BlockEntityType.Builder.of(FarmControllerBlockEntity::new, (Block[])new Block[]{(Block)FARM_CONTROLLER.get()}).build(null));
        FEEDING_TROUGH = FarmingRegistrator.registerBlock("feeding_trough", () -> new FeedingTroughBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CAULDRON).noOcclusion()), true);
        FEEDING_TROUGH_BLOCK_ENTITY = ProductiveFarming.BLOCK_ENTITIES.register("feeding_trough", () -> BlockEntityType.Builder.of(FeedingTroughBlockEntity::new, (Block[])new Block[]{(Block)FEEDING_TROUGH.get()}).build(null));
        WATERING_TROUGH = FarmingRegistrator.registerBlock("watering_trough", () -> new WateringTroughBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CAULDRON).noOcclusion()), true);
        WATERING_TROUGH_BLOCK_ENTITY = ProductiveFarming.BLOCK_ENTITIES.register("watering_trough", () -> BlockEntityType.Builder.of(WateringTroughBlockEntity::new, (Block[])new Block[]{(Block)WATERING_TROUGH.get()}).build(null));
        FARM_CONTROLLER_MENU = ProductiveFarming.CONTAINER_TYPES.register("farm_controller", () -> IMenuTypeExtension.create(FarmControllerContainer::new));
        FEEDING_TROUGH_MENU = ProductiveFarming.CONTAINER_TYPES.register("feeding_trough", () -> IMenuTypeExtension.create(FeedingTroughContainer::new));
        CROP_FRUITING = ProductiveFarming.RECIPE_SERIALIZERS.register("crop_fruiting", CropFruitingRecipe.Serializer::new);
        CROP_FRUITING_TYPE = ProductiveFarming.RECIPE_TYPES.register("crop_fruiting", () -> new RecipeType<CropFruitingRecipe>(){});
        CROP_MUTATION = ProductiveFarming.RECIPE_SERIALIZERS.register("crop_mutation", CropMutationRecipe.Serializer::new);
        CROP_MUTATION_TYPE = ProductiveFarming.RECIPE_TYPES.register("crop_mutation", () -> new RecipeType<CropMutationRecipe>(){});
        FLOWER_DYE_CRAFTING = ProductiveFarming.RECIPE_SERIALIZERS.register("flower_dye_crafting", FlowerDyeCraftingRecipe.Serializer::new);
        NUTRIENT_WATER = FarmingRegistrator.registerFluid("nutrient_water");
        TAB_KEY = ResourceKey.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)"productivefarming"));
        TAB = ProductiveFarming.CREATIVE_MODE_TABS.register("productivefarming", () -> CreativeModeTab.builder().icon(() -> new ItemStack((ItemLike)FEEDING_TROUGH.get())).title((Component)Component.translatable((String)"itemGroup.productivefarming")).build());
    }

    @FunctionalInterface
    public static interface CropItemSupplier<T extends Item> {
        public T create(Block var1, Item.Properties var2);
    }

    @FunctionalInterface
    public static interface CropBlockSupplier<T extends BushBlock> {
        public T create(CropConfig var1, BlockBehaviour.Properties var2);
    }
}

