/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivefarming.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import cy.jdkdigital.productivefarming.common.block.ColorfulFlowerBlock;
import cy.jdkdigital.productivefarming.common.block.ColorfulTallFlowerBlock;
import cy.jdkdigital.productivefarming.registry.FarmingDataComponents;
import cy.jdkdigital.productivefarming.registry.FarmingRegistrator;
import cy.jdkdigital.productivefarming.util.FarmUtil;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;

public class FlowerDyeCraftingRecipe
implements CraftingRecipe {
    private Integer count;

    public FlowerDyeCraftingRecipe(Integer count) {
        this.count = count;
    }

    public boolean matches(CraftingInput input, Level level) {
        BlockItem blockItem;
        Item item;
        return input.ingredientCount() == 1 && input.getItem(0).has(FarmingDataComponents.COLOR) && (item = input.getItem(0).getItem()) instanceof BlockItem && ((blockItem = (BlockItem)item).getBlock() instanceof ColorfulFlowerBlock || blockItem.getBlock() instanceof ColorfulTallFlowerBlock);
    }

    public boolean isSpecial() {
        return true;
    }

    public ItemStack assemble(CraftingInput input, HolderLookup.Provider registries) {
        ItemStack stack = input.getItem(0);
        if (stack.has(FarmingDataComponents.COLOR)) {
            BlockItem blockItem;
            ItemStack output = FarmUtil.getDyeFromColor((Integer)stack.get(FarmingDataComponents.COLOR));
            Item item = stack.getItem();
            if (item instanceof BlockItem && (blockItem = (BlockItem)item).getBlock() instanceof ColorfulTallFlowerBlock) {
                output.setCount(2);
            }
            return output;
        }
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider registries) {
        return Items.WHITE_DYE.getDefaultInstance();
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)FarmingRegistrator.FLOWER_DYE_CRAFTING.get();
    }

    public CraftingBookCategory category() {
        return CraftingBookCategory.MISC;
    }

    public static class Serializer
    implements RecipeSerializer<FlowerDyeCraftingRecipe> {
        private static final MapCodec<FlowerDyeCraftingRecipe> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Codec.INT.fieldOf("count").orElse((Object)1).forGetter(recipe -> recipe.count)).apply((Applicative)builder, FlowerDyeCraftingRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, FlowerDyeCraftingRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<FlowerDyeCraftingRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, FlowerDyeCraftingRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        public static FlowerDyeCraftingRecipe fromNetwork(@Nonnull RegistryFriendlyByteBuf buffer) {
            return new FlowerDyeCraftingRecipe(buffer.readInt());
        }

        public static void toNetwork(@Nonnull RegistryFriendlyByteBuf buffer, FlowerDyeCraftingRecipe recipe) {
            buffer.writeInt(recipe.count.intValue());
        }
    }
}

