/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivefarming.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import cy.jdkdigital.productivefarming.registry.FarmingRegistrator;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public record CropMutationRecipe(ResourceLocation targetCrop, ResourceLocation pollenCrop, ResourceLocation mutation, float chance) implements Recipe<RecipeInput>
{
    public boolean isSpecial() {
        return true;
    }

    public boolean matches(RecipeInput container, Level level) {
        return false;
    }

    public boolean matches(ResourceLocation targetCrop, ResourceLocation pollenCrop) {
        return this.targetCrop.equals((Object)targetCrop) && this.pollenCrop.equals((Object)pollenCrop);
    }

    public ItemStack assemble(RecipeInput container, HolderLookup.Provider provider) {
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return false;
    }

    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return ItemStack.EMPTY;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)FarmingRegistrator.CROP_MUTATION.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)FarmingRegistrator.CROP_MUTATION_TYPE.get();
    }

    public static class Serializer
    implements RecipeSerializer<CropMutationRecipe> {
        private static final MapCodec<CropMutationRecipe> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)ResourceLocation.CODEC.fieldOf("target").forGetter(recipe -> recipe.targetCrop), (App)ResourceLocation.CODEC.fieldOf("pollen").forGetter(recipe -> recipe.pollenCrop), (App)ResourceLocation.CODEC.fieldOf("mutation").forGetter(recipe -> recipe.mutation), (App)Codec.FLOAT.fieldOf("chance").orElse((Object)Float.valueOf(1.0f)).forGetter(recipe -> Float.valueOf(recipe.chance))).apply((Applicative)builder, CropMutationRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, CropMutationRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<CropMutationRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, CropMutationRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        public static CropMutationRecipe fromNetwork(@Nonnull RegistryFriendlyByteBuf buffer) {
            return new CropMutationRecipe((ResourceLocation)ResourceLocation.STREAM_CODEC.decode((Object)buffer), (ResourceLocation)ResourceLocation.STREAM_CODEC.decode((Object)buffer), (ResourceLocation)ResourceLocation.STREAM_CODEC.decode((Object)buffer), buffer.readFloat());
        }

        public static void toNetwork(@Nonnull RegistryFriendlyByteBuf buffer, CropMutationRecipe recipe) {
            ResourceLocation.STREAM_CODEC.encode((Object)buffer, (Object)recipe.targetCrop);
            ResourceLocation.STREAM_CODEC.encode((Object)buffer, (Object)recipe.pollenCrop);
            ResourceLocation.STREAM_CODEC.encode((Object)buffer, (Object)recipe.mutation);
            buffer.writeFloat(recipe.chance);
        }
    }
}

