/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivefarming.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import cy.jdkdigital.productivefarming.registry.FarmingRegistrator;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class CropFruitingRecipe
implements Recipe<RecipeInput> {
    public final Ingredient crop;
    public final ItemStack result;

    public CropFruitingRecipe(Ingredient crop, ItemStack result) {
        this.crop = crop;
        this.result = result;
    }

    public boolean matches(RecipeInput container, Level level) {
        return false;
    }

    public ItemStack assemble(RecipeInput input, HolderLookup.Provider registries) {
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return false;
    }

    public ItemStack getResultItem(HolderLookup.Provider registries) {
        return this.result.copy();
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)FarmingRegistrator.CROP_FRUITING.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)FarmingRegistrator.CROP_FRUITING_TYPE.get();
    }

    public static class Serializer
    implements RecipeSerializer<CropFruitingRecipe> {
        private static final MapCodec<CropFruitingRecipe> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Ingredient.CODEC.fieldOf("crop").forGetter(recipe -> recipe.crop), (App)ItemStack.CODEC.fieldOf("result").forGetter(recipe -> recipe.result)).apply((Applicative)builder, CropFruitingRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, CropFruitingRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<CropFruitingRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, CropFruitingRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        public static CropFruitingRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
            return new CropFruitingRecipe((Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer), (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer));
        }

        public static void toNetwork(RegistryFriendlyByteBuf buffer, CropFruitingRecipe recipe) {
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.crop);
            ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.result);
        }
    }
}

