/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivefarming.inventory;

import cy.jdkdigital.productivefarming.common.block.FeedingTroughBlock;
import cy.jdkdigital.productivefarming.common.block.entity.FeedingTroughBlockEntity;
import cy.jdkdigital.productivefarming.registry.FarmingRegistrator;
import cy.jdkdigital.productivelib.container.AbstractContainer;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class FeedingTroughContainer
extends AbstractContainer {
    public final FeedingTroughBlockEntity blockEntity;
    private final ContainerLevelAccess canInteractWithCallable;

    public FeedingTroughContainer(int windowId, Inventory playerInventory, FriendlyByteBuf data) {
        this(windowId, playerInventory, FeedingTroughContainer.getTileEntity(playerInventory, data));
    }

    public FeedingTroughContainer(int windowId, Inventory playerInventory, FeedingTroughBlockEntity blockEntity) {
        super((MenuType)FarmingRegistrator.FEEDING_TROUGH_MENU.get(), windowId);
        this.blockEntity = blockEntity;
        this.canInteractWithCallable = ContainerLevelAccess.create((Level)blockEntity.getLevel(), (BlockPos)blockEntity.getBlockPos());
        this.addSlotBox(this.blockEntity.getItemHandler(), 0, 62, 19, 3, 18, 3, 18);
        this.layoutPlayerInventorySlots(playerInventory, 0, 8, 84);
    }

    private static FeedingTroughBlockEntity getTileEntity(Inventory playerInventory, FriendlyByteBuf data) {
        Objects.requireNonNull(playerInventory, "playerInventory cannot be null!");
        Objects.requireNonNull(data, "data cannot be null!");
        BlockEntity tileAtPos = playerInventory.player.level().getBlockEntity(data.readBlockPos());
        if (tileAtPos instanceof FeedingTroughBlockEntity) {
            return (FeedingTroughBlockEntity)tileAtPos;
        }
        throw new IllegalStateException("Block entity is not correct! " + String.valueOf(tileAtPos));
    }

    public boolean stillValid(@Nonnull Player player) {
        return (Boolean)this.canInteractWithCallable.evaluate((world, pos) -> world.getBlockState(pos).getBlock() instanceof FeedingTroughBlock && player.distanceToSqr((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5) <= 64.0, (Object)true);
    }

    protected BlockEntity getBlockEntity() {
        return this.blockEntity;
    }
}

