/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivefarming.inventory;

import cy.jdkdigital.productivefarming.common.block.FarmControllerBlock;
import cy.jdkdigital.productivefarming.common.block.entity.FarmControllerBlockEntity;
import cy.jdkdigital.productivefarming.registry.FarmingRegistrator;
import cy.jdkdigital.productivelib.container.AbstractContainer;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.IItemHandler;

public class FarmControllerContainer
extends AbstractContainer {
    public final FarmControllerBlockEntity blockEntity;
    private final ContainerLevelAccess canInteractWithCallable;

    public FarmControllerContainer(int windowId, Inventory playerInventory, FriendlyByteBuf data) {
        this(windowId, playerInventory, FarmControllerContainer.getTileEntity(playerInventory, data));
    }

    public FarmControllerContainer(int windowId, Inventory playerInventory, FarmControllerBlockEntity blockEntity) {
        super((MenuType)FarmingRegistrator.FARM_CONTROLLER_MENU.get(), windowId);
        this.blockEntity = blockEntity;
        this.canInteractWithCallable = ContainerLevelAccess.create((Level)blockEntity.getLevel(), (BlockPos)blockEntity.getBlockPos());
        this.addSlotBox((IItemHandler)this.blockEntity.inventoryHandler, 0, 8, 19, 9, 18, 3, 18);
        this.layoutPlayerInventorySlots(playerInventory, 0, 8, 84);
    }

    private static FarmControllerBlockEntity getTileEntity(Inventory playerInventory, FriendlyByteBuf data) {
        Objects.requireNonNull(playerInventory, "playerInventory cannot be null!");
        Objects.requireNonNull(data, "data cannot be null!");
        BlockEntity tileAtPos = playerInventory.player.level().getBlockEntity(data.readBlockPos());
        if (tileAtPos instanceof FarmControllerBlockEntity) {
            return (FarmControllerBlockEntity)tileAtPos;
        }
        throw new IllegalStateException("Block entity is not correct! " + String.valueOf(tileAtPos));
    }

    public boolean stillValid(@Nonnull Player player) {
        return (Boolean)this.canInteractWithCallable.evaluate((world, pos) -> world.getBlockState(pos).getBlock() instanceof FarmControllerBlock && player.distanceToSqr((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5) <= 64.0, (Object)true);
    }

    protected BlockEntity getBlockEntity() {
        return this.blockEntity;
    }
}

