/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivefarming.integrations.ponder.scenes;

import cy.jdkdigital.productivefarming.common.block.ProductiveCropBlock;
import cy.jdkdigital.productivefarming.registry.FarmingRegistrator;
import java.util.ArrayList;
import java.util.List;
import net.createmod.ponder.api.scene.SceneBuilder;
import net.createmod.ponder.api.scene.SceneBuildingUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;

public class MultifarmScenes {
    public static void building(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("farm_building", "Building the Multiblock Farm");
        for (int x = 1; x < 8; ++x) {
            for (int z = 1; z < 6; ++z) {
                scene.world().showSection(util.select().position(x, 0, z), Direction.DOWN);
                scene.idle(1);
            }
            if (x != 1) continue;
            scene.overlay().showText(60).text("The minimum size for the farm is 3x3, corners are optional");
        }
        scene.idle(0);
        scene.overlay().showText(60).pointAt(util.vector().of(3.5, 1.0, 3.5)).text("The inside of the farm can be any block you need for your crops").placeNearTarget();
        scene.idle(70);
        scene.addKeyframe();
        scene.overlay().showText(60).pointAt(util.vector().of(3.0, 2.0, 1.0)).text("Additionally, the farm multiblock must have a Farm Controller...").placeNearTarget();
        scene.idle(5);
        scene.world().replaceBlocks(util.select().position(3, 0, 1), ((Block)FarmingRegistrator.FARM_CONTROLLER.get()).defaultBlockState(), true);
        scene.idle(50);
        scene.world().modifyBlock(util.grid().at(3, 0, 1), state -> (BlockState)state.setValue((Property)BlockStateProperties.ATTACHED, (Comparable)Boolean.valueOf(true)), false);
    }

    public static void farming(SceneBuilder scene, SceneBuildingUtil util) {
        int z;
        int x;
        scene.title("farm_farming", "Farming the Multiblock Farm");
        for (int x2 = 1; x2 < 8; ++x2) {
            for (int z2 = 1; z2 < 6; ++z2) {
                scene.world().showSection(util.select().position(x2, 0, z2), Direction.DOWN);
            }
        }
        scene.world().setBlock(util.grid().at(4, 0, 3), Blocks.WATER.defaultBlockState(), false);
        scene.idle(0);
        scene.world().replaceBlocks(util.select().position(3, 0, 1), (BlockState)((Block)FarmingRegistrator.FARM_CONTROLLER.get()).defaultBlockState().setValue((Property)BlockStateProperties.ATTACHED, (Comparable)Boolean.valueOf(true)), false);
        scene.idle(10);
        BlockState watercress = (BlockState)((BlockState)((BlockState)((Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)"watercress"))).defaultBlockState().setValue((Property)ProductiveCropBlock.AGE_6, (Comparable)Integer.valueOf(6))).setValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF, (Comparable)DoubleBlockHalf.LOWER)).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(true));
        scene.world().setBlock(util.grid().at(4, 0, 3), watercress, false);
        for (x = 2; x < 7; ++x) {
            for (z = 2; z < 5; ++z) {
                scene.world().showSection(util.select().position(x, 1, z), Direction.DOWN);
            }
        }
        scene.overlay().showText(60).pointAt(util.vector().of(3.5, 2.0, 2.5)).text("Crops planted on the farm will be automatically harvested").placeNearTarget();
        scene.idle(20);
        scene.addKeyframe();
        for (x = 2; x < 7; ++x) {
            for (z = 2; z < 5; ++z) {
                scene.world().modifyBlock(util.grid().at(x, 1, z), state -> (BlockState)state.setValue((Property)ProductiveCropBlock.AGE_6, (Comparable)Integer.valueOf(1)), false);
                scene.idle(1);
            }
        }
        scene.idle(30);
        scene.overlay().showText(60).pointAt(util.vector().of(3.5, 2.0, 2.5)).text("When crops grow they have a small chance to improve their traits").placeNearTarget();
        scene.idle(20);
        for (x = 2; x < 7; ++x) {
            for (z = 2; z < 5; ++z) {
                scene.world().modifyBlock(util.grid().at(x, 1, z), state -> (BlockState)state.setValue((Property)ProductiveCropBlock.AGE_6, (Comparable)Integer.valueOf(6)), false);
                scene.idle(1);
            }
        }
        scene.idle(40);
    }

    public static void specialCrops(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("farm_special_crops", "Special Crops");
    }

    public static void fishFarming(SceneBuilder scene, SceneBuildingUtil util) {
        int z;
        int x;
        scene.title("fish_farm", "Fish Farms");
        for (x = 1; x < 8; ++x) {
            for (z = 1; z < 6; ++z) {
                for (int y = 0; y < 5; ++y) {
                    scene.world().showSection(util.select().position(x, y, z), Direction.DOWN);
                }
            }
        }
        scene.idle(0);
        scene.world().replaceBlocks(util.select().position(3, 3, 1), (BlockState)((Block)FarmingRegistrator.FARM_CONTROLLER.get()).defaultBlockState().setValue((Property)BlockStateProperties.ATTACHED, (Comparable)Boolean.valueOf(true)), false);
        scene.overlay().showText(60).pointAt(util.vector().of(3.5, 4.0, 2.5)).text("If you make your farm taller you can use it as a fish farm").placeNearTarget();
        scene.idle(70);
        scene.overlay().showText(60).pointAt(util.vector().of(3.5, 4.0, 2.5)).text("Creatures inside the farm boundaries will be automatically bred and slaughtered").placeNearTarget();
        scene.idle(70);
        scene.overlay().showText(60).pointAt(util.vector().of(3.5, 4.0, 2.5)).text("Fish will produce nutrient rich water which can be pumped to a crop farm for increased growth").placeNearTarget();
        scene.idle(70);
        scene.addKeyframe();
        scene.idle(10);
        for (x = 2; x < 7; ++x) {
            for (z = 2; z < 5; ++z) {
                if (x == 4 && z == 3) continue;
                scene.world().setBlock(util.grid().at(x, 3, z), (BlockState)Blocks.FARMLAND.defaultBlockState().setValue((Property)BlockStateProperties.MOISTURE, (Comparable)Integer.valueOf(7)), true);
                scene.idle(1);
                scene.world().setBlock(util.grid().at(x, 4, z), (BlockState)Blocks.POTATOES.defaultBlockState().setValue((Property)BlockStateProperties.AGE_7, (Comparable)Integer.valueOf(7)), true);
                scene.idle(1);
            }
        }
        scene.idle(10);
        scene.overlay().showText(60).pointAt(util.vector().of(3.5, 4.0, 2.5)).text("You can also combine the two farms and have an aquaponics system").placeNearTarget();
        scene.idle(40);
    }

    private static List<BlockPos> generateRingCoordinates(BlockPos bottomLeft, BlockPos topRight) {
        int x;
        int z;
        ArrayList<BlockPos> coords = new ArrayList<BlockPos>();
        int x0 = bottomLeft.getX();
        int z0 = bottomLeft.getZ();
        int x1 = topRight.getX();
        int z1 = topRight.getZ();
        int y = bottomLeft.getY();
        for (z = z0; z <= z1; ++z) {
            coords.add(new BlockPos(x0, y, z));
        }
        for (x = x0 + 1; x <= x1; ++x) {
            coords.add(new BlockPos(x, y, z1));
        }
        for (z = z1 - 1; z >= z0; --z) {
            coords.add(new BlockPos(x1, y, z));
        }
        for (x = x1 - 1; x > x0; --x) {
            coords.add(new BlockPos(x, y, z0));
        }
        return coords;
    }
}

