/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivefarming.integrations.jade;

import cy.jdkdigital.productivefarming.common.block.entity.CropBlockEntity;
import cy.jdkdigital.productivefarming.util.TraitsHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import snownee.jade.api.Accessor;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.StreamServerDataProvider;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.IElementHelper;

public class CropProvider
implements IBlockComponentProvider,
StreamServerDataProvider<BlockAccessor, Data> {
    public static final ResourceLocation UID = ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)"crop");
    static final CropProvider INSTANCE = new CropProvider();

    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        Data data = this.decodeFromData((Accessor)accessor).orElse(null);
        if (data == null) {
            return;
        }
        IElementHelper helper = IElementHelper.get();
        if (data.hasMutation()) {
            tooltip.add((Component)Component.translatable((String)"jade.productivefarming.mutation", (Object[])new Object[]{Component.translatable((String)("block.productivefarming." + data.mutation().getPath()))}));
        }
        if (Minecraft.getInstance().player == null || Minecraft.getInstance().player.isShiftKeyDown()) {
            tooltip.add((Component)Component.translatable((String)"productivefarming.trait.growth", (Object[])new Object[]{TraitsHelper.getValueName("growth", data.growth)}));
            tooltip.add((Component)Component.translatable((String)"productivefarming.trait.yield", (Object[])new Object[]{TraitsHelper.getValueName("yield", data.yield)}));
            tooltip.add((Component)Component.translatable((String)"productivefarming.trait.resistance", (Object[])new Object[]{TraitsHelper.getValueName("resistance", data.resistance)}));
            tooltip.add((Component)Component.translatable((String)"productivefarming.trait.mutability", (Object[])new Object[]{TraitsHelper.getValueName("mutability", data.mutability)}));
        } else {
            tooltip.add((Component)Component.translatable((String)"productivefarming.tooltip.extend").withStyle(ChatFormatting.DARK_GRAY));
        }
    }

    public Data streamData(BlockAccessor accessor) {
        CropBlockEntity access = (CropBlockEntity)accessor.getBlockEntity();
        return new Data(access.getGrowth(), access.getYield(), access.getResistance(), access.getMutability(), access.hasMutation(), access.hasMutation() ? access.getMutation() : ResourceLocation.parse((String)""));
    }

    public StreamCodec<RegistryFriendlyByteBuf, Data> streamCodec() {
        return Data.STREAM_CODEC;
    }

    public ResourceLocation getUid() {
        return UID;
    }

    public record Data(int growth, int yield, int resistance, int mutability, boolean hasMutation, ResourceLocation mutation) {
        public static final StreamCodec<RegistryFriendlyByteBuf, Data> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, Data::growth, (StreamCodec)ByteBufCodecs.INT, Data::yield, (StreamCodec)ByteBufCodecs.INT, Data::resistance, (StreamCodec)ByteBufCodecs.INT, Data::mutability, (StreamCodec)ByteBufCodecs.BOOL, Data::hasMutation, (StreamCodec)ResourceLocation.STREAM_CODEC, Data::mutation, Data::new);
    }
}

