/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivefarming.integrations.botanypots.itemdrops;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import cy.jdkdigital.productivefarming.registry.FarmingDataComponents;
import cy.jdkdigital.productivefarming.util.TraitsHelper;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.darkhax.bookshelf.common.api.util.MathsHelper;
import net.darkhax.botanypots.common.api.context.BotanyPotContext;
import net.darkhax.botanypots.common.api.data.itemdrops.ItemDropProvider;
import net.darkhax.botanypots.common.api.data.itemdrops.ItemDropProviderType;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public record ProductiveDropProvider(List<ProductiveDrop> drops) implements ItemDropProvider
{
    public static final Supplier<ItemDropProviderType<?>> TYPE = ItemDropProviderType.getLazy((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)"productive_drop"));
    public static final MapCodec<ProductiveDropProvider> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ProductiveDrop.CODEC.listOf().fieldOf("items").forGetter(ProductiveDropProvider::drops)).apply((Applicative)instance, ProductiveDropProvider::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ProductiveDropProvider> STREAM = StreamCodec.of((buffer, value) -> ProductiveDrop.STREAM.apply(ByteBufCodecs.list()).encode(buffer, value.drops), buffer -> new ProductiveDropProvider((List)ProductiveDrop.STREAM.apply(ByteBufCodecs.list()).decode(buffer)));

    public void apply(BotanyPotContext context, Level level, Consumer<ItemStack> consumer) {
        this.drops.forEach(drop -> {
            if (MathsHelper.percentChance((double)drop.chance())) {
                ItemStack dropCopy = drop.drop().copy();
                dropCopy.grow(((Integer)context.getSeedItem().getOrDefault(FarmingDataComponents.YIELD, (Object)0)).intValue());
                if (dropCopy.is(context.getSeedItem().getItem())) {
                    TraitsHelper.copyTraitsToStack(context.getSeedItem(), dropCopy);
                }
                consumer.accept(dropCopy);
            }
        });
    }

    public ItemDropProviderType<?> getType() {
        return TYPE.get();
    }

    public List<ItemStack> getDisplayItems() {
        return this.drops.stream().map(ProductiveDrop::drop).collect(Collectors.toList());
    }

    public record ProductiveDrop(ItemStack drop, float chance) {
        public static final Codec<ProductiveDrop> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ItemStack.CODEC.fieldOf("result").forGetter(ProductiveDrop::drop), (App)Codec.floatRange((float)0.0f, (float)1.0f).optionalFieldOf("chance", (Object)Float.valueOf(1.0f)).forGetter(ProductiveDrop::chance)).apply((Applicative)instance, ProductiveDrop::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, ProductiveDrop> STREAM = StreamCodec.composite((StreamCodec)ItemStack.STREAM_CODEC, ProductiveDrop::drop, (StreamCodec)ByteBufCodecs.FLOAT, ProductiveDrop::chance, ProductiveDrop::new);
    }
}

