/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivefarming.event;

import cy.jdkdigital.productivefarming.ProductiveFarming;
import cy.jdkdigital.productivefarming.common.block.IColorfulFlowerBlock;
import cy.jdkdigital.productivefarming.registry.FarmingDataComponents;
import cy.jdkdigital.productivefarming.registry.FarmingRegistrator;
import cy.jdkdigital.productivelib.registry.LibItems;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Cod;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.datamaps.RegisterDataMapTypesEvent;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD, modid="productivefarming")
public class ModEventHandler {
    @SubscribeEvent
    public static void buildContents(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey().equals(FarmingRegistrator.TAB_KEY)) {
            for (DeferredHolder item : ProductiveFarming.ITEMS.getEntries()) {
                BlockItem blockItem;
                Object object;
                if (item.is(FarmingRegistrator.FARM_HATCH.getId())) continue;
                if (item.is(ItemTags.FLOWERS) && (object = item.get()) instanceof BlockItem && (object = (blockItem = (BlockItem)object).getBlock()) instanceof IColorfulFlowerBlock) {
                    IColorfulFlowerBlock colorfulFlowerBlock = (IColorfulFlowerBlock)object;
                    ItemStack stack = ((Item)item.get()).getDefaultInstance();
                    stack.set(FarmingDataComponents.COLOR, (Object)colorfulFlowerBlock.getDefaultColor());
                    event.accept(stack);
                    continue;
                }
                event.accept((ItemLike)item.value());
            }
            if (ModList.get().isLoaded("productivebees")) {
                event.accept((ItemLike)LibItems.UPGRADE_POLLEN_SIEVE.get());
            }
        }
    }

    @SubscribeEvent
    public static void onEntityAttributeCreate(EntityAttributeCreationEvent event) {
        FarmingRegistrator.FISHIES.forEach(fishConfig -> {
            if (fishConfig.entitySupplier() != null) {
                EntityType entityType = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)fishConfig.name()));
                event.put(entityType, Cod.createAttributes().build());
            }
        });
    }

    @SubscribeEvent
    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)FarmingRegistrator.FEEDING_TROUGH_BLOCK_ENTITY.get(), (myBlockEntity, side) -> myBlockEntity.getItemHandler());
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, (BlockEntityType)FarmingRegistrator.WATERING_TROUGH_BLOCK_ENTITY.get(), (myBlockEntity, side) -> myBlockEntity.getFluidHandler());
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)FarmingRegistrator.FARM_CONTROLLER_BLOCK_ENTITY.get(), (myBlockEntity, side) -> myBlockEntity.getItemHandler());
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, (BlockEntityType)FarmingRegistrator.FARM_CONTROLLER_BLOCK_ENTITY.get(), (myBlockEntity, side) -> myBlockEntity.getFluidHandler());
    }

    @SubscribeEvent
    private static void registerDataMap(RegisterDataMapTypesEvent event) {
        event.register(FarmingRegistrator.CROP_TRAITS);
    }
}

