/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivefarming.event;

import cy.jdkdigital.productivefarming.Config;
import cy.jdkdigital.productivefarming.common.block.DoubleCropBlock;
import cy.jdkdigital.productivefarming.common.block.entity.ColorfulFlowerBlockEntity;
import cy.jdkdigital.productivefarming.common.block.entity.MushroomGrowthCropBlockEntity;
import cy.jdkdigital.productivefarming.integrations.productivebees.CompatHandler;
import cy.jdkdigital.productivefarming.registry.FarmingDataComponents;
import cy.jdkdigital.productivefarming.registry.FarmingRegistrator;
import cy.jdkdigital.productivefarming.registry.ModTags;
import cy.jdkdigital.productivefarming.util.FarmUtil;
import cy.jdkdigital.productivefarming.util.FlowerConfig;
import cy.jdkdigital.productivefarming.util.RecipeHelper;
import cy.jdkdigital.productivefarming.util.TraitsHelper;
import cy.jdkdigital.productivelib.event.BeeReleaseEvent;
import cy.jdkdigital.productivelib.event.CollectValidUpgradesEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.trading.ItemCost;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BeehiveBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.AlwaysTrueTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.ProcessorRule;
import net.minecraft.world.level.levelgen.structure.templatesystem.RandomBlockMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.living.BabyEntitySpawnEvent;
import net.neoforged.neoforge.event.entity.player.BonemealEvent;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.entity.player.UseItemOnBlockEvent;
import net.neoforged.neoforge.event.level.block.CropGrowEvent;
import net.neoforged.neoforge.event.server.ServerAboutToStartEvent;
import net.neoforged.neoforge.event.village.VillagerTradesEvent;

@EventBusSubscriber(modid="productivefarming")
public class EventHandler {
    @SubscribeEvent
    static void onServerStart(ServerAboutToStartEvent event) {
        Registry processorListRegistry = (Registry)event.getServer().registryAccess().registry(Registries.PROCESSOR_LIST).orElseThrow();
        if (((Boolean)Config.SERVER.traitsOnVanillaCrops.get()).booleanValue()) {
            RuleProcessor wheatCropProcessor = new RuleProcessor(List.of(new ProcessorRule((RuleTest)new RandomBlockMatchTest(Blocks.WHEAT, 1.0f), (RuleTest)AlwaysTrueTest.INSTANCE, ((Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)"wheat"))).defaultBlockState())));
            RuleProcessor potatoCropProcessor = new RuleProcessor(List.of(new ProcessorRule((RuleTest)new RandomBlockMatchTest(Blocks.POTATOES, 1.0f), (RuleTest)AlwaysTrueTest.INSTANCE, ((Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)"potato"))).defaultBlockState())));
            RuleProcessor carrotCropProcessor = new RuleProcessor(List.of(new ProcessorRule((RuleTest)new RandomBlockMatchTest(Blocks.CARROTS, 1.0f), (RuleTest)AlwaysTrueTest.INSTANCE, ((Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)"carrot"))).defaultBlockState())));
            RuleProcessor beetrootCropProcessor = new RuleProcessor(List.of(new ProcessorRule((RuleTest)new RandomBlockMatchTest(Blocks.BEETROOTS, 1.0f), (RuleTest)AlwaysTrueTest.INSTANCE, ((Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)"beetroot"))).defaultBlockState())));
            EventHandler.addNewRuleToVanillaFarms((StructureProcessor)wheatCropProcessor, (Registry<StructureProcessorList>)processorListRegistry);
            EventHandler.addNewRuleToVanillaFarms((StructureProcessor)potatoCropProcessor, (Registry<StructureProcessorList>)processorListRegistry);
            EventHandler.addNewRuleToVanillaFarms((StructureProcessor)carrotCropProcessor, (Registry<StructureProcessorList>)processorListRegistry);
            EventHandler.addNewRuleToVanillaFarms((StructureProcessor)beetrootCropProcessor, (Registry<StructureProcessorList>)processorListRegistry);
        }
        ArrayList plainsModdedCropRules = new ArrayList();
        ArrayList savannaModdedCropRules = new ArrayList();
        ArrayList snowyModdedCropRules = new ArrayList();
        ArrayList taigaModdedCropRules = new ArrayList();
        ArrayList desertModdedCropRules = new ArrayList();
        int plainsCount = (int)BuiltInRegistries.BLOCK.getTag(ModTags.Blocks.PLAINS_VILLAGE_FARM_CROPS).stream().count();
        int savannaCount = (int)BuiltInRegistries.BLOCK.getTag(ModTags.Blocks.SAVANNA_VILLAGE_FARM_CROPS).stream().count();
        int snowyCount = (int)BuiltInRegistries.BLOCK.getTag(ModTags.Blocks.SNOWY_VILLAGE_FARM_CROPS).stream().count();
        int taigaCount = (int)BuiltInRegistries.BLOCK.getTag(ModTags.Blocks.TAIGA_VILLAGE_FARM_CROPS).stream().count();
        int desertCount = (int)BuiltInRegistries.BLOCK.getTag(ModTags.Blocks.DESERT_VILLAGE_FARM_CROPS).stream().count();
        FarmingRegistrator.CROPS.forEach(cropConfig -> {
            BlockState crop = ((Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)cropConfig.name()))).defaultBlockState();
            if (crop.is(ModTags.Blocks.PLAINS_VILLAGE_FARM_CROPS)) {
                plainsModdedCropRules.add(new ProcessorRule((RuleTest)new RandomBlockMatchTest((Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)"wheat")), 35.0f / (float)plainsCount / 100.0f), (RuleTest)AlwaysTrueTest.INSTANCE, crop));
            }
            if (crop.is(ModTags.Blocks.SAVANNA_VILLAGE_FARM_CROPS)) {
                savannaModdedCropRules.add(new ProcessorRule((RuleTest)new RandomBlockMatchTest((Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)"wheat")), 35.0f / (float)savannaCount / 100.0f), (RuleTest)AlwaysTrueTest.INSTANCE, crop));
            }
            if (crop.is(ModTags.Blocks.SNOWY_VILLAGE_FARM_CROPS)) {
                snowyModdedCropRules.add(new ProcessorRule((RuleTest)new RandomBlockMatchTest((Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)"wheat")), 35.0f / (float)snowyCount / 100.0f), (RuleTest)AlwaysTrueTest.INSTANCE, crop));
            }
            if (crop.is(ModTags.Blocks.TAIGA_VILLAGE_FARM_CROPS)) {
                taigaModdedCropRules.add(new ProcessorRule((RuleTest)new RandomBlockMatchTest((Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)"wheat")), 35.0f / (float)taigaCount / 100.0f), (RuleTest)AlwaysTrueTest.INSTANCE, crop));
            }
            if (crop.is(ModTags.Blocks.DESERT_VILLAGE_FARM_CROPS)) {
                desertModdedCropRules.add(new ProcessorRule((RuleTest)new RandomBlockMatchTest((Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)"wheat")), 35.0f / (float)desertCount / 100.0f), (RuleTest)AlwaysTrueTest.INSTANCE, crop));
            }
        });
        EventHandler.addNewRuleToProcessorList(ResourceLocation.withDefaultNamespace((String)"farm_plains"), (StructureProcessor)new RuleProcessor(plainsModdedCropRules), (Registry<StructureProcessorList>)processorListRegistry);
        EventHandler.addNewRuleToProcessorList(ResourceLocation.withDefaultNamespace((String)"farm_savanna"), (StructureProcessor)new RuleProcessor(savannaModdedCropRules), (Registry<StructureProcessorList>)processorListRegistry);
        EventHandler.addNewRuleToProcessorList(ResourceLocation.withDefaultNamespace((String)"farm_snowy"), (StructureProcessor)new RuleProcessor(snowyModdedCropRules), (Registry<StructureProcessorList>)processorListRegistry);
        EventHandler.addNewRuleToProcessorList(ResourceLocation.withDefaultNamespace((String)"farm_taiga"), (StructureProcessor)new RuleProcessor(taigaModdedCropRules), (Registry<StructureProcessorList>)processorListRegistry);
        EventHandler.addNewRuleToProcessorList(ResourceLocation.withDefaultNamespace((String)"farm_desert"), (StructureProcessor)new RuleProcessor(desertModdedCropRules), (Registry<StructureProcessorList>)processorListRegistry);
        EventHandler.addNewRuleToProcessorList(ResourceLocation.withDefaultNamespace((String)"zombie_plains"), (StructureProcessor)new RuleProcessor(plainsModdedCropRules), (Registry<StructureProcessorList>)processorListRegistry);
        EventHandler.addNewRuleToProcessorList(ResourceLocation.withDefaultNamespace((String)"zombie_savanna"), (StructureProcessor)new RuleProcessor(savannaModdedCropRules), (Registry<StructureProcessorList>)processorListRegistry);
        EventHandler.addNewRuleToProcessorList(ResourceLocation.withDefaultNamespace((String)"zombie_snowy"), (StructureProcessor)new RuleProcessor(snowyModdedCropRules), (Registry<StructureProcessorList>)processorListRegistry);
        EventHandler.addNewRuleToProcessorList(ResourceLocation.withDefaultNamespace((String)"zombie_taiga"), (StructureProcessor)new RuleProcessor(taigaModdedCropRules), (Registry<StructureProcessorList>)processorListRegistry);
        EventHandler.addNewRuleToProcessorList(ResourceLocation.withDefaultNamespace((String)"zombie_desert"), (StructureProcessor)new RuleProcessor(desertModdedCropRules), (Registry<StructureProcessorList>)processorListRegistry);
    }

    private static void addNewRuleToVanillaFarms(StructureProcessor processorToAdd, Registry<StructureProcessorList> processorListRegistry) {
        EventHandler.addNewRuleToProcessorList(ResourceLocation.withDefaultNamespace((String)"farm_plains"), processorToAdd, processorListRegistry);
        EventHandler.addNewRuleToProcessorList(ResourceLocation.withDefaultNamespace((String)"farm_savanna"), processorToAdd, processorListRegistry);
        EventHandler.addNewRuleToProcessorList(ResourceLocation.withDefaultNamespace((String)"farm_snowy"), processorToAdd, processorListRegistry);
        EventHandler.addNewRuleToProcessorList(ResourceLocation.withDefaultNamespace((String)"farm_taiga"), processorToAdd, processorListRegistry);
        EventHandler.addNewRuleToProcessorList(ResourceLocation.withDefaultNamespace((String)"farm_desert"), processorToAdd, processorListRegistry);
        EventHandler.addNewRuleToProcessorList(ResourceLocation.withDefaultNamespace((String)"zombie_plains"), processorToAdd, processorListRegistry);
        EventHandler.addNewRuleToProcessorList(ResourceLocation.withDefaultNamespace((String)"zombie_savanna"), processorToAdd, processorListRegistry);
        EventHandler.addNewRuleToProcessorList(ResourceLocation.withDefaultNamespace((String)"zombie_snowy"), processorToAdd, processorListRegistry);
        EventHandler.addNewRuleToProcessorList(ResourceLocation.withDefaultNamespace((String)"zombie_taiga"), processorToAdd, processorListRegistry);
        EventHandler.addNewRuleToProcessorList(ResourceLocation.withDefaultNamespace((String)"zombie_desert"), processorToAdd, processorListRegistry);
    }

    private static void addNewRuleToProcessorList(ResourceLocation targetProcessorList, StructureProcessor processorToAdd, Registry<StructureProcessorList> processorListRegistry) {
        processorListRegistry.getOptional(targetProcessorList).ifPresent(processorList -> {
            ArrayList<StructureProcessor> newSafeList = new ArrayList<StructureProcessor>(processorList.list());
            newSafeList.add(processorToAdd);
            processorList.list = newSafeList;
        });
    }

    @SubscribeEvent
    static void itemUseEvent(UseItemOnBlockEvent event) {
        ResourceLocation blockName;
        BlockState growth;
        ServerLevel serverLevel;
        Level level = event.getLevel();
        if (level instanceof ServerLevel && (serverLevel = (ServerLevel)level).getBlockState(event.getPos()).is(Blocks.COMPOSTER) && event.getUsePhase().equals((Object)UseItemOnBlockEvent.UsePhase.BLOCK) && event.getItemStack().is(ModTags.Items.MUSHROOMS) && serverLevel.random.nextFloat() < 0.2f && (growth = ((Block)BuiltInRegistries.BLOCK.get(blockName = ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)(BuiltInRegistries.ITEM.getKey((Object)event.getItemStack().getItem()).getPath() + "_growth")))).defaultBlockState()).hasProperty((Property)BlockStateProperties.FACING)) {
            for (Direction direction : Direction.Plane.HORIZONTAL.shuffledCopy(serverLevel.random)) {
                if (!serverLevel.getBlockState(event.getPos().relative(direction)).isAir()) continue;
                serverLevel.setBlockAndUpdate(event.getPos().relative(direction), (BlockState)growth.setValue((Property)BlockStateProperties.FACING, (Comparable)direction));
                BlockEntity blockEntity = serverLevel.getBlockEntity(event.getPos().relative(direction));
                if (!(blockEntity instanceof MushroomGrowthCropBlockEntity)) break;
                MushroomGrowthCropBlockEntity growthCropBlockEntity = (MushroomGrowthCropBlockEntity)blockEntity;
                growthCropBlockEntity.applyComponentsFromItemStack(event.getItemStack());
                break;
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerInteract(PlayerInteractEvent.EntityInteract event) {
        Entity entity = event.getTarget();
        if (entity instanceof Wolf) {
            Wolf wolf = (Wolf)entity;
            if (!wolf.level().isClientSide) {
                if (wolf.isOwnedBy((LivingEntity)event.getEntity()) && wolf.getBodyArmorItem().isEmpty() && !wolf.isBaby()) {
                    wolf.setBodyArmorItem(event.getItemStack().copyWithCount(1));
                    event.getItemStack().consume(1, (LivingEntity)event.getEntity());
                    event.setCanceled(true);
                    event.setCancellationResult(InteractionResult.sidedSuccess((boolean)event.getLevel().isClientSide));
                } else if (event.getItemStack().canPerformAction(ItemAbilities.SHEARS_REMOVE_ARMOR) && wolf.isOwnedBy((LivingEntity)event.getEntity()) && wolf.hasArmor() && (!EnchantmentHelper.has((ItemStack)wolf.getBodyArmorItem(), (DataComponentType)EnchantmentEffectComponents.PREVENT_ARMOR_CHANGE) || event.getEntity().isCreative())) {
                    event.getItemStack().hurtAndBreak(1, (LivingEntity)event.getEntity(), event.getItemStack().getEquipmentSlot());
                    wolf.playSound(SoundEvents.ARMOR_UNEQUIP_WOLF);
                    ItemStack itemstack1 = wolf.getBodyArmorItem();
                    wolf.setBodyArmorItem(ItemStack.EMPTY);
                    wolf.spawnAtLocation(itemstack1);
                    event.setCanceled(true);
                    event.setCancellationResult(InteractionResult.sidedSuccess((boolean)event.getLevel().isClientSide));
                }
            }
        }
    }

    @SubscribeEvent
    public static void collectValidUpgrades(CollectValidUpgradesEvent event) {
        if (ModList.get().isLoaded("productivebees")) {
            CompatHandler.collectValidUpgrades(event);
        }
    }

    @SubscribeEvent
    public static void beeRelease(BeeReleaseEvent event) {
        if (ModList.get().isLoaded("productivebees")) {
            CompatHandler.beeRelease(event);
        } else {
            Level level = event.getLevel();
            if (level instanceof ServerLevel) {
                ServerLevel level2 = (ServerLevel)level;
                if (event.getBeeState().equals((Object)BeehiveBlockEntity.BeeReleaseStatus.HONEY_DELIVERED) && event.getBlockEntity() instanceof BeehiveBlockEntity && event.getBee().getHivePos() != null) {
                    FarmUtil.pollinateCrops((Level)level2, event.getBee().getHivePos(), 4, false, new ArrayList<ResourceLocation>());
                }
            }
        }
    }

    @SubscribeEvent
    static void onCropGrow(CropGrowEvent.Post event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)levelAccessor;
            levelAccessor = event.getState().getBlock();
            if (levelAccessor instanceof DoubleCropBlock) {
                DoubleCropBlock crop = (DoubleCropBlock)levelAccessor;
                BlockState aboveState = serverLevel.getBlockState(event.getPos().above());
                if (aboveState.is((Block)crop)) {
                    serverLevel.setBlockAndUpdate(event.getPos().above(), (BlockState)aboveState.setValue((Property)crop.getAgeProperty(), (Comparable)((Integer)event.getState().getValue((Property)crop.getAgeProperty()))));
                }
            }
        }
    }

    @SubscribeEvent
    static void onBabySpawn(BabyEntitySpawnEvent event) {
        Level level;
        if (event.getChild() != null && (level = event.getChild().level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            level = event.getChild();
            if (level instanceof Horse) {
                Horse horse = (Horse)level;
                PoiManager poiManager = serverLevel.getPoiManager();
                Stream stream = poiManager.getInRange(poi -> poi.is(ModTags.SALT_LICK_POI_TAG), event.getParentA().blockPosition(), 2, PoiManager.Occupancy.ANY);
                if (stream.findAny().isPresent()) {
                    horse.getAttribute(Attributes.MAX_HEALTH).setBaseValue(horse.getAttribute(Attributes.MAX_HEALTH).getBaseValue() * 1.1);
                    horse.getAttribute(Attributes.JUMP_STRENGTH).setBaseValue(horse.getAttribute(Attributes.MAX_HEALTH).getBaseValue() * 1.1);
                    horse.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(horse.getAttribute(Attributes.MAX_HEALTH).getBaseValue() * 1.1);
                }
            }
        }
    }

    @SubscribeEvent
    static void onEntityJoinLevel(EntityJoinLevelEvent event) {
        ItemEntity itemEntity;
        ItemStack stack;
        Entity entity;
        if (((Boolean)Config.SERVER.traitsOnVanillaCrops.get()).booleanValue() && (entity = event.getEntity()) instanceof ItemEntity && (stack = (itemEntity = (ItemEntity)entity).getItem()).is(ModTags.Items.VANILLA_SEEDS) && !stack.has(FarmingDataComponents.GROWTH)) {
            TraitsHelper.setDefaultsOnStack(stack);
        }
    }

    @SubscribeEvent
    static void itemTooltip(ItemTooltipEvent event) {
        if (((Boolean)Config.SERVER.traitsOnVanillaCrops.get()).booleanValue() && event.getItemStack().is(ModTags.Items.VANILLA_SEEDS) && event.getItemStack().has(FarmingDataComponents.GROWTH)) {
            event.getToolTip().add(Component.translatable((String)FarmUtil.getLatinTranslationKey(event.getItemStack().getItem())).withStyle(ChatFormatting.DARK_GREEN).withStyle(ChatFormatting.ITALIC));
            if (event.getFlags().hasShiftDown()) {
                event.getToolTip().add(Component.translatable((String)"productivefarming.trait.growth", (Object[])new Object[]{TraitsHelper.getValueName("growth", (Integer)event.getItemStack().getOrDefault(FarmingDataComponents.GROWTH, (Object)0))}).withStyle(ChatFormatting.GRAY));
                event.getToolTip().add(Component.translatable((String)"productivefarming.trait.yield", (Object[])new Object[]{TraitsHelper.getValueName("yield", (Integer)event.getItemStack().getOrDefault(FarmingDataComponents.YIELD, (Object)0))}).withStyle(ChatFormatting.GRAY));
                event.getToolTip().add(Component.translatable((String)"productivefarming.trait.resistance", (Object[])new Object[]{TraitsHelper.getValueName("resistance", (Integer)event.getItemStack().getOrDefault(FarmingDataComponents.RESISTANCE, (Object)0))}).withStyle(ChatFormatting.GRAY));
                event.getToolTip().add(Component.translatable((String)"productivefarming.trait.mutability", (Object[])new Object[]{TraitsHelper.getValueName("mutability", (Integer)event.getItemStack().getOrDefault(FarmingDataComponents.MUTABILITY, (Object)0))}).withStyle(ChatFormatting.GRAY));
            } else {
                event.getToolTip().add(Component.translatable((String)"productivefarming.tooltip.extend").withStyle(ChatFormatting.DARK_GRAY));
            }
        }
    }

    @SubscribeEvent
    public static void onBonemeal(BonemealEvent event) {
        if (((Boolean)Config.SERVER.spawnFlowersWithBonemeal.get()).booleanValue() && !event.getLevel().isClientSide() && event.getState().is(Blocks.GRASS_BLOCK) && event.getLevel().getBiome(event.getPos()).is(ModTags.Biomes.HAS_FLOWERS)) {
            ArrayList positions = BlockPos.betweenClosedStream((BlockPos)event.getPos().below(2).west(3).south(3), (BlockPos)event.getPos().above(2).east(3).north(3)).map(BlockPos::immutable).filter(pos -> event.getLevel().getBlockState(pos).isAir() && event.getLevel().getBlockState(pos.below()).is(Blocks.GRASS_BLOCK)).collect(Collectors.toCollection(ArrayList::new));
            for (BlockPos position : positions) {
                BlockEntity blockEntity;
                FlowerConfig flower;
                BlockState newFlower;
                if (event.getLevel().random.nextInt(8) != 0 || !(newFlower = ((Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)(flower = FarmingRegistrator.FLOWERS.get(event.getLevel().random.nextInt(FarmingRegistrator.FLOWERS.size()))).name()))).defaultBlockState()).is(ModTags.Blocks.CAN_SPAWN_FROM_BONEMEAL)) continue;
                event.getLevel().setBlockAndUpdate(position, newFlower);
                if (!newFlower.is(BlockTags.TALL_FLOWERS) || !((blockEntity = event.getLevel().getBlockEntity(position)) instanceof ColorfulFlowerBlockEntity)) break;
                ColorfulFlowerBlockEntity flowerBlockEntity = (ColorfulFlowerBlockEntity)blockEntity;
                event.getLevel().setBlockAndUpdate(position.above(), (BlockState)newFlower.setValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF, (Comparable)DoubleBlockHalf.UPPER));
                BlockEntity blockEntity2 = event.getLevel().getBlockEntity(position.above());
                if (!(blockEntity2 instanceof ColorfulFlowerBlockEntity)) break;
                ColorfulFlowerBlockEntity flowerBlockEntityAbove = (ColorfulFlowerBlockEntity)blockEntity2;
                flowerBlockEntityAbove.setColor(flowerBlockEntity.getColor());
                break;
            }
        }
    }

    @SubscribeEvent
    public static void onVillagerTradesEvent(VillagerTradesEvent event) {
        if (((Boolean)Config.STARTUP.villagersTradeSeeds.get()).booleanValue() && event.getType().equals((Object)VillagerProfession.FARMER)) {
            FarmingRegistrator.CROPS.forEach(cropConfig -> {
                Item seed;
                if (!RecipeHelper.isMutatedCrop(cropConfig) && !(seed = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)(cropConfig.name() + (cropConfig.hasSeed() ? "_seeds" : ""))))).getDefaultInstance().isEmpty()) {
                    ((List)event.getTrades().get(1)).add((trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD), Optional.empty(), new ItemStack((ItemLike)seed, (int)(1.0 + Math.random() * 6.0)), 1, 16, 1, 0.2f));
                }
            });
            FarmingRegistrator.HERBS.forEach(cropConfig -> {
                Item seed;
                if (!RecipeHelper.isMutatedCrop(cropConfig) && !(seed = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)(cropConfig.name() + (cropConfig.hasSeed() ? "_seeds" : ""))))).getDefaultInstance().isEmpty()) {
                    ((List)event.getTrades().get(2)).add((trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD), Optional.empty(), new ItemStack((ItemLike)seed, (int)(1.0 + Math.random() * 8.0)), 1, 16, 3, 0.2f));
                }
            });
            FarmingRegistrator.BERRIES.forEach(cropConfig -> {
                Item seed;
                if (!RecipeHelper.isMutatedCrop(cropConfig) && !(seed = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)(cropConfig.name() + (cropConfig.hasSeed() ? "_seeds" : ""))))).getDefaultInstance().isEmpty()) {
                    ((List)event.getTrades().get(2)).add((trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD), Optional.empty(), new ItemStack((ItemLike)seed, (int)(1.0 + Math.random() * 8.0)), 1, 16, 4, 0.2f));
                }
            });
            FarmingRegistrator.SHROOMS.forEach(cropConfig -> {
                Item seed;
                if (!RecipeHelper.isMutatedCrop(cropConfig) && !(seed = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)(cropConfig.name() + (cropConfig.hasSeed() ? "_seeds" : ""))))).getDefaultInstance().isEmpty()) {
                    ((List)event.getTrades().get(3)).add((trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 2), Optional.empty(), new ItemStack((ItemLike)seed, (int)(1.0 + Math.random() * 4.0)), 1, 16, 4, 0.2f));
                }
            });
            FarmingRegistrator.GRAPES.forEach(cropConfig -> {
                Item seed;
                if (!RecipeHelper.isMutatedCrop(cropConfig) && !(seed = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)(cropConfig.name() + (cropConfig.hasSeed() ? "_seeds" : ""))))).getDefaultInstance().isEmpty()) {
                    ((List)event.getTrades().get(3)).add((trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 2), Optional.empty(), new ItemStack((ItemLike)seed, (int)(1.0 + Math.random() * 4.0)), 1, 16, 4, 0.2f));
                }
            });
            FarmingRegistrator.STEMS.forEach(cropConfig -> {
                Item seed;
                if (!RecipeHelper.isMutatedCrop(cropConfig) && !(seed = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)(cropConfig.name() + (cropConfig.hasSeed() ? "_seeds" : ""))))).getDefaultInstance().isEmpty()) {
                    ((List)event.getTrades().get(3)).add((trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 2), Optional.empty(), new ItemStack((ItemLike)seed, (int)(1.0 + Math.random() * 4.0)), 1, 16, 4, 0.2f));
                }
            });
            FarmingRegistrator.TRELLIS.forEach(cropConfig -> {
                Item seed;
                if (!RecipeHelper.isMutatedCrop(cropConfig) && !(seed = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)(cropConfig.name() + (cropConfig.hasSeed() ? "_seeds" : ""))))).getDefaultInstance().isEmpty()) {
                    ((List)event.getTrades().get(4)).add((trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 2), Optional.empty(), new ItemStack((ItemLike)seed, (int)(1.0 + Math.random() * 4.0)), 1, 16, 5, 0.2f));
                }
            });
            FarmingRegistrator.VERTICAL_TRELLIS.forEach(cropConfig -> {
                Item seed;
                if (!RecipeHelper.isMutatedCrop(cropConfig) && !(seed = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)(cropConfig.name() + (cropConfig.hasSeed() ? "_seeds" : ""))))).getDefaultInstance().isEmpty()) {
                    ((List)event.getTrades().get(4)).add((trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 2), Optional.empty(), new ItemStack((ItemLike)seed, (int)(1.0 + Math.random() * 4.0)), 1, 16, 5, 0.2f));
                }
            });
        }
    }
}

