/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivefarming.event;

import cy.jdkdigital.productivefarming.client.render.block.FencedCropBlockEntityRenderer;
import cy.jdkdigital.productivefarming.client.render.entity.layers.WolfHotdogLayer;
import cy.jdkdigital.productivefarming.common.block.entity.ColorfulFlowerBlockEntity;
import cy.jdkdigital.productivefarming.common.block.entity.ColorfulFlowerPotBlockEntity;
import cy.jdkdigital.productivefarming.common.block.entity.CropBlockEntity;
import cy.jdkdigital.productivefarming.common.item.PollenItem;
import cy.jdkdigital.productivefarming.inventory.screen.FarmControllerScreen;
import cy.jdkdigital.productivefarming.inventory.screen.FeedingTroughScreen;
import cy.jdkdigital.productivefarming.registry.FarmingDataComponents;
import cy.jdkdigital.productivefarming.registry.FarmingRegistrator;
import cy.jdkdigital.productivefarming.util.CropConfig;
import cy.jdkdigital.productivelib.util.ColorUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.model.WolfModel;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.WolfRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.StemBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.client.model.DynamicFluidContainerModel;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

@EventBusSubscriber(modid="productivefarming", value={Dist.CLIENT})
public class ClientSetupEvents {
    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            for (CropConfig crop : FarmingRegistrator.BERRIES) {
                ItemProperties.register((Item)((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)crop.name()))), (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"count"), (stack, world, entity, i) -> stack.getCount());
            }
        });
    }

    @SubscribeEvent
    public static void registerBlockColors(RegisterColorHandlersEvent.Block event) {
        event.register((blockState, lightReader, pos, tintIndex) -> lightReader != null && pos != null ? BiomeColors.getAverageWaterColor((BlockAndTintGetter)lightReader, (BlockPos)pos) : -1, new Block[]{(Block)FarmingRegistrator.WATERING_TROUGH.get()});
        FarmingRegistrator.STEMS.forEach(crop -> {
            event.register((blockState, lightReader, pos, tintIndex) -> -2046180, new Block[]{(Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)("attached_" + crop.name() + "_stem")))});
            event.register((blockState, lightReader, pos, tintIndex) -> {
                int i = (Integer)blockState.getValue((Property)StemBlock.AGE);
                return FastColor.ARGB32.color((int)(i * 32), (int)(255 - i * 8), (int)(i * 4));
            }, new Block[]{(Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)(crop.name() + "_stem")))});
        });
        event.register((blockState, lightReader, pos, tintIndex) -> {
            int n;
            BlockEntity patt0$temp;
            if (lightReader != null && pos != null && (patt0$temp = lightReader.getBlockEntity(pos)) instanceof CropBlockEntity) {
                CropBlockEntity cropBlockEntity = (CropBlockEntity)patt0$temp;
                n = cropBlockEntity.getMutationColor();
            } else {
                n = -1;
            }
            return n;
        }, FarmingRegistrator.getAllCrops());
        event.register((blockState, lightReader, pos, tintIndex) -> {
            int n;
            BlockEntity patt0$temp;
            if (lightReader != null && pos != null && (patt0$temp = lightReader.getBlockEntity(pos)) instanceof ColorfulFlowerBlockEntity) {
                ColorfulFlowerBlockEntity flowerBlockEntity = (ColorfulFlowerBlockEntity)patt0$temp;
                n = flowerBlockEntity.getColor();
            } else {
                n = -1;
            }
            return n;
        }, FarmingRegistrator.getFlowers());
        event.register((blockState, lightReader, pos, tintIndex) -> {
            int n;
            BlockEntity patt0$temp;
            if (lightReader != null && pos != null && (patt0$temp = lightReader.getBlockEntity(pos)) instanceof ColorfulFlowerPotBlockEntity) {
                ColorfulFlowerPotBlockEntity flowerBlockEntity = (ColorfulFlowerPotBlockEntity)patt0$temp;
                n = flowerBlockEntity.getColor();
            } else {
                n = -1;
            }
            return n;
        }, FarmingRegistrator.getFlowerPots());
    }

    @SubscribeEvent
    public static void registerItemColors(RegisterColorHandlersEvent.Item event) {
        event.register((stack, tintIndex) -> PollenItem.getColor(stack), new ItemLike[]{(ItemLike)FarmingRegistrator.POLLEN.get()});
        event.register((stack, tintIndex) -> tintIndex == 1 ? (Integer)stack.getOrDefault(FarmingDataComponents.COLOR, (Object)-1) : -1, (ItemLike[])FarmingRegistrator.getFlowers());
        event.register((ItemColor)new DynamicFluidContainerModel.Colors(), new ItemLike[]{(ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)"nutrient_water_bucket"))});
    }

    @SubscribeEvent
    public static void registerClientExtensions(RegisterClientExtensionsEvent event) {
        event.registerFluidType(new IClientFluidTypeExtensions(){
            private static final ResourceLocation UNDERWATER = ResourceLocation.withDefaultNamespace((String)"textures/misc/underwater.png");
            private static final ResourceLocation STILL = ResourceLocation.withDefaultNamespace((String)"block/water_still");
            private static final ResourceLocation FLOWING = ResourceLocation.withDefaultNamespace((String)"block/water_flow");
            private static final ResourceLocation OVERLAY = ResourceLocation.withDefaultNamespace((String)"block/water_overlay");

            public ResourceLocation getStillTexture() {
                return STILL;
            }

            public ResourceLocation getFlowingTexture() {
                return FLOWING;
            }

            public ResourceLocation getOverlayTexture() {
                return OVERLAY;
            }

            public ResourceLocation getRenderOverlayTexture(Minecraft mc) {
                return UNDERWATER;
            }

            public int getTintColor() {
                return -12618012;
            }

            public int getTintColor(FluidState state, BlockAndTintGetter getter, BlockPos pos) {
                return ColorUtil.darkenColor((int)BiomeColors.getAverageWaterColor((BlockAndTintGetter)getter, (BlockPos)pos), (float)0.4f) | 0xFF000000;
            }
        }, new FluidType[]{(FluidType)NeoForgeRegistries.FLUID_TYPES.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)"nutrient_water"))});
    }

    @SubscribeEvent
    public static void onScreenRegister(RegisterMenuScreensEvent event) {
        event.register((MenuType)FarmingRegistrator.FARM_CONTROLLER_MENU.get(), FarmControllerScreen::new);
        event.register((MenuType)FarmingRegistrator.FEEDING_TROUGH_MENU.get(), FeedingTroughScreen::new);
    }

    @SubscribeEvent
    public static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer((BlockEntityType)FarmingRegistrator.FENCED_VERTICAL_CROP_BLOCK_ENTITY.get(), FencedCropBlockEntityRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)FarmingRegistrator.FENCED_LEAVES_BLOCK_ENTITY.get(), FencedCropBlockEntityRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)FarmingRegistrator.FENCED_STEM_BLOCK_ENTITY.get(), FencedCropBlockEntityRenderer::new);
        FarmingRegistrator.FISHIES.forEach(fishConfig -> {
            EntityType entityType;
            if (fishConfig.entitySupplier() != null && (entityType = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)fishConfig.name()))) != null) {
                event.registerEntityRenderer(entityType, fishConfig.entityRenderer());
            }
        });
    }

    @SubscribeEvent
    public static void layerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(WolfHotdogLayer.HOTDOG_LAYER, () -> LayerDefinition.create((MeshDefinition)WolfHotdogLayer.createMeshDefinition(CubeDeformation.NONE), (int)64, (int)64));
    }

    @SubscribeEvent
    public static void addLayers(EntityRenderersEvent.AddLayers event) {
        EntityRenderer renderer = event.getRenderer(EntityType.WOLF);
        if (renderer instanceof WolfRenderer) {
            WolfRenderer wolfRenderer = (WolfRenderer)renderer;
            wolfRenderer.addLayer((RenderLayer)new WolfHotdogLayer((RenderLayerParent<Wolf, WolfModel<Wolf>>)((RenderLayerParent)renderer), event.getEntityModels()));
        }
    }
}

