/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivefarming.datagen;

import cy.jdkdigital.productivefarming.common.block.DoubleCropBlock;
import cy.jdkdigital.productivefarming.datagen.recipe.BotanyPotBlockDerivedCropRecipeBuilder;
import cy.jdkdigital.productivefarming.datagen.recipe.CropMutationRecipeBuilder;
import cy.jdkdigital.productivefarming.integrations.botanypots.itemdrops.ProductiveDropProvider;
import cy.jdkdigital.productivefarming.registry.FarmingRegistrator;
import cy.jdkdigital.productivefarming.registry.ModTags;
import cy.jdkdigital.productivefarming.util.CropConfig;
import cy.jdkdigital.productivefarming.util.FishConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.darkhax.botanypots.common.impl.data.display.types.AgingDisplayState;
import net.darkhax.botanypots.common.impl.data.display.types.BasicOptions;
import net.darkhax.botanypots.common.impl.data.display.types.SimpleDisplayState;
import net.darkhax.botanypots.common.impl.data.itemdrops.SimpleDropProvider;
import net.darkhax.botanypots.common.impl.data.recipe.crop.BasicCrop;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.CampfireCookingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SmokingRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.IConditionBuilder;
import net.neoforged.neoforge.common.conditions.ModLoadedCondition;
import net.neoforged.neoforge.common.crafting.BlockTagIngredient;

public class RecipeProvider
extends net.minecraft.data.recipes.RecipeProvider
implements IConditionBuilder {
    public RecipeProvider(PackOutput gen, CompletableFuture<HolderLookup.Provider> registries) {
        super(gen, registries);
    }

    protected void buildRecipes(RecipeOutput recipeOutput) {
        RecipeProvider.simpleCookingRecipe(recipeOutput, "smelting", RecipeSerializer.SMOKING_RECIPE, 100, (ItemLike)BuiltInRegistries.ITEM.get(RecipeProvider.rL("tea")), (ItemLike)FarmingRegistrator.BLACK_TEA.get(), 0.35f, SmokingRecipe::new);
        RecipeProvider.simpleCookingRecipe(recipeOutput, "smelting", RecipeSerializer.SMOKING_RECIPE, 100, (ItemLike)BuiltInRegistries.ITEM.get(RecipeProvider.rL("tobacco")), (ItemLike)FarmingRegistrator.DRIED_TOBACCO.get(), 0.35f, SmokingRecipe::new);
        RecipeProvider.simpleCookingRecipe(recipeOutput, "smelting", RecipeSerializer.SMOKING_RECIPE, 100, (ItemLike)BuiltInRegistries.ITEM.get(RecipeProvider.rL("luffa")), (ItemLike)FarmingRegistrator.DRIED_LUFFA.get(), 0.35f, SmokingRecipe::new);
        for (FishConfig fish : FarmingRegistrator.FISHIES) {
            Item raw = (Item)BuiltInRegistries.ITEM.get(RecipeProvider.rL("raw_" + fish.name()));
            if (fish.hasBlock()) {
                raw = (Item)BuiltInRegistries.ITEM.get(RecipeProvider.rL(fish.name()));
            }
            Item cooked = (Item)BuiltInRegistries.ITEM.get(RecipeProvider.rL("cooked_" + fish.name()));
            RecipeProvider.simpleCookingRecipe(recipeOutput, "smoking", RecipeSerializer.SMOKING_RECIPE, 100, (ItemLike)raw, (ItemLike)cooked, 0.35f, SmokingRecipe::new);
            RecipeProvider.simpleCookingRecipe(recipeOutput, "campfire_cooking", RecipeSerializer.CAMPFIRE_COOKING_RECIPE, 600, (ItemLike)raw, (ItemLike)cooked, 0.35f, CampfireCookingRecipe::new);
        }
        for (CropConfig crop : FarmingRegistrator.STEMS) {
            Block melonBlock = (Block)BuiltInRegistries.BLOCK.get(RecipeProvider.rL(crop.name()));
            Item melonSlice = (Item)BuiltInRegistries.ITEM.get(RecipeProvider.rL(crop.name() + "_slice"));
            Item melonSeeds = (Item)BuiltInRegistries.ITEM.get(RecipeProvider.rL(crop.name() + "_seeds"));
            ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)melonBlock, (int)1).unlockedBy(RecipeProvider.getHasName((ItemLike)melonSlice), RecipeProvider.has((ItemLike)melonSlice)).requires((ItemLike)melonSlice, 9).save(recipeOutput, RecipeProvider.rL(crop.name()));
            ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)melonSeeds, (int)1).unlockedBy(RecipeProvider.getHasName((ItemLike)melonSlice), RecipeProvider.has((ItemLike)melonSlice)).requires((ItemLike)melonSlice).save(recipeOutput, RecipeProvider.rL(crop.name() + "_seeds"));
        }
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)FarmingRegistrator.FARM_CONTROLLER.get())).unlockedBy("has_bricks", RecipeProvider.has((TagKey)ItemTags.STONE_BRICKS)).pattern("BDB").pattern("BPB").pattern("BCB").define(Character.valueOf('D'), (ItemLike)Items.DAYLIGHT_DETECTOR).define(Character.valueOf('P'), (ItemLike)Items.COMPOSTER).define(Character.valueOf('C'), (ItemLike)Items.COMPARATOR).define(Character.valueOf('B'), ItemTags.STONE_BRICKS).save(recipeOutput, RecipeProvider.rL("farm_controller"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)FarmingRegistrator.FEEDING_TROUGH.get())).unlockedBy("has_copper", RecipeProvider.has((TagKey)Tags.Items.INGOTS_COPPER)).pattern("B B").pattern("BCB").pattern("BBB").define(Character.valueOf('C'), Tags.Items.CHESTS_WOODEN).define(Character.valueOf('B'), Tags.Items.INGOTS_COPPER).save(recipeOutput, RecipeProvider.rL("feeding_trough"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)FarmingRegistrator.WATERING_TROUGH.get())).unlockedBy("has_iron", RecipeProvider.has((TagKey)Tags.Items.INGOTS_IRON)).pattern("B B").pattern("BCB").pattern("BBB").define(Character.valueOf('C'), Tags.Items.BUCKETS_EMPTY).define(Character.valueOf('B'), Tags.Items.INGOTS_IRON).save(recipeOutput, RecipeProvider.rL("watering_trough"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.SPONGE, (int)1).unlockedBy(RecipeProvider.getHasName((ItemLike)((ItemLike)FarmingRegistrator.DRIED_LUFFA.get())), RecipeProvider.has((ItemLike)((ItemLike)FarmingRegistrator.DRIED_LUFFA.get()))).requires((ItemLike)FarmingRegistrator.DRIED_LUFFA.get(), 9).save(recipeOutput, RecipeProvider.rL("sponge_from_dried_luffa"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)FarmingRegistrator.CORN_COB_PIPE.get())).unlockedBy("has_corn", RecipeProvider.has(ModTags.Items.CORN)).pattern("CS").define(Character.valueOf('C'), ModTags.Items.CORN).define(Character.valueOf('S'), Tags.Items.RODS_WOODEN).save(recipeOutput, RecipeProvider.rL("corn_cob_pipe"));
        this.buildCrateRecipes(recipeOutput);
        this.buildSeedBagRecipes(recipeOutput);
        this.buildMutationRecipes(recipeOutput);
        if (ModList.get().isLoaded("botanypots")) {
            BotanyPotsCompat.buildRecipes(recipeOutput);
        }
    }

    protected static <T extends AbstractCookingRecipe> void simpleCookingRecipe(RecipeOutput pFinishedRecipeConsumer, String pCookingMethod, RecipeSerializer<T> pCookingSerializer, int pCookingTime, ItemLike pIngredient, ItemLike pResult, float pExperience, AbstractCookingRecipe.Factory<T> recipeFactory) {
        SimpleCookingRecipeBuilder.generic((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{pIngredient}), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)pResult, (float)pExperience, (int)pCookingTime, pCookingSerializer, recipeFactory).unlockedBy(RecipeProvider.getHasName((ItemLike)pIngredient), RecipeProvider.has((ItemLike)pIngredient)).save(pFinishedRecipeConsumer, RecipeProvider.rL("cooking/" + RecipeProvider.getItemName((ItemLike)pResult) + "_from_" + pCookingMethod));
    }

    private void buildCrateRecipes(RecipeOutput recipeOutput) {
        FarmingRegistrator.CRATED_CROPS.forEach(crate -> {
            Item crateItem = (Item)BuiltInRegistries.ITEM.get(RecipeProvider.rL(crate.getPath() + "_crate"));
            Item cropItem = (Item)BuiltInRegistries.ITEM.get(crate);
            ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)cropItem, (int)9).unlockedBy(RecipeProvider.getHasName((ItemLike)cropItem), RecipeProvider.has((ItemLike)cropItem)).requires((ItemLike)crateItem).save(recipeOutput, RecipeProvider.rL("crates/" + crate.getPath() + "_unpack"));
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)crateItem).unlockedBy(RecipeProvider.getHasName((ItemLike)cropItem), RecipeProvider.has((ItemLike)cropItem)).pattern("###").pattern("###").pattern("###").define(Character.valueOf('#'), (ItemLike)cropItem).save(recipeOutput, RecipeProvider.rL("crates/" + crate.getPath()));
        });
    }

    private void buildSeedBagRecipes(RecipeOutput recipeOutput) {
        FarmingRegistrator.SEED_BAGS.forEach(seedName -> {
            Item bagItem = (Item)BuiltInRegistries.ITEM.get(RecipeProvider.rL(seedName.getPath() + "_bag"));
            Item seedItem = (Item)BuiltInRegistries.ITEM.get(seedName);
            ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)seedItem, (int)9).unlockedBy(RecipeProvider.getHasName((ItemLike)seedItem), RecipeProvider.has((ItemLike)seedItem)).requires((ItemLike)bagItem).save(recipeOutput, RecipeProvider.rL("seed_bags/" + seedName.getPath() + "_unpack"));
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)bagItem).unlockedBy(RecipeProvider.getHasName((ItemLike)seedItem), RecipeProvider.has((ItemLike)seedItem)).pattern("###").pattern("###").pattern("###").define(Character.valueOf('#'), (ItemLike)seedItem).save(recipeOutput, RecipeProvider.rL("seed_bags/" + seedName.getPath()));
        });
    }

    private void buildMutationRecipes(RecipeOutput recipeOutput) {
        CropMutationRecipeBuilder.direct(RecipeProvider.rL("yellow_dent_corn"), ResourceLocation.withDefaultNamespace((String)"cornflower"), RecipeProvider.rL("blue_jade_corn"), 1.0f).save(recipeOutput, RecipeProvider.rL("pollination/blue_jade_corn"));
        CropMutationRecipeBuilder.direct(RecipeProvider.rL("yellow_dent_corn"), RecipeProvider.rL("blue_jade_corn"), RecipeProvider.rL("black_aztec_corn"), 0.8f).save(recipeOutput, RecipeProvider.rL("pollination/black_aztec_corn"));
        CropMutationRecipeBuilder.direct(RecipeProvider.rL("blue_jade_corn"), RecipeProvider.rL("black_aztec_corn"), RecipeProvider.rL("sugar_pearl_corn"), 0.8f).save(recipeOutput, RecipeProvider.rL("pollination/sugar_pearl_corn"));
        CropMutationRecipeBuilder.direct(RecipeProvider.rL("black_aztec_corn"), RecipeProvider.rL("sugar_pearl_corn"), RecipeProvider.rL("rainbow_corn"), 0.8f).save(recipeOutput, RecipeProvider.rL("pollination/rainbow_corn"));
        CropMutationRecipeBuilder.direct(RecipeProvider.rL("roma_tomato"), RecipeProvider.rL("potato"), RecipeProvider.rL("beefsteak_tomato"), 1.0f).save(recipeOutput, RecipeProvider.rL("pollination/beefsteak_tomato"));
        CropMutationRecipeBuilder.direct(RecipeProvider.rL("beefsteak_tomato"), RecipeProvider.rL("roma_tomato"), RecipeProvider.rL("black_beauty_tomato"), 0.3f).save(recipeOutput, RecipeProvider.rL("pollination/black_beauty_tomato"));
        CropMutationRecipeBuilder.direct(RecipeProvider.rL("beefsteak_tomato"), RecipeProvider.rL("roma_tomato"), RecipeProvider.rL("blue_beauty_tomato"), 0.3f).save(recipeOutput, RecipeProvider.rL("pollination/blue_beauty_tomato"));
        CropMutationRecipeBuilder.direct(RecipeProvider.rL("beefsteak_tomato"), RecipeProvider.rL("roma_tomato"), RecipeProvider.rL("white_wonder_tomato"), 0.3f).save(recipeOutput, RecipeProvider.rL("pollination/white_wonder_tomato"));
        CropMutationRecipeBuilder.direct(RecipeProvider.rL("cherry_tomato"), RecipeProvider.rL("beetroot"), RecipeProvider.rL("chocolate_pear_tomato"), 0.3f).save(recipeOutput, RecipeProvider.rL("pollination/chocolate_pear_tomato"));
        CropMutationRecipeBuilder.direct(RecipeProvider.rL("cherry_tomato"), RecipeProvider.rL("chocolate_pear_tomato"), RecipeProvider.rL("yellow_pear_tomato"), 0.3f).save(recipeOutput, RecipeProvider.rL("pollination/yellow_pear_tomato"));
        CropMutationRecipeBuilder.direct(RecipeProvider.rL("yellow_pear_tomato"), RecipeProvider.rL("chocolate_pear_tomato"), RecipeProvider.rL("sungold_tomato"), 0.3f).save(recipeOutput, RecipeProvider.rL("pollination/sungold_tomato"));
        CropMutationRecipeBuilder.direct(RecipeProvider.rL("yellow_bell_pepper"), RecipeProvider.rL("red_bell_pepper"), RecipeProvider.rL("orange_bell_pepper"), 0.3f).save(recipeOutput, RecipeProvider.rL("pollination/orange_bell_pepper"));
        CropMutationRecipeBuilder.direct(RecipeProvider.rL("green_bell_pepper"), RecipeProvider.rL("orange_bell_pepper"), RecipeProvider.rL("black_bell_pepper"), 0.3f).save(recipeOutput, RecipeProvider.rL("pollination/black_bell_pepper"));
        CropMutationRecipeBuilder.direct(RecipeProvider.rL("black_bell_pepper"), RecipeProvider.rL("red_bell_pepper"), RecipeProvider.rL("purple_bell_pepper"), 0.3f).save(recipeOutput, RecipeProvider.rL("pollination/purple_bell_pepper"));
        CropMutationRecipeBuilder.direct(RecipeProvider.rL("yellow_bell_pepper"), RecipeProvider.rL("orange_bell_pepper"), RecipeProvider.rL("white_bell_pepper"), 0.3f).save(recipeOutput, RecipeProvider.rL("pollination/white_bell_pepper"));
        CropMutationRecipeBuilder.direct(RecipeProvider.rL("red_grape"), RecipeProvider.rL("green_grape"), RecipeProvider.rL("concord_grape"), 0.3f).save(recipeOutput, RecipeProvider.rL("pollination/concord_grape"));
        CropMutationRecipeBuilder.direct(RecipeProvider.rL("concord_grape"), RecipeProvider.rL("green_grape"), RecipeProvider.rL("cotton_candy_grape"), 0.3f).save(recipeOutput, RecipeProvider.rL("pollination/cotton_candy_grape"));
        CropMutationRecipeBuilder.direct(RecipeProvider.rL("raspberry"), RecipeProvider.rL("sungold_tomato"), RecipeProvider.rL("golden_raspberry"), 0.7f).save(recipeOutput, RecipeProvider.rL("pollination/golden_raspberry"));
        CropMutationRecipeBuilder.direct(RecipeProvider.rL("golden_raspberry"), RecipeProvider.rL("goji_berry"), RecipeProvider.rL("miracle_berry"), 0.5f).save(recipeOutput, RecipeProvider.rL("pollination/miracle_berry"));
    }

    private static ResourceLocation rL(String name) {
        return ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)name);
    }

    static class BotanyPotsCompat {
        BotanyPotsCompat() {
        }

        protected static void buildRecipes(RecipeOutput recipeOutput) {
            for (CropConfig crop : FarmingRegistrator.HERBS) {
                BotanyPotsCompat.cropRecipe(crop, recipeOutput);
            }
            for (CropConfig crop : FarmingRegistrator.BERRIES) {
                BotanyPotsCompat.cropRecipe(crop, recipeOutput);
            }
            for (CropConfig crop : FarmingRegistrator.CROPS) {
                BotanyPotsCompat.cropRecipe(crop, recipeOutput);
            }
            for (CropConfig crop : FarmingRegistrator.TRELLIS) {
                BotanyPotsCompat.cropRecipe(crop, recipeOutput);
            }
            for (CropConfig crop : FarmingRegistrator.VERTICAL_TRELLIS) {
                BotanyPotsCompat.cropRecipe(crop, recipeOutput);
            }
            for (CropConfig crop : FarmingRegistrator.GRAPES) {
                BotanyPotsCompat.cropRecipe(crop, recipeOutput);
            }
            for (CropConfig crop : FarmingRegistrator.STEMS) {
                BotanyPotsCompat.cropRecipe(crop, recipeOutput);
            }
            for (CropConfig crop : FarmingRegistrator.SHROOMS) {
                BotanyPotsCompat.shroomRecipe(crop, recipeOutput);
            }
        }

        private static void cropRecipe(final CropConfig crop, RecipeOutput recipeOutput) {
            Item seed = (Item)BuiltInRegistries.ITEM.get(RecipeProvider.rL((String)(crop.hasSeed() ? crop.name() + "_seeds" : crop.name())));
            Block cropBlock = (Block)BuiltInRegistries.BLOCK.get(RecipeProvider.rL(crop.name()));
            ArrayList<SimpleDropProvider.SimpleDrop> drops = new ArrayList<SimpleDropProvider.SimpleDrop>(){
                {
                    this.add(new SimpleDropProvider.SimpleDrop(((Item)BuiltInRegistries.ITEM.get(RecipeProvider.rL(crop.name()))).getDefaultInstance(), 1.0f));
                }
            };
            if (crop.hasSeed()) {
                drops.add(new SimpleDropProvider.SimpleDrop(seed.getDefaultInstance(), 0.1f));
            }
            if (cropBlock instanceof DoubleCropBlock) {
                BotanyPotBlockDerivedCropRecipeBuilder.drops(cropBlock, Ingredient.of((ItemLike[])new ItemLike[]{seed}), BasicCrop.DIRT, List.of(new SimpleDropProvider((List)drops)), List.of(new SimpleDisplayState((BlockState)((BlockState)cropBlock.defaultBlockState().setValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF, (Comparable)DoubleBlockHalf.LOWER)).setValue((Property)((DoubleCropBlock)cropBlock).getAgeProperty(), (Comparable)Integer.valueOf(((DoubleCropBlock)cropBlock).getMaxAge())), BasicOptions.ofDefault()), new SimpleDisplayState((BlockState)((BlockState)cropBlock.defaultBlockState().setValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF, (Comparable)DoubleBlockHalf.UPPER)).setValue((Property)((DoubleCropBlock)cropBlock).getAgeProperty(), (Comparable)Integer.valueOf(((DoubleCropBlock)cropBlock).getMaxAge())), BasicOptions.ofDefault()))).save(recipeOutput.withConditions(new ICondition[]{new ModLoadedCondition("botanypots")}), RecipeProvider.rL("botanypots/" + crop.name()));
            } else {
                BotanyPotBlockDerivedCropRecipeBuilder.drops(cropBlock, Ingredient.of((ItemLike[])new ItemLike[]{seed}), List.of(new SimpleDropProvider((List)drops))).save(recipeOutput.withConditions(new ICondition[]{new ModLoadedCondition("botanypots")}), RecipeProvider.rL("botanypots/" + crop.name()));
            }
        }

        private static void shroomRecipe(CropConfig shroom, RecipeOutput recipeOutput) {
            final Item shroomItem = (Item)BuiltInRegistries.ITEM.get(RecipeProvider.rL(shroom.name()));
            Block growthBlock = (Block)BuiltInRegistries.BLOCK.get(RecipeProvider.rL(shroom.name() + "_growth"));
            ArrayList<SimpleDropProvider.SimpleDrop> drops = new ArrayList<SimpleDropProvider.SimpleDrop>(){
                {
                    this.add(new SimpleDropProvider.SimpleDrop(shroomItem.getDefaultInstance(), 1.0f));
                }
            };
            BotanyPotBlockDerivedCropRecipeBuilder.drops(growthBlock, Ingredient.of((ItemLike[])new ItemLike[]{shroomItem}), new BlockTagIngredient(BlockTags.MUSHROOM_GROW_BLOCK).toVanilla(), List.of(new SimpleDropProvider((List)drops)), List.of(new AgingDisplayState(growthBlock, BasicOptions.ofDefault()))).save(recipeOutput.withConditions(new ICondition[]{new ModLoadedCondition("botanypots")}), RecipeProvider.rL("botanypots/" + shroom.name()));
        }

        private static void productiveCropRecipe(final CropConfig crop, RecipeOutput recipeOutput) {
            Item seed = (Item)BuiltInRegistries.ITEM.get(RecipeProvider.rL((String)(crop.hasSeed() ? crop.name() + "_seeds" : crop.name())));
            Block cropBlock = (Block)BuiltInRegistries.BLOCK.get(RecipeProvider.rL(crop.name()));
            ArrayList<ProductiveDropProvider.ProductiveDrop> drops = new ArrayList<ProductiveDropProvider.ProductiveDrop>(){
                {
                    this.add(new ProductiveDropProvider.ProductiveDrop(((Item)BuiltInRegistries.ITEM.get(RecipeProvider.rL(crop.name()))).getDefaultInstance(), 1.0f));
                }
            };
            if (crop.hasSeed()) {
                drops.add(new ProductiveDropProvider.ProductiveDrop(seed.getDefaultInstance(), 0.1f));
            }
            if (cropBlock instanceof DoubleCropBlock) {
                BotanyPotBlockDerivedCropRecipeBuilder.drops(cropBlock, Ingredient.of((ItemLike[])new ItemLike[]{seed}), BasicCrop.DIRT, List.of(new ProductiveDropProvider((List<ProductiveDropProvider.ProductiveDrop>)drops)), List.of(new SimpleDisplayState((BlockState)((BlockState)cropBlock.defaultBlockState().setValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF, (Comparable)DoubleBlockHalf.LOWER)).setValue((Property)((DoubleCropBlock)cropBlock).getAgeProperty(), (Comparable)Integer.valueOf(((DoubleCropBlock)cropBlock).getMaxAge())), BasicOptions.ofDefault()), new SimpleDisplayState((BlockState)((BlockState)cropBlock.defaultBlockState().setValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF, (Comparable)DoubleBlockHalf.UPPER)).setValue((Property)((DoubleCropBlock)cropBlock).getAgeProperty(), (Comparable)Integer.valueOf(((DoubleCropBlock)cropBlock).getMaxAge())), BasicOptions.ofDefault()))).save(recipeOutput.withConditions(new ICondition[]{new ModLoadedCondition("botanypots")}), RecipeProvider.rL("botanypots/" + crop.name()));
            } else {
                BotanyPotBlockDerivedCropRecipeBuilder.drops(cropBlock, Ingredient.of((ItemLike[])new ItemLike[]{seed}), List.of(new ProductiveDropProvider((List<ProductiveDropProvider.ProductiveDrop>)drops))).save(recipeOutput.withConditions(new ICondition[]{new ModLoadedCondition("botanypots")}), RecipeProvider.rL("botanypots/" + crop.name()));
            }
        }
    }
}

