/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivefarming.datagen;

import cy.jdkdigital.productivefarming.datagen.BiomeModifierDataProvider;
import cy.jdkdigital.productivefarming.datagen.BiomeTagProvider;
import cy.jdkdigital.productivefarming.datagen.BlockTagProvider;
import cy.jdkdigital.productivefarming.datagen.DataMapProvider;
import cy.jdkdigital.productivefarming.datagen.EntityTypeTagProvider;
import cy.jdkdigital.productivefarming.datagen.FeatureProvider;
import cy.jdkdigital.productivefarming.datagen.ItemTagProvider;
import cy.jdkdigital.productivefarming.datagen.LanguageProvider;
import cy.jdkdigital.productivefarming.datagen.LootDataProvider;
import cy.jdkdigital.productivefarming.datagen.LootModifierProvider;
import cy.jdkdigital.productivefarming.datagen.ModelProvider;
import cy.jdkdigital.productivefarming.datagen.POITagProvider;
import cy.jdkdigital.productivefarming.datagen.RecipeProvider;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.Cloner;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.data.registries.VanillaRegistries;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.registries.DataPackRegistriesHooks;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

@EventBusSubscriber(modid="productivefarming")
public class ProductiveFarmingDataProvider {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        PackOutput output = event.getGenerator().getPackOutput();
        CompletableFuture<HolderLookup.Provider> provider = CompletableFuture.supplyAsync(() -> ProductiveFarmingDataProvider.getProvider().full());
        ExistingFileHelper helper = event.getExistingFileHelper();
        gen.addProvider(event.includeClient(), (DataProvider)new LanguageProvider(output));
        gen.addProvider(event.includeClient(), (DataProvider)new ModelProvider(output));
        gen.addProvider(event.includeServer(), (DataProvider)new LootDataProvider(output, List.of(new LootTableProvider.SubProviderEntry(LootDataProvider.LootProvider::new, LootContextParamSets.BLOCK)), provider));
        gen.addProvider(event.includeServer(), (DataProvider)new RecipeProvider(output, provider));
        gen.addProvider(event.includeServer(), (DataProvider)new FeatureProvider(output, FeatureProvider.getBuilder(), provider));
        BlockTagProvider blockTags = new BlockTagProvider(output, provider, helper);
        gen.addProvider(event.includeServer(), (DataProvider)blockTags);
        gen.addProvider(event.includeServer(), (DataProvider)new ItemTagProvider(output, provider, blockTags.contentsGetter(), helper));
        gen.addProvider(event.includeServer(), (DataProvider)new EntityTypeTagProvider(output, provider));
        gen.addProvider(event.includeServer(), (DataProvider)new BiomeTagProvider(output, provider, helper));
        gen.addProvider(event.includeServer(), (DataProvider)new POITagProvider(output, provider, helper));
        gen.addProvider(event.includeServer(), (DataProvider)new LootModifierProvider(output, provider));
        gen.addProvider(event.includeServer(), (DataProvider)new DataMapProvider(output, provider));
    }

    private static RegistrySetBuilder.PatchedRegistries getProvider() {
        RegistrySetBuilder registryBuilder = new RegistrySetBuilder();
        registryBuilder.add(NeoForgeRegistries.Keys.BIOME_MODIFIERS, BiomeModifierDataProvider::bootstrap);
        registryBuilder.add(Registries.BIOME, $ -> {});
        RegistryAccess.Frozen regAccess = RegistryAccess.fromRegistryOfRegistries((Registry)BuiltInRegistries.REGISTRY);
        Cloner.Factory cloner$factory = new Cloner.Factory();
        DataPackRegistriesHooks.getDataPackRegistriesWithDimensions().forEach(data -> data.runWithArguments((arg_0, arg_1) -> ((Cloner.Factory)cloner$factory).addCodec(arg_0, arg_1)));
        return registryBuilder.buildPatch((RegistryAccess)regAccess, VanillaRegistries.createLookup(), cloner$factory);
    }
}

