/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivefarming.datagen;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import cy.jdkdigital.productivefarming.ProductiveFarming;
import cy.jdkdigital.productivefarming.common.block.ClamBlock;
import cy.jdkdigital.productivefarming.common.block.ColorfulTallFlowerBlock;
import cy.jdkdigital.productivefarming.common.block.DoubleCropBlock;
import cy.jdkdigital.productivefarming.common.block.DoubleGrainCropBlock;
import cy.jdkdigital.productivefarming.common.block.FeedingTroughBlock;
import cy.jdkdigital.productivefarming.common.block.GrainCropBlock;
import cy.jdkdigital.productivefarming.common.block.IAgeableCropBlock;
import cy.jdkdigital.productivefarming.datagen.model.RenderTypedModelTemplate;
import cy.jdkdigital.productivefarming.registry.FarmingRegistrator;
import cy.jdkdigital.productivefarming.util.CropConfig;
import cy.jdkdigital.productivefarming.util.FishConfig;
import cy.jdkdigital.productivefarming.util.FlowerConfig;
import java.lang.runtime.SwitchBootstraps;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.models.BlockModelGenerators;
import net.minecraft.data.models.blockstates.BlockStateGenerator;
import net.minecraft.data.models.blockstates.Condition;
import net.minecraft.data.models.blockstates.MultiPartGenerator;
import net.minecraft.data.models.blockstates.MultiVariantGenerator;
import net.minecraft.data.models.blockstates.PropertyDispatch;
import net.minecraft.data.models.blockstates.Variant;
import net.minecraft.data.models.blockstates.VariantProperties;
import net.minecraft.data.models.model.DelegatedModel;
import net.minecraft.data.models.model.ModelLocationUtils;
import net.minecraft.data.models.model.ModelTemplate;
import net.minecraft.data.models.model.ModelTemplates;
import net.minecraft.data.models.model.TextureMapping;
import net.minecraft.data.models.model.TextureSlot;
import net.minecraft.data.models.model.TexturedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class ModelProvider
implements DataProvider {
    protected final PackOutput packOutput;
    protected final Map<ResourceLocation, Supplier<JsonElement>> models = new HashMap<ResourceLocation, Supplier<JsonElement>>();

    public ModelProvider(PackOutput packOutput) {
        this.packOutput = packOutput;
    }

    public CompletableFuture<?> run(CachedOutput cache) {
        Block block2;
        HashMap blockModels = Maps.newHashMap();
        Consumer<BlockStateGenerator> blockStateOutput = blockStateGenerator -> {
            Block block = blockStateGenerator.getBlock();
            BlockStateGenerator blockstategenerator = blockModels.put(block, blockStateGenerator);
            if (blockstategenerator != null) {
                throw new IllegalStateException("Duplicate blockstate definition for " + String.valueOf(block));
            }
        };
        HashMap itemModels = Maps.newHashMap();
        BiConsumer<ResourceLocation, Supplier<JsonElement>> modelOutput = (resourceLocation, elementSupplier) -> {
            Supplier supplier = itemModels.put(resourceLocation, elementSupplier);
            if (supplier != null) {
                throw new IllegalStateException("Duplicate model definition for " + String.valueOf(resourceLocation));
            }
        };
        ModelGenerator generator = new ModelGenerator();
        try {
            generator.registerStatesAndModels(blockStateOutput, modelOutput);
        }
        catch (Exception e) {
            ProductiveFarming.LOGGER.error("Error registering states and models", (Throwable)e);
        }
        PackOutput.PathProvider blockstatePathProvider = this.packOutput.createPathProvider(PackOutput.Target.RESOURCE_PACK, "blockstates");
        PackOutput.PathProvider modelPathProvider = this.packOutput.createPathProvider(PackOutput.Target.RESOURCE_PACK, "models");
        for (CropConfig crop : FarmingRegistrator.BERRIES) {
            this.generateFlatItem((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)crop.name())), "item/fruits/", modelOutput);
        }
        for (CropConfig crop : FarmingRegistrator.HERBS) {
            this.generateFlatItem((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)crop.name())), "item/crops/", modelOutput);
            if (!crop.hasSeed()) continue;
            this.generateFlatItem((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)(crop.name() + "_seeds"))), "item/seeds/", modelOutput);
        }
        for (CropConfig crop : FarmingRegistrator.CROPS) {
            this.generateFlatItem((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)crop.name())), "item/crops/", modelOutput);
            if (!crop.hasSeed()) continue;
            this.generateFlatItem((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)(crop.name() + "_seeds"))), "item/seeds/", modelOutput);
        }
        for (CropConfig crop : FarmingRegistrator.TRELLIS) {
            this.generateFlatItem((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)crop.name())), "item/crops/", modelOutput);
            if (!crop.hasSeed()) continue;
            this.generateFlatItem((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)(crop.name() + "_seeds"))), "item/seeds/", modelOutput);
        }
        for (CropConfig crop : FarmingRegistrator.VERTICAL_TRELLIS) {
            this.generateFlatItem((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)crop.name())), "item/crops/", modelOutput);
            if (!crop.hasSeed()) continue;
            this.generateFlatItem((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)(crop.name() + "_seeds"))), "item/seeds/", modelOutput);
        }
        for (CropConfig crop : FarmingRegistrator.GRAPES) {
            this.generateFlatItem((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)crop.name())), "item/crops/", modelOutput);
            if (!crop.hasSeed()) continue;
            this.generateFlatItem((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)(crop.name() + "_seeds"))), "item/seeds/", modelOutput);
        }
        for (CropConfig crop : FarmingRegistrator.STEMS) {
            this.addBlockItemParentModel((Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)crop.name())), "crops/", "", itemModels);
            this.generateFlatItem((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)(crop.name() + "_slice"))), "item/fruits/", modelOutput);
            if (!crop.hasSeed()) continue;
            this.generateFlatItem((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)(crop.name() + "_seeds"))), "item/seeds/", modelOutput);
        }
        for (CropConfig crop : FarmingRegistrator.SHROOMS) {
            this.generateFlatItem((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)crop.name())), "item/shrooms/", modelOutput);
        }
        for (FishConfig fish : FarmingRegistrator.FISHIES) {
            if (fish.hasBlock()) {
                this.generateFlatItem((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)fish.name())), "item/fish/", modelOutput);
            } else {
                this.generateFlatItem((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)("raw_" + fish.name()))), "item/fish/", modelOutput);
            }
            if (fish.entitySupplier() != null) {
                // empty if block
            }
            this.generateFlatItem((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)("cooked_" + fish.name()))), "item/fish/", modelOutput);
        }
        FarmingRegistrator.CRATED_CROPS.forEach(crate -> this.addBlockItemParentModel((Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)(crate.getPath() + "_crate"))), "crates/", "", itemModels));
        FarmingRegistrator.SEED_BAGS.forEach(seedName -> this.addItemParentModel((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)(seedName.getPath() + "_bag"))), ResourceLocation.withDefaultNamespace((String)"builtin/entity"), "", "", itemModels));
        for (FlowerConfig flower : FarmingRegistrator.FLOWERS) {
            block2 = (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)flower.name()));
            if (block2 instanceof ColorfulTallFlowerBlock) {
                this.generateTwoLayerFlatItem(block2.asItem(), "block/flowers/", "/upper", "_flower", modelOutput);
                continue;
            }
            this.generateTwoLayerFlatItem(block2.asItem(), "block/flowers/", "/" + flower.name(), "_flower", modelOutput);
        }
        for (FlowerConfig vine : FarmingRegistrator.VINES) {
            block2 = (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)vine.name()));
            this.generateTwoLayerFlatItem(block2.asItem(), "block/flowers/", "/" + vine.name(), "_flower", modelOutput);
        }
        this.generateFlatItem((Item)FarmingRegistrator.POLLEN.get(), "item/", modelOutput);
        this.generateFlatItem((Item)FarmingRegistrator.DRIED_LUFFA.get(), "item/materials/", modelOutput);
        this.generateFlatItem((Item)FarmingRegistrator.DRIED_TOBACCO.get(), "item/materials/", modelOutput);
        this.generateFlatItem((Item)FarmingRegistrator.CORN_COB_PIPE.get(), "item/", modelOutput);
        this.generateFlatItem((Item)FarmingRegistrator.BLACK_TEA.get(), "item/", modelOutput);
        this.addBlockItemParentModel((Block)FarmingRegistrator.FEEDING_TROUGH.get(), "", "/empty", itemModels);
        this.addBlockItemParentModel((Block)FarmingRegistrator.WATERING_TROUGH.get(), "", "/empty", itemModels);
        ArrayList output = new ArrayList();
        blockModels.forEach((block, supplier) -> output.add(DataProvider.saveStable((CachedOutput)cache, (JsonElement)((JsonElement)supplier.get()), (Path)blockstatePathProvider.json(BuiltInRegistries.BLOCK.getKey(block)))));
        itemModels.forEach((rLoc, supplier) -> output.add(DataProvider.saveStable((CachedOutput)cache, (JsonElement)((JsonElement)supplier.get()), (Path)modelPathProvider.json(rLoc))));
        return CompletableFuture.allOf((CompletableFuture[])output.toArray(CompletableFuture[]::new));
    }

    private void generateTwoLayerFlatItem(Item item, String prefix, String suffix, String append, BiConsumer<ResourceLocation, Supplier<JsonElement>> modelOutput) {
        ModelTemplates.TWO_LAYERED_ITEM.create(ModelLocationUtils.getModelLocation((Item)item), ModelProvider.getDoubleFlatItemTextureMap(item, prefix, suffix, append), modelOutput);
    }

    private void generateFlatItem(Item item, String prefix, BiConsumer<ResourceLocation, Supplier<JsonElement>> modelOutput) {
        ModelTemplates.FLAT_ITEM.create(ModelLocationUtils.getModelLocation((Item)item), ModelProvider.getFlatItemTextureMap(item, prefix), modelOutput);
    }

    private static TextureMapping getFlatItemTextureMap(Item item, String prefix) {
        return ModelProvider.getFlatItemTextureMap(item, prefix, "");
    }

    private static TextureMapping getFlatItemTextureMap(Item item, String prefix, String suffix) {
        return ModelProvider.getFlatItemTextureMap(BuiltInRegistries.ITEM.getKey((Object)item), prefix, suffix);
    }

    private static TextureMapping getFlatItemTextureMap(ResourceLocation resourceLocation, String prefix, String suffix) {
        return new TextureMapping().put(TextureSlot.LAYER0, resourceLocation.withPrefix(prefix).withSuffix(suffix));
    }

    private static TextureMapping getDoubleFlatItemTextureMap(Item item, String prefix, String suffix, String append) {
        return ModelProvider.getDoubleFlatItemTextureMap(BuiltInRegistries.ITEM.getKey((Object)item), prefix, suffix, append);
    }

    private static TextureMapping getDoubleFlatItemTextureMap(ResourceLocation resourceLocation, String prefix, String suffix, String append) {
        return new TextureMapping().put(TextureSlot.LAYER0, resourceLocation.withPrefix(prefix).withSuffix(suffix)).put(TextureSlot.LAYER1, resourceLocation.withPrefix(prefix).withSuffix(suffix + append));
    }

    private void addItemModel(Item item, Supplier<JsonElement> supplier, Map<ResourceLocation, Supplier<JsonElement>> itemModels) {
        ResourceLocation resourcelocation;
        if (item != null && !itemModels.containsKey(resourcelocation = ModelLocationUtils.getModelLocation((Item)item))) {
            itemModels.put(resourcelocation, supplier);
        }
    }

    private void addBlockItemModel(Block block, String base, Map<ResourceLocation, Supplier<JsonElement>> itemModels) {
        Item item = (Item)Item.BY_BLOCK.get(block);
        if (item != null) {
            this.addItemModel(item, (Supplier<JsonElement>)new DelegatedModel(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)("block/" + base))), itemModels);
        }
    }

    private void addBlockItemParentModel(Block block, String prefix, String suffix, Map<ResourceLocation, Supplier<JsonElement>> itemModels) {
        Item item = (Item)Item.BY_BLOCK.get(block);
        if (item != null) {
            ResourceLocation rl = BuiltInRegistries.BLOCK.getKey((Object)block);
            this.addItemParentModel(item, rl, "block/" + prefix, suffix, itemModels);
        }
    }

    private void addItemParentModel(Item item, ResourceLocation rl, String prefix, String suffix, Map<ResourceLocation, Supplier<JsonElement>> itemModels) {
        this.addItemModel(item, (Supplier<JsonElement>)new DelegatedModel(ResourceLocation.fromNamespaceAndPath((String)rl.getNamespace(), (String)(prefix + rl.getPath() + suffix))), itemModels);
    }

    public String getName() {
        return "Productive Farming Blockstate and Model generator";
    }

    static class ModelGenerator {
        Consumer<BlockStateGenerator> blockStateOutput;
        BiConsumer<ResourceLocation, Supplier<JsonElement>> modelOutput;
        static ModelTemplate verticalTrellisLeaves = new ModelTemplate(Optional.of(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)"block/vertical_trellis_leaves")), Optional.empty(), new TextureSlot[]{TextureSlot.ALL});
        static ModelTemplate vineLeaves = new ModelTemplate(Optional.of(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)"block/inset_leaves")), Optional.empty(), new TextureSlot[]{TextureSlot.ALL});
        static ModelTemplate attachedFencedStemModel = new ModelTemplate(Optional.of(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)"block/fenced_stem_attached")), Optional.empty(), new TextureSlot[]{TextureSlot.STEM});
        static ModelTemplate crop = new ModelTemplate(Optional.of(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)"block/crop")), Optional.empty(), new TextureSlot[]{TextureSlot.CROP});
        static ModelTemplate cross = new ModelTemplate(Optional.of(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)"block/cross")), Optional.empty(), new TextureSlot[]{TextureSlot.CROSS});
        static ModelTemplate crossOverlay = new ModelTemplate(Optional.of(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)"block/cross_overlay")), Optional.empty(), new TextureSlot[]{TextureSlot.CROSS, TextureSlot.EDGE});
        static ModelTemplate thiccCrossOverlay = new ModelTemplate(Optional.of(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)"block/cross_overlay_thicc")), Optional.empty(), new TextureSlot[]{TextureSlot.CROSS, TextureSlot.EDGE});
        static ModelTemplate pottedBase = new ModelTemplate(Optional.of(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)"block/tinted_flower_pot_cross")), Optional.empty(), new TextureSlot[]{TextureSlot.PLANT, TextureSlot.STEM});
        static ModelTemplate vineOverlay = new ModelTemplate(Optional.of(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)"block/vine_overlay")), Optional.empty(), new TextureSlot[]{TextureSlot.PLANT, TextureSlot.EDGE});
        String[] styles = new String[]{"ash", "pomegranate", "teak", "walnut", "whitebeam"};
        static ModelTemplate crateModel = new ModelTemplate(Optional.of(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)"block/base_crate")), Optional.empty(), new TextureSlot[]{TextureSlot.BOTTOM, TextureSlot.SIDE, TextureSlot.TOP, TextureSlot.CROP});

        ModelGenerator() {
        }

        protected void registerStatesAndModels(Consumer<BlockStateGenerator> blockStateOutput, BiConsumer<ResourceLocation, Supplier<JsonElement>> modelOutput) {
            this.blockStateOutput = blockStateOutput;
            this.modelOutput = modelOutput;
            Block NUTRIENT_WATER_BLOCK = (Block)BuiltInRegistries.BLOCK.get(FarmingRegistrator.NUTRIENT_WATER.getId());
            this.blockStateOutput.accept((BlockStateGenerator)ModelGenerator.createSimpleBlock(NUTRIENT_WATER_BLOCK, ModelTemplates.CUBE_ALL.create(NUTRIENT_WATER_BLOCK, TextureMapping.cube((ResourceLocation)ResourceLocation.withDefaultNamespace((String)"block/water_still")), modelOutput)));
            Stream.concat(FarmingRegistrator.CROPS.stream(), FarmingRegistrator.VANILLA_CROPS.stream()).forEach(crop -> {
                Block block;
                Block block2 = block = (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)crop.name()));
                Objects.requireNonNull(block2);
                Block selector0$temp = block2;
                int index$1 = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{GrainCropBlock.class, DoubleGrainCropBlock.class, DoubleCropBlock.class}, (Object)selector0$temp, index$1)) {
                    case 0: {
                        GrainCropBlock grainCropBlock = (GrainCropBlock)selector0$temp;
                        this.createCropPlant((Block)grainCropBlock, "crops/");
                        break;
                    }
                    case 1: {
                        DoubleGrainCropBlock doubleGrainCropBlock = (DoubleGrainCropBlock)selector0$temp;
                        this.createDoubleCropPlant((Block)doubleGrainCropBlock, "crops/");
                        break;
                    }
                    case 2: {
                        DoubleCropBlock doubleCropBlock = (DoubleCropBlock)selector0$temp;
                        this.createDoubleCrossPlant((Block)doubleCropBlock, "crops/");
                        break;
                    }
                    default: {
                        this.createCrossPlant(block, "crops/");
                    }
                }
            });
            FarmingRegistrator.TRELLIS.forEach(crop -> {
                Block leafBlock = (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)(crop.name() + "_leaves")));
                Block stemBlock = (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)crop.name()));
                Block attachedStemBlock = (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)("attached_" + crop.name() + "_stem")));
                this.createFenceGrowingPlantBlock(stemBlock, attachedStemBlock, leafBlock, "crops/", "trellis/");
            });
            FarmingRegistrator.VERTICAL_TRELLIS.forEach(crop -> {
                Block leafBlock = (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)crop.name()));
                this.createFenceGrowingPlantLeafBlock(leafBlock, "trellis/", verticalTrellisLeaves);
            });
            FarmingRegistrator.GRAPES.forEach(crop -> {
                Block leafBlock = (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)(crop.name() + "_leaves")));
                Block stemBlock = (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)crop.name()));
                Block attachedStemBlock = (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)("attached_" + crop.name() + "_stem")));
                this.createFenceGrowingPlantBlock(stemBlock, attachedStemBlock, leafBlock, "crops/", "grapes/");
            });
            FarmingRegistrator.STEMS.forEach(crop -> {
                Block fruitBlock = (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)crop.name()));
                Block stemBlock = (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)(crop.name() + "_stem")));
                Block attachedStemBlock = (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)("attached_" + crop.name() + "_stem")));
                this.createStemBlock(stemBlock, attachedStemBlock, fruitBlock, "crops/");
            });
            FarmingRegistrator.HERBS.forEach(crop -> this.createCrossPlant((Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)crop.name())), "herbs/"));
            FarmingRegistrator.BERRIES.forEach(crop -> this.createCrossPlant((Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)crop.name())), "bushes/"));
            FarmingRegistrator.FISHIES.forEach(fish -> {
                Block block;
                if (fish.hasBlock() && (block = (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)fish.name()))) instanceof ClamBlock) {
                    ClamBlock clamBlock = (ClamBlock)block;
                    this.createClam((Block)clamBlock);
                }
            });
            FarmingRegistrator.CRATED_CROPS.forEach(crate -> this.createCrate((Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)(crate.getPath() + "_crate")))));
            FarmingRegistrator.FLOWERS.forEach(flower -> {
                Block block = (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)flower.name()));
                if (flower.isDouble()) {
                    this.createTallCrossFlower(block, "flowers/", flower.name(), flower.isThicc());
                } else {
                    this.createCrossFlower(block, "flowers/", flower.name());
                }
            });
            FarmingRegistrator.VINES.forEach(flower -> {
                Block block = (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)flower.name()));
                this.createMultiface(block, "flowers/", flower.name());
            });
            this.createFeedingTrough((Block)FarmingRegistrator.FEEDING_TROUGH.get());
            this.createFeedingTrough((Block)FarmingRegistrator.WATERING_TROUGH.get());
            this.createAttachedMushroom((Block)FarmingRegistrator.BROWN_MUSHROOM_GROWTH.get());
            this.createAttachedMushroom((Block)FarmingRegistrator.RED_MUSHROOM_GROWTH.get());
            this.createAttachedMushroom((Block)FarmingRegistrator.CRIMSON_FUNGUS_GROWTH.get());
            this.createAttachedMushroom((Block)FarmingRegistrator.WARPED_FUNGUS_GROWTH.get());
            FarmingRegistrator.SHROOMS.forEach(cropConfig -> this.createAttachedMushroom((Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)(cropConfig.name() + "_growth")))));
        }

        private void createFenceGrowingPlantBlock(Block stem, Block attachedStem, Block leafBlock, String prefix, String type) {
            IntegerProperty integerProperty;
            if (stem instanceof IAgeableCropBlock) {
                IAgeableCropBlock cropBlock = (IAgeableCropBlock)stem;
                integerProperty = cropBlock.getAgeProperty();
            } else {
                integerProperty = BlockStateProperties.AGE_3;
            }
            IntegerProperty prop = integerProperty;
            this.blockStateOutput.accept((BlockStateGenerator)MultiVariantGenerator.multiVariant((Block)stem).with(PropertyDispatch.property((Property)prop).generate(age -> Variant.variant().with(VariantProperties.MODEL, (Object)this.createSuffixedStemVariant(stem, prefix, "stage_" + age, new ModelTemplate(Optional.of(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)"block/fenced_stem_full")), Optional.empty(), new TextureSlot[]{TextureSlot.STEM}), type, "stage_" + age)))));
            this.blockStateOutput.accept((BlockStateGenerator)MultiVariantGenerator.multiVariant((Block)attachedStem, (Variant)Variant.variant().with(VariantProperties.MODEL, (Object)this.createSuffixedStemVariant(attachedStem, prefix, "attached", attachedFencedStemModel, type, "attached"))));
            this.createFenceGrowingPlantLeafBlock(leafBlock, type, vineLeaves);
        }

        private void createFenceGrowingPlantLeafBlock(Block leafBlock, String type, ModelTemplate model) {
            IntegerProperty integerProperty;
            if (leafBlock instanceof IAgeableCropBlock) {
                IAgeableCropBlock cropBlock = (IAgeableCropBlock)leafBlock;
                integerProperty = cropBlock.getAgeProperty();
            } else {
                integerProperty = BlockStateProperties.AGE_3;
            }
            IntegerProperty prop = integerProperty;
            this.blockStateOutput.accept((BlockStateGenerator)MultiVariantGenerator.multiVariant((Block)leafBlock).with(PropertyDispatch.property((Property)prop).generate(age -> Variant.variant().with(VariantProperties.MODEL, (Object)model.create(TextureMapping.getBlockTexture((Block)leafBlock).withPath(p -> "block/" + type + p.replace("block/", "") + "_" + age), new TextureMapping().put(TextureSlot.ALL, TextureMapping.getBlockTexture((Block)leafBlock).withPath(p -> "block/" + type + p.replace("block/", "").replace("_leaves", "") + "/stage_" + age)), this.modelOutput)))));
        }

        private void createStemBlock(Block stem, Block attachedStem, Block fruitBlock, String prefix) {
            this.blockStateOutput.accept((BlockStateGenerator)ModelGenerator.createSimpleBlock(fruitBlock, TexturedModel.COLUMN.get(fruitBlock).getTemplate().create(ModelLocationUtils.getModelLocation((Block)fruitBlock).withPath(p -> p.replace("block/", "block/" + prefix)), TextureMapping.column((ResourceLocation)TextureMapping.getBlockTexture((Block)fruitBlock, (String)"_side").withPath(p -> p.replace("block/", "block/" + prefix)), (ResourceLocation)TextureMapping.getBlockTexture((Block)fruitBlock, (String)"_top").withPath(p -> p.replace("block/", "block/" + prefix))), this.modelOutput)));
            ResourceLocation stemTexture = TextureMapping.getBlockTexture((Block)stem).withPath(p -> p.replace("block/", "block/" + prefix));
            ResourceLocation attachedStemTexture = TextureMapping.getBlockTexture((Block)attachedStem).withPath(p -> p.replace("block/", "block/" + prefix));
            TextureMapping stemTextureMap = TextureMapping.singleSlot((TextureSlot)TextureSlot.STEM, (ResourceLocation)stemTexture);
            TextureMapping attachedStemTextureMap = new TextureMapping().put(TextureSlot.STEM, stemTexture).put(TextureSlot.UPPER_STEM, attachedStemTexture);
            ResourceLocation attachedStemModel = RenderTypedModelTemplate.ATTACHED_STEM.create(ModelLocationUtils.getModelLocation((Block)attachedStem).withPath(p -> p.replace("block/", "block/" + prefix)), attachedStemTextureMap, this.modelOutput);
            this.blockStateOutput.accept((BlockStateGenerator)MultiVariantGenerator.multiVariant((Block)attachedStem, (Variant)Variant.variant().with(VariantProperties.MODEL, (Object)attachedStemModel)).with((PropertyDispatch)PropertyDispatch.property((Property)BlockStateProperties.HORIZONTAL_FACING).select((Comparable)Direction.WEST, Variant.variant()).select((Comparable)Direction.SOUTH, Variant.variant().with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R270)).select((Comparable)Direction.NORTH, Variant.variant().with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R90)).select((Comparable)Direction.EAST, Variant.variant().with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R180))));
            this.blockStateOutput.accept((BlockStateGenerator)MultiVariantGenerator.multiVariant((Block)stem).with(PropertyDispatch.property((Property)BlockStateProperties.AGE_7).generate(age -> Variant.variant().with(VariantProperties.MODEL, (Object)RenderTypedModelTemplate.STEMS[age].create(ModelLocationUtils.getModelLocation((Block)stem).withPath(p -> p.replace("block/", "block/" + prefix) + "_stage" + age), stemTextureMap, this.modelOutput)))));
        }

        private void createCropPlant(Block block, String prefix) {
            IntegerProperty integerProperty;
            if (block instanceof IAgeableCropBlock) {
                IAgeableCropBlock cropBlock = (IAgeableCropBlock)block;
                integerProperty = cropBlock.getAgeProperty();
            } else {
                integerProperty = BlockStateProperties.AGE_3;
            }
            IntegerProperty prop = integerProperty;
            this.blockStateOutput.accept((BlockStateGenerator)MultiVariantGenerator.multiVariant((Block)block).with(PropertyDispatch.property((Property)prop).generate(age -> Variant.variant().with(VariantProperties.MODEL, (Object)this.createSuffixedVariant(block, prefix, "/stage_" + age, crop, TextureMapping::crop)))));
        }

        private void createDoubleCropPlant(Block block, String prefix) {
            IntegerProperty integerProperty;
            if (block instanceof IAgeableCropBlock) {
                IAgeableCropBlock cropBlock = (IAgeableCropBlock)block;
                integerProperty = cropBlock.getAgeProperty();
            } else {
                integerProperty = BlockStateProperties.AGE_3;
            }
            IntegerProperty prop = integerProperty;
            this.blockStateOutput.accept((BlockStateGenerator)MultiVariantGenerator.multiVariant((Block)block).with(PropertyDispatch.properties((Property)prop, (Property)BlockStateProperties.DOUBLE_BLOCK_HALF).generate((age, part) -> Variant.variant().with(VariantProperties.MODEL, (Object)this.createSuffixedVariant(block, prefix, "/" + part.getSerializedName() + "/stage_" + age, crop, TextureMapping::crop)))));
        }

        private void createCrossPlant(Block block, String prefix) {
            IntegerProperty integerProperty;
            if (block instanceof IAgeableCropBlock) {
                IAgeableCropBlock cropBlock = (IAgeableCropBlock)block;
                integerProperty = cropBlock.getAgeProperty();
            } else {
                integerProperty = BlockStateProperties.AGE_3;
            }
            IntegerProperty prop = integerProperty;
            this.blockStateOutput.accept((BlockStateGenerator)MultiVariantGenerator.multiVariant((Block)block).with(PropertyDispatch.property((Property)prop).generate(age -> Variant.variant().with(VariantProperties.MODEL, (Object)this.createSuffixedVariant(block, prefix, "/stage_" + age, cross, TextureMapping::cross)))));
        }

        private void createDoubleCrossPlant(Block block, String name) {
            IntegerProperty integerProperty;
            if (block instanceof IAgeableCropBlock) {
                IAgeableCropBlock cropBlock = (IAgeableCropBlock)block;
                integerProperty = cropBlock.getAgeProperty();
            } else {
                integerProperty = BlockStateProperties.AGE_3;
            }
            IntegerProperty prop = integerProperty;
            this.blockStateOutput.accept((BlockStateGenerator)MultiVariantGenerator.multiVariant((Block)block).with(PropertyDispatch.properties((Property)prop, (Property)BlockStateProperties.DOUBLE_BLOCK_HALF).generate((age, part) -> Variant.variant().with(VariantProperties.MODEL, (Object)this.createSuffixedVariant(block, name, "/" + part.getSerializedName() + "/stage_" + age, cross, TextureMapping::cross)))));
        }

        private void createCrossFlower(Block block, String prefix, String name) {
            this.blockStateOutput.accept((BlockStateGenerator)MultiVariantGenerator.multiVariant((Block)block, (Variant)Variant.variant().with(VariantProperties.MODEL, (Object)this.createSuffixedVariant(block, prefix, "/" + name, crossOverlay, resourceLocation -> new TextureMapping().put(TextureSlot.CROSS, resourceLocation.withPath(p -> p)).put(TextureSlot.EDGE, resourceLocation.withPath(p -> p + "_flower"))))));
            Block pottedBlock = (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)("potted_" + name)));
            this.blockStateOutput.accept((BlockStateGenerator)MultiVariantGenerator.multiVariant((Block)pottedBlock, (Variant)Variant.variant().with(VariantProperties.MODEL, (Object)this.createSuffixedVariant(block, prefix, "/potted_" + name, pottedBase, resourceLocation -> new TextureMapping().put(TextureSlot.PLANT, resourceLocation.withPath(p -> p.replace("potted_", ""))).put(TextureSlot.STEM, resourceLocation.withPath(p -> p.replace("potted_", "") + "_flower"))))));
        }

        private void createTallCrossFlower(Block block, String prefix, String suffix, boolean isThicc) {
            this.blockStateOutput.accept((BlockStateGenerator)MultiVariantGenerator.multiVariant((Block)block).with(PropertyDispatch.property((Property)BlockStateProperties.DOUBLE_BLOCK_HALF).generate(part -> Variant.variant().with(VariantProperties.MODEL, (Object)this.createSuffixedVariant(block, prefix, "/" + part.getSerializedName(), isThicc ? thiccCrossOverlay : crossOverlay, resourceLocation -> new TextureMapping().put(TextureSlot.CROSS, resourceLocation.withPath(p -> p)).put(TextureSlot.EDGE, resourceLocation.withPath(p -> p + "_flower")))))));
        }

        private static TextureMapping crossOverlay(Block block) {
            return new TextureMapping().put(TextureSlot.CROSS, ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)"block/crate/top")).put(TextureSlot.EDGE, ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)"block/crate/side"));
        }

        private void createMultiface(Block block, String prefix, String name) {
            ResourceLocation resourceLocation = BuiltInRegistries.BLOCK.getKey((Object)block).withPath(path -> "block/" + prefix + path + "/" + name);
            this.createSuffixedVariant(block, prefix, "/" + name, vineOverlay, location -> new TextureMapping().put(TextureSlot.PLANT, location.withPath(p -> p)).put(TextureSlot.EDGE, location.withPath(p -> p + "_flower")));
            MultiPartGenerator multipartgenerator = MultiPartGenerator.multiPart((Block)block);
            Condition.TerminalCondition condition$terminalcondition = (Condition.TerminalCondition)Util.make((Object)Condition.condition(), condition -> BlockModelGenerators.MULTIFACE_GENERATOR.stream().map(Pair::getFirst).forEach(property -> {
                if (block.defaultBlockState().hasProperty((Property)property)) {
                    condition.term((Property)property, (Comparable)Boolean.valueOf(false));
                }
            }));
            for (Pair pair : BlockModelGenerators.MULTIFACE_GENERATOR) {
                BooleanProperty booleanproperty = (BooleanProperty)pair.getFirst();
                Function function = (Function)pair.getSecond();
                if (!block.defaultBlockState().hasProperty((Property)booleanproperty)) continue;
                multipartgenerator.with((Condition)Condition.condition().term((Property)booleanproperty, (Comparable)Boolean.valueOf(true)), (Variant)function.apply(resourceLocation));
                multipartgenerator.with((Condition)condition$terminalcondition, (Variant)function.apply(resourceLocation));
            }
            this.blockStateOutput.accept((BlockStateGenerator)multipartgenerator);
        }

        private ResourceLocation createSuffixedVariant(Block pBlock, String pPrefix, String pSuffix, ModelTemplate pModelTemplate, Function<ResourceLocation, TextureMapping> pTextureMappingGetter) {
            ResourceLocation resourceLocation = BuiltInRegistries.BLOCK.getKey((Object)pBlock).withPath(path -> "block/" + pPrefix + path + pSuffix);
            return pModelTemplate.create(resourceLocation, pTextureMappingGetter.apply(resourceLocation), this.modelOutput);
        }

        private ResourceLocation createSuffixedStemVariant(Block pBlock, String pPrefix, String pSuffix, ModelTemplate pModelTemplate, String type, String textureSuffix) {
            ResourceLocation resourceLocation = BuiltInRegistries.BLOCK.getKey((Object)pBlock).withPath(path -> "block/" + pPrefix + path.replace("attached_", "").replace("_stem", "") + "/" + pSuffix);
            return pModelTemplate.create(resourceLocation, TextureMapping.singleSlot((TextureSlot)TextureSlot.STEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)("block/" + type + "stem/" + textureSuffix))), this.modelOutput);
        }

        private void createCrate(Block block) {
            ResourceLocation top = BuiltInRegistries.BLOCK.getKey((Object)block).withPath(p -> "block/crate/" + p);
            String style = this.styles[top.getPath().length() % 5];
            TextureMapping textureMapping = new TextureMapping().put(TextureSlot.TOP, ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)("block/crate/" + style + "/top"))).put(TextureSlot.SIDE, ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)("block/crate/" + style + "/side"))).put(TextureSlot.BOTTOM, ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)("block/crate/" + style + "/bottom"))).put(TextureSlot.CROP, top);
            this.blockStateOutput.accept((BlockStateGenerator)MultiVariantGenerator.multiVariant((Block)block, (Variant)Variant.variant().with(VariantProperties.MODEL, (Object)crateModel.create(BuiltInRegistries.BLOCK.getKey((Object)block).withPath(p -> "block/crates/" + p), textureMapping, this.modelOutput))));
        }

        private void createClam(Block block) {
            ResourceLocation resourcelocation = BuiltInRegistries.BLOCK.getKey((Object)block).withPath(path -> "block/fish/" + path);
            this.blockStateOutput.accept((BlockStateGenerator)MultiVariantGenerator.multiVariant((Block)block).with(PropertyDispatch.property((Property)BlockStateProperties.OPEN).generate(open -> Variant.variant().with(VariantProperties.MODEL, (Object)resourcelocation.withPath(path -> open != false ? path + "_open" : path)))).with(ModelGenerator.createFacingDispatch()));
        }

        private static PropertyDispatch createFacingDispatch() {
            return PropertyDispatch.properties((Property)BlockStateProperties.ATTACH_FACE, (Property)BlockStateProperties.HORIZONTAL_FACING).select((Comparable)AttachFace.FLOOR, (Comparable)Direction.EAST, Variant.variant().with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R90)).select((Comparable)AttachFace.FLOOR, (Comparable)Direction.WEST, Variant.variant().with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R270)).select((Comparable)AttachFace.FLOOR, (Comparable)Direction.SOUTH, Variant.variant().with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R180)).select((Comparable)AttachFace.FLOOR, (Comparable)Direction.NORTH, Variant.variant()).select((Comparable)AttachFace.WALL, (Comparable)Direction.EAST, Variant.variant().with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R90).with(VariantProperties.X_ROT, (Object)VariantProperties.Rotation.R90)).select((Comparable)AttachFace.WALL, (Comparable)Direction.WEST, Variant.variant().with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R270).with(VariantProperties.X_ROT, (Object)VariantProperties.Rotation.R90)).select((Comparable)AttachFace.WALL, (Comparable)Direction.SOUTH, Variant.variant().with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R180).with(VariantProperties.X_ROT, (Object)VariantProperties.Rotation.R90)).select((Comparable)AttachFace.WALL, (Comparable)Direction.NORTH, Variant.variant().with(VariantProperties.X_ROT, (Object)VariantProperties.Rotation.R90)).select((Comparable)AttachFace.CEILING, (Comparable)Direction.EAST, Variant.variant().with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R270).with(VariantProperties.X_ROT, (Object)VariantProperties.Rotation.R180)).select((Comparable)AttachFace.CEILING, (Comparable)Direction.WEST, Variant.variant().with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R90).with(VariantProperties.X_ROT, (Object)VariantProperties.Rotation.R180)).select((Comparable)AttachFace.CEILING, (Comparable)Direction.SOUTH, Variant.variant().with(VariantProperties.X_ROT, (Object)VariantProperties.Rotation.R180)).select((Comparable)AttachFace.CEILING, (Comparable)Direction.NORTH, Variant.variant().with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R180).with(VariantProperties.X_ROT, (Object)VariantProperties.Rotation.R180));
        }

        private void createFeedingTrough(Block block) {
            this.blockStateOutput.accept((BlockStateGenerator)MultiPartGenerator.multiPart((Block)block).with(Variant.variant().with(VariantProperties.MODEL, (Object)TextureMapping.getBlockTexture((Block)block, (String)"/empty"))).with((Condition)Condition.condition().term((Property)FeedingTroughBlock.LEVEL, (Comparable)Integer.valueOf(0)), Variant.variant().with(VariantProperties.MODEL, (Object)TextureMapping.getBlockTexture((Block)block, (String)"/empty"))).with((Condition)Condition.condition().term((Property)FeedingTroughBlock.LEVEL, (Comparable)Integer.valueOf(1)), Variant.variant().with(VariantProperties.MODEL, (Object)TextureMapping.getBlockTexture((Block)block, (String)"/half"))).with((Condition)Condition.condition().term((Property)FeedingTroughBlock.LEVEL, (Comparable)Integer.valueOf(2)), Variant.variant().with(VariantProperties.MODEL, (Object)TextureMapping.getBlockTexture((Block)block, (String)"/full"))));
        }

        void createAttachedMushroom(Block block) {
            ResourceLocation mushroomPlace = BuiltInRegistries.BLOCK.getKey((Object)block).withPath(p -> "block/mushroom_growth/" + p.replace("_growth", ""));
            this.blockStateOutput.accept((BlockStateGenerator)MultiVariantGenerator.multiVariant((Block)block).with(PropertyDispatch.property((Property)BlockStateProperties.AGE_4).generate(age -> {
                ResourceLocation modelLocation = RenderTypedModelTemplate.CROP.create(mushroomPlace.withPath(p -> p + "_stage_" + age), TextureMapping.crop((ResourceLocation)TextureMapping.getBlockTexture((Block)block).withPath(p -> p.replace("block/", "block/shrooms/") + "/stage_" + age)), this.modelOutput);
                return Variant.variant().with(VariantProperties.MODEL, (Object)modelLocation);
            })).with((PropertyDispatch)PropertyDispatch.property((Property)BlockStateProperties.FACING).select((Comparable)Direction.EAST, Variant.variant().with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R90).with(VariantProperties.X_ROT, (Object)VariantProperties.Rotation.R90)).select((Comparable)Direction.SOUTH, Variant.variant().with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R180).with(VariantProperties.X_ROT, (Object)VariantProperties.Rotation.R90)).select((Comparable)Direction.WEST, Variant.variant().with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R270).with(VariantProperties.X_ROT, (Object)VariantProperties.Rotation.R90)).select((Comparable)Direction.NORTH, Variant.variant().with(VariantProperties.X_ROT, (Object)VariantProperties.Rotation.R90)).select((Comparable)Direction.DOWN, Variant.variant().with(VariantProperties.X_ROT, (Object)VariantProperties.Rotation.R180)).select((Comparable)Direction.UP, Variant.variant())));
        }

        void createHorizontalFacing(Block block, ResourceLocation modelLocation) {
            this.blockStateOutput.accept((BlockStateGenerator)MultiVariantGenerator.multiVariant((Block)block, (Variant)Variant.variant().with(VariantProperties.MODEL, (Object)modelLocation)).with((PropertyDispatch)PropertyDispatch.property((Property)BlockStateProperties.HORIZONTAL_FACING).select((Comparable)Direction.EAST, Variant.variant().with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R90).with(VariantProperties.MODEL, (Object)modelLocation)).select((Comparable)Direction.SOUTH, Variant.variant().with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R180)).select((Comparable)Direction.WEST, Variant.variant().with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R270)).select((Comparable)Direction.NORTH, Variant.variant())));
        }

        static MultiVariantGenerator createSimpleBlock(Block block, ResourceLocation modelLocation) {
            return MultiVariantGenerator.multiVariant((Block)block, (Variant)Variant.variant().with(VariantProperties.MODEL, (Object)modelLocation));
        }
    }
}

