/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivefarming.datagen;

import com.google.common.collect.Maps;
import com.mojang.serialization.Codec;
import cy.jdkdigital.productivefarming.common.block.ColorfulTallFlowerBlock;
import cy.jdkdigital.productivefarming.registry.FarmingDataComponents;
import cy.jdkdigital.productivefarming.registry.FarmingRegistrator;
import cy.jdkdigital.productivefarming.util.CropConfig;
import cy.jdkdigital.productivefarming.util.FishConfig;
import cy.jdkdigital.productivefarming.util.FlowerConfig;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.data.loot.LootTableSubProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.IntRange;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.CopyComponentsFunction;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LimitCount;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.predicates.ExplosionCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.BinomialDistributionGenerator;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import org.jetbrains.annotations.NotNull;

public class LootDataProvider
implements DataProvider {
    private final PackOutput.PathProvider pathProvider;
    private final List<LootTableProvider.SubProviderEntry> subProviders;
    private final CompletableFuture<HolderLookup.Provider> registries;

    public LootDataProvider(PackOutput output, List<LootTableProvider.SubProviderEntry> providers, CompletableFuture<HolderLookup.Provider> registries) {
        this.pathProvider = output.createPathProvider(PackOutput.Target.DATA_PACK, "loot_table");
        this.subProviders = providers;
        this.registries = registries;
    }

    public String getName() {
        return "Productive Farming Block Loot Table datagen";
    }

    public CompletableFuture<?> run(CachedOutput pOutput) {
        return this.registries.thenCompose(provider -> this.run(pOutput, (HolderLookup.Provider)provider));
    }

    private CompletableFuture<?> run(CachedOutput pOutput, HolderLookup.Provider pProvider) {
        HashMap map = Maps.newHashMap();
        this.subProviders.forEach(providerEntry -> ((LootTableSubProvider)providerEntry.provider().apply(pProvider)).generate((resourceKey, builder) -> {
            builder.setRandomSequence(resourceKey.location());
            if (map.put(resourceKey.location(), builder.setParamSet(providerEntry.paramSet()).build()) != null) {
                throw new IllegalStateException("Duplicate loot table " + String.valueOf(resourceKey.location()));
            }
        }));
        return CompletableFuture.allOf((CompletableFuture[])map.entrySet().stream().map(entry -> DataProvider.saveStable((CachedOutput)pOutput, (HolderLookup.Provider)pProvider, (Codec)LootTable.DIRECT_CODEC, (Object)((LootTable)entry.getValue()), (Path)this.pathProvider.json((ResourceLocation)entry.getKey()))).toArray(CompletableFuture[]::new));
    }

    public static class LootProvider
    extends BlockLootSubProvider {
        private static final Map<Block, Function<Block, LootTable.Builder>> functionTable = new HashMap<Block, Function<Block, LootTable.Builder>>();
        private List<Block> knownBlocks = new ArrayList<Block>();

        public LootProvider(HolderLookup.Provider provider) {
            super(Set.of(), FeatureFlags.REGISTRY.allFlags(), provider);
        }

        protected void generate() {
            Item seed;
            HolderLookup.RegistryLookup registrylookup = this.registries.lookupOrThrow(Registries.ENCHANTMENT);
            this.dropSelf((Block)FarmingRegistrator.FARM_CONTROLLER.get());
            this.dropSelf((Block)FarmingRegistrator.FEEDING_TROUGH.get());
            this.dropSelf((Block)FarmingRegistrator.WATERING_TROUGH.get());
            for (CropConfig crop : FarmingRegistrator.VANILLA_CROPS) {
                if (crop.hasSeed()) {
                    this.dropSeedCrop(crop);
                    continue;
                }
                this.dropSeedlessCrop(crop);
            }
            for (CropConfig crop : FarmingRegistrator.CROPS) {
                if (crop.hasSeed()) {
                    this.dropSeedCrop(crop);
                    continue;
                }
                this.dropSeedlessCrop(crop);
            }
            for (CropConfig crop : FarmingRegistrator.HERBS) {
                this.dropSeedlessCrop(crop);
            }
            for (CropConfig crop : FarmingRegistrator.BERRIES) {
                this.dropSeedlessCrop(crop);
            }
            for (CropConfig crop : FarmingRegistrator.TRELLIS) {
                if (crop.hasSeed()) {
                    this.dropSeedCrop(crop);
                } else {
                    this.dropSeedlessCrop(crop);
                }
                seed = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)(crop.name() + (crop.hasSeed() ? "_seeds" : ""))));
                this.add((Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)crop.name())), (Block block) -> this.createStemDrops((Block)block, seed));
                this.add((Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)("attached_" + crop.name() + "_stem"))), (Block block) -> this.createAttachedStemDrops((Block)block, seed));
            }
            for (CropConfig crop : FarmingRegistrator.GRAPES) {
                this.dropSeedlessCrop(crop);
                seed = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)(crop.name() + (crop.hasSeed() ? "_seeds" : ""))));
                this.add((Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)crop.name())), (Block block) -> this.createStemDrops((Block)block, seed));
                this.add((Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)("attached_" + crop.name() + "_stem"))), (Block block) -> this.createAttachedVineStemDrops((Block)block, seed));
            }
            for (CropConfig crop : FarmingRegistrator.STEMS) {
                this.add((Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)(crop.name() + "_stem"))), (Block block) -> this.createStemDrops((Block)block, (Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)(crop.name() + "_seeds")))));
                this.add((Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)("attached_" + crop.name() + "_stem"))), (Block block) -> this.createAttachedStemDrops((Block)block, (Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)(crop.name() + "_seeds")))));
                this.add((Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)crop.name())), (Block block) -> this.createSilkTouchDispatchTable((Block)block, (LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)block, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)(crop.name() + "_slice"))))).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)3.0f, (float)7.0f))).apply((LootItemFunction.Builder)ApplyBonusCount.addUniformBonusCount((Holder)registrylookup.getOrThrow(Enchantments.FORTUNE))).apply((LootItemFunction.Builder)LimitCount.limitCount((IntRange)IntRange.upperBound((int)9))))));
            }
            for (FishConfig fish : FarmingRegistrator.FISHIES) {
                if (!fish.hasBlock()) continue;
                this.dropSelf((Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)fish.name())));
            }
            for (FlowerConfig flower : FarmingRegistrator.FLOWERS) {
                this.createFlowerDrops(flower);
            }
            for (FlowerConfig flower : FarmingRegistrator.VINES) {
                this.createFlowerDrops(flower);
            }
        }

        protected void add(Block block, LootTable.Builder builder) {
            super.add(block, builder);
            this.knownBlocks.add(block);
        }

        protected Iterable<Block> getKnownBlocks() {
            return this.knownBlocks;
        }

        protected void add(Block block, Function<Block, LootTable.Builder> builderFunction) {
            this.add(block, builderFunction.apply(block));
        }

        protected void dropSeedCrop(CropConfig crop) {
            Block block = (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)crop.name()));
            if (block instanceof CropBlock) {
                CropBlock cropBlock = (CropBlock)block;
                Item cropItem = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)crop.name()));
                Item seedItem = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)(crop.name() + "_seeds")));
                if (cropItem.equals(Items.AIR)) {
                    cropItem = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.withDefaultNamespace((String)crop.name()));
                }
                if (seedItem.equals(Items.AIR)) {
                    seedItem = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.withDefaultNamespace((String)(crop.name() + "_seeds")));
                }
                LootItemBlockStatePropertyCondition.Builder builder = LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)cropBlock).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)cropBlock.getAgeProperty(), cropBlock.getMaxAge()));
                if (block.defaultBlockState().hasProperty((Property)BlockStateProperties.DOUBLE_BLOCK_HALF)) {
                    builder = LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)cropBlock).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)cropBlock.getAgeProperty(), cropBlock.getMaxAge()).hasProperty((Property)BlockStateProperties.DOUBLE_BLOCK_HALF, (Comparable)DoubleBlockHalf.UPPER));
                }
                this.add((Block)cropBlock, this.createCropDrops((Block)cropBlock, cropItem, seedItem, (LootItemCondition.Builder)builder));
            }
        }

        protected void dropSeedlessCrop(CropConfig crop) {
            Block block = (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)crop.name()));
            if (block instanceof CropBlock) {
                CropBlock cropBlock = (CropBlock)block;
                Item cropItem = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)crop.name()));
                if (cropItem.equals(Items.AIR)) {
                    cropItem = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.withDefaultNamespace((String)crop.name()));
                }
                LootItemBlockStatePropertyCondition.Builder builder = LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)cropBlock).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)cropBlock.getAgeProperty(), cropBlock.getMaxAge()));
                if (block.defaultBlockState().hasProperty((Property)BlockStateProperties.DOUBLE_BLOCK_HALF)) {
                    builder = LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)cropBlock).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)cropBlock.getAgeProperty(), cropBlock.getMaxAge()).hasProperty((Property)BlockStateProperties.DOUBLE_BLOCK_HALF, (Comparable)DoubleBlockHalf.UPPER));
                }
                this.add((Block)cropBlock, this.createSeedlessCropDrops((Block)cropBlock, cropItem, cropItem, (LootItemCondition.Builder)builder));
            }
        }

        public void dropSelf(@NotNull Block block) {
            Function<Block, LootTable.Builder> func = functionTable.getOrDefault(block, LootProvider::genOptionalBlockDrop);
            this.add(block, func.apply(block));
        }

        @NotNull
        protected static LootTable.Builder createSelfDropDispatchTable(Block block, LootItemCondition.Builder conditions, LootPoolEntryContainer.Builder<?> alternative) {
            return LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)block).when(conditions)).otherwise(alternative)));
        }

        protected static LootTable.Builder genOptionalBlockDrop(Block block) {
            LootPoolEntryContainer.Builder builder = LootItem.lootTableItem((ItemLike)block).when(ExplosionCondition.survivesExplosion());
            return LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add(builder));
        }

        public LootTable.Builder createAttachedVineStemDrops(Block block, Item item) {
            return LootTable.lootTable().withPool((LootPool.Builder)this.applyExplosionDecay((ItemLike)block, (FunctionUserBuilder)LootPool.lootPool().setRolls((NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)item).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)BinomialDistributionGenerator.binomial((int)3, (float)0.53333336f))))));
        }

        protected LootTable.Builder createCropDrops(Block cropBlock, Item grownCropItem, Item seedsItem, LootItemCondition.Builder dropGrownCropCondition) {
            HolderLookup.RegistryLookup registrylookup = this.registries.lookupOrThrow(Registries.ENCHANTMENT);
            return (LootTable.Builder)this.applyExplosionDecay((ItemLike)cropBlock, (FunctionUserBuilder)LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)grownCropItem).when(dropGrownCropCondition)).otherwise((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)seedsItem).apply(LootProvider.cropComponents())))).withPool(LootPool.lootPool().when(dropGrownCropCondition).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)seedsItem).apply((LootItemFunction.Builder)ApplyBonusCount.addBonusBinomialDistributionCount((Holder)registrylookup.getOrThrow(Enchantments.FORTUNE), (float)0.5714286f, (int)3)).apply(LootProvider.cropComponents()))));
        }

        protected LootTable.Builder createSeedlessCropDrops(Block cropBlock, Item grownCropItem, Item seedsItem, LootItemCondition.Builder dropGrownCropCondition) {
            HolderLookup.RegistryLookup registrylookup = this.registries.lookupOrThrow(Registries.ENCHANTMENT);
            return (LootTable.Builder)this.applyExplosionDecay((ItemLike)cropBlock, (FunctionUserBuilder)LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)grownCropItem).apply(LootProvider.cropComponents()).when(dropGrownCropCondition)).otherwise((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)seedsItem).apply(LootProvider.cropComponents())))).withPool(LootPool.lootPool().when(dropGrownCropCondition).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)seedsItem).apply((LootItemFunction.Builder)ApplyBonusCount.addBonusBinomialDistributionCount((Holder)registrylookup.getOrThrow(Enchantments.FORTUNE), (float)0.5714286f, (int)3)).apply(LootProvider.cropComponents()))));
        }

        private static LootItemFunction.Builder cropComponents() {
            return CopyComponentsFunction.copyComponents((CopyComponentsFunction.Source)CopyComponentsFunction.Source.BLOCK_ENTITY).include(FarmingDataComponents.GROWTH.get()).include(FarmingDataComponents.YIELD.get()).include(FarmingDataComponents.RESISTANCE.get()).include(FarmingDataComponents.MUTABILITY.get());
        }

        private void createFlowerDrops(FlowerConfig flower) {
            Block block = (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)flower.name()));
            if (!(block instanceof ColorfulTallFlowerBlock)) {
                LootPoolEntryContainer.Builder builder = LootItem.lootTableItem((ItemLike)block).apply((LootItemFunction.Builder)CopyComponentsFunction.copyComponents((CopyComponentsFunction.Source)CopyComponentsFunction.Source.BLOCK_ENTITY).include(FarmingDataComponents.COLOR.get())).when(ExplosionCondition.survivesExplosion());
                this.add(block, LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add(builder)));
            }
        }

        protected <T extends Comparable<T> & StringRepresentable> LootTable.Builder createSinglePropConditionTable(Block block, Property<T> property, T value) {
            return LootTable.lootTable().withPool((LootPool.Builder)this.applyExplosionCondition((ItemLike)block, (ConditionUserBuilder)LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add(LootItem.lootTableItem((ItemLike)block).apply((LootItemFunction.Builder)CopyComponentsFunction.copyComponents((CopyComponentsFunction.Source)CopyComponentsFunction.Source.BLOCK_ENTITY).include(FarmingDataComponents.COLOR.get())).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty(property, value))))));
        }
    }
}

