/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivefarming.datagen;

import cy.jdkdigital.productivefarming.ProductiveFarming;
import cy.jdkdigital.productivefarming.registry.FarmingRegistrator;
import cy.jdkdigital.productivelib.util.LangUtil;
import java.util.HashMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemNameBlockItem;
import net.minecraft.world.item.MobBucketItem;
import net.minecraft.world.level.block.Block;

public class LanguageProvider
extends net.neoforged.neoforge.common.data.LanguageProvider {
    public LanguageProvider(PackOutput output) {
        super(output, "productivefarming", "en_us");
    }

    protected void addTranslations() {
        this.add("itemGroup.productivefarming", "Productive Farming");
        this.add("jei.productivefarming.crop_fruiting", "Crop Fruiting");
        this.add("jei.productivefarming.crop_mutation", "Crop Mutation");
        this.add("jade.productivefarming.mutation", "Mutation: %s");
        this.add("config.jade.plugin_productivefarming.crop", "Crops");
        this.add("productivefarming.screen.progress", "Progress: %s");
        this.add("productivefarming.message.farm_formed", "Farm structure assembled with height %s");
        this.add("productivefarming.message.farm_invalid", "Farm structure invalid. %s");
        this.add("block.productivefarming.watering_trough.tooltip", "Increases growth speed of nearby animals");
        this.add("block.productivefarming.feeding_trough.tooltip", "Makes nearby animals breed");
        this.add("productivefarming.pollen.name", "%s");
        this.add("productivefarming.information.pollen", "Use on a fully grown crop to manually pollinate it.");
        this.add("productivefarming.tooltip.extend", "Hold [SHIFT] for more info");
        this.add("productivefarming.tooltip.fencepost_crop", "Must be planted on a fence post");
        this.add("productivefarming.trait.growth", "Growth speed: %s");
        this.add("productivefarming.trait.yield", "Yield: %s");
        this.add("productivefarming.trait.resistance", "Resistance: %s");
        this.add("productivefarming.trait.mutability", "Mutability: %s");
        this.add("productivefarming.trait_value.none", "None");
        this.add("productivefarming.trait_value.low", "Low");
        this.add("productivefarming.trait_value.medium", "Medium");
        this.add("productivefarming.trait_value.high", "High");
        this.add("productivefarming.trait_value.very_high", "Very High");
        ProductiveFarming.BLOCKS.getEntries().forEach(holder -> {
            String regName = BuiltInRegistries.BLOCK.getKey((Object)((Block)holder.get())).getPath();
            if (regName.equals("ferula_crate")) {
                this.add((Block)holder.get(), "Asafoetida Crate");
            } else {
                this.add((Block)holder.get(), LangUtil.capName((String)BuiltInRegistries.BLOCK.getKey((Object)((Block)holder.get())).getPath()));
            }
        });
        ProductiveFarming.ITEMS.getEntries().forEach(holder -> {
            if (holder.get() instanceof MobBucketItem) {
                this.add((Item)holder.get(), "Bucket of " + this.capName(BuiltInRegistries.ITEM.getKey((Object)((Item)holder.get())).getPath().replace("_bucket", "")));
            } else if (!(holder.get() instanceof BlockItem) || holder.get() instanceof ItemNameBlockItem) {
                String regName = BuiltInRegistries.ITEM.getKey((Object)((Item)holder.get())).getPath();
                if (regName.contains("grape_seeds")) {
                    this.add((Item)holder.get(), LangUtil.capName((String)regName.replace("seeds", "propagule")));
                } else if (regName.contains("sarsaparilla_vine_seeds")) {
                    this.add((Item)holder.get(), LangUtil.capName((String)regName.replace("seeds", "roots")));
                } else if (regName.equals("ferula")) {
                    this.add((Item)holder.get(), "Asafoetida");
                } else {
                    this.add((Item)holder.get(), LangUtil.capName((String)regName));
                }
            }
        });
        ProductiveFarming.ENTITY_TYPES.getEntries().forEach(entityTypeRegistryObject -> this.add((EntityType)entityTypeRegistryObject.get(), this.capName(BuiltInRegistries.ENTITY_TYPE.getKey((Object)((EntityType)entityTypeRegistryObject.get())).getPath())));
        FarmingRegistrator.CROPS.forEach(crop -> this.add("tooltip.productivefarming." + crop.name() + ".latin", LanguageProvider.getLatinName(crop.name())));
        FarmingRegistrator.VANILLA_CROPS.forEach(crop -> this.add("tooltip.productivefarming." + crop.name() + ".latin", LanguageProvider.getLatinName(crop.name())));
        FarmingRegistrator.GRAPES.forEach(crop -> this.add("tooltip.productivefarming." + crop.name() + ".latin", LanguageProvider.getLatinName(crop.name())));
        FarmingRegistrator.BERRIES.forEach(crop -> this.add("tooltip.productivefarming." + crop.name() + ".latin", LanguageProvider.getLatinName(crop.name())));
        FarmingRegistrator.HERBS.forEach(crop -> this.add("tooltip.productivefarming." + crop.name() + ".latin", LanguageProvider.getLatinName(crop.name())));
        FarmingRegistrator.STEMS.forEach(crop -> this.add("tooltip.productivefarming." + crop.name() + ".latin", LanguageProvider.getLatinName(crop.name())));
        FarmingRegistrator.TRELLIS.forEach(crop -> this.add("tooltip.productivefarming." + crop.name() + ".latin", LanguageProvider.getLatinName(crop.name())));
        FarmingRegistrator.VERTICAL_TRELLIS.forEach(crop -> this.add("tooltip.productivefarming." + crop.name() + ".latin", LanguageProvider.getLatinName(crop.name())));
        this.add("tooltip.productivefarming.red_mushroom.latin", LanguageProvider.getLatinName("red_mushroom"));
        this.add("tooltip.productivefarming.brown_mushroom.latin", LanguageProvider.getLatinName("brown_mushroom"));
        this.add("tooltip.productivefarming.warped_fungus.latin", LanguageProvider.getLatinName("warped_fungus"));
        this.add("tooltip.productivefarming.crimson_fungus.latin", LanguageProvider.getLatinName("crimson_fungus"));
        this.add("productivefarming.ponder.farm_building.header", "Multiblock Farms Structure");
        this.add("productivefarming.ponder.farm_building.text_1", "The minimum size for the farm is 3x3, corners are optional");
        this.add("productivefarming.ponder.farm_building.text_2", "The inside of the farm can be any block you need for your crops");
        this.add("productivefarming.ponder.farm_building.text_3", "Additionally, the farm multiblock must have a Farm Controller...");
        this.add("productivefarming.ponder.farm_farming.header", "Multiblock Farming");
        this.add("productivefarming.ponder.farm_farming.text_1", "Crops planted on the farm will be automatically harvested");
        this.add("productivefarming.ponder.farm_farming.text_2", "When crops grow they have a small chance to improve their traits");
        this.add("productivefarming.ponder.fish_farm.header", "Fish farms");
        this.add("productivefarming.ponder.fish_farm.text_1", "If you make your farm taller you can use it as a fish farm");
        this.add("productivefarming.ponder.fish_farm.text_2", "Creatures inside the farm boundaries will be automatically bred and slaughtered");
        this.add("productivefarming.ponder.fish_farm.text_3", "Fish will produce nutrient rich water which can be pumped to a crop farm for increased growth");
        this.add("productivefarming.ponder.fish_farm.text_4", "You can also combine the two farms and have an aquaponics system");
    }

    public String getName() {
        return "Productive Farming translation provider";
    }

    private String capName(String name) {
        CharSequence[] nameParts = name.split("_");
        for (int i = 0; i < nameParts.length; ++i) {
            nameParts[i] = ((String)nameParts[i]).substring(0, 1).toUpperCase() + ((String)nameParts[i]).substring(1);
        }
        return String.join((CharSequence)" ", nameParts) + "s";
    }

    private static String getLatinName(String name) {
        HashMap<String, String> names = new HashMap<String, String>(){
            {
                this.put("wheat", "Triticum aestivum");
                this.put("potato", "Solanum tuberosum");
                this.put("carrot", "Daucus carota");
                this.put("beetroot", "Beta vulgaris");
                this.put("kadsura", "Kadsura japonica");
                this.put("blackberry", "Rubus fruticosus");
                this.put("blackcurrant", "Ribes nigrum");
                this.put("blueberry", "Vaccinium myrtillus");
                this.put("boysenberry", "Rubus fruticosus \u00d7 Rubus idaeus");
                this.put("cloudberry", "Rubus chamaemorus");
                this.put("checkerberry", "Gaultheria procumbens");
                this.put("cranberry", "Vaccinium oxycoccos");
                this.put("golden_raspberry", "Rubus idaeus 'All Gold'");
                this.put("gooseberry", "Ribes uva-crispa");
                this.put("huckleberry", "Vaccinium ovatum");
                this.put("lingoberry", "Vaccinium vitis-idaea");
                this.put("miracle_berry", "Synsepalum dulcificum");
                this.put("raspberry", "Rubus idaeus");
                this.put("redcurrant", "Ribes rubrum");
                this.put("thimbleberry", "Rubus parviflorus");
                this.put("agave", "Agave tequilana");
                this.put("basil", "Ocimum basilicum");
                this.put("blue_borage", "Borago officinalis");
                this.put("cardamon", "Elettaria cardamomum");
                this.put("catnip", "Nepeta cataria");
                this.put("caraway", "Carum carvi");
                this.put("chamomile", "Matricaria chamomilla");
                this.put("chives", "Allium schoenoprasum");
                this.put("coriander", "Coriandrum sativum");
                this.put("cotton", "Gossypium arboreum");
                this.put("cumin", "Cuminum cyminum");
                this.put("dill", "Anethum graveolens");
                this.put("mint", "Mentha spicata");
                this.put("oregano", "Origanum vulgare");
                this.put("parsley", "Petroselinum crispum");
                this.put("rosemary", "Salvia rosmarinus");
                this.put("sage", "Salvia officinalis");
                this.put("fat_hen", "Chenopodium album");
                this.put("ferula", "Ferula assa-foetida");
                this.put("fenugreek", "Trigonella foenum-graecum");
                this.put("flax", "Linum usitatissimum");
                this.put("ostrich_fiddlehead", "Matteuccia struthiopteris");
                this.put("cantaloupe", "Cucumis melo var. Cantalupensis");
                this.put("honeydew_melon", "Cucumis melo var. Inodorus");
                this.put("red_grape", "Vitis vinifera");
                this.put("fox_grape", "Vitis labrusca");
                this.put("concord_grape", "Vitis labrusca x Vitis vinifera");
                this.put("cotton_candy_grape", "IFG Seven");
                this.put("green_grape", "");
                this.put("butternut_squash", "Cucurbita moschata");
                this.put("spoon_gourd", "Cucurbita pepo var. ovifera");
                this.put("luffa", "Luffa aegyptiaca");
                this.put("cucumber", "Cucumis sativus");
                this.put("zucchini", "Cucurbita pepo var. longa");
                this.put("kiwi", "Actinidia deliciosa");
                this.put("hops", "Humulus lupulus");
                this.put("vanilla", "Vanilla planifolia");
                this.put("akebia", "Akebia quinata");
                this.put("goji_berry", "Lycium barbarum");
                this.put("arrowroot", "Maranta arundinacea");
                this.put("arugula", "Eruca sativa");
                this.put("green_bell_pepper", "");
                this.put("orange_bell_pepper", "");
                this.put("red_bell_pepper", "");
                this.put("yellow_bell_pepper", "");
                this.put("black_bell_pepper", "");
                this.put("purple_bell_pepper", "");
                this.put("white_bell_pepper", "");
                this.put("black_beans", "");
                this.put("bok_choy", "Brassica rapa s. chinensis");
                this.put("broccoli", "Brassica oleracea var. italica");
                this.put("brussels_sprout", "Brassica oleracea var. gemmifera");
                this.put("burdock_root", "Arctium lappa");
                this.put("butterhead_lettuce", "Lactuca sativa var. capitata");
                this.put("cabbage", "Brassica oleracea var. capitata f. alba");
                this.put("cauliflower", "Brassica oleracea var. botrytis");
                this.put("cassava", "Manihot esculenta");
                this.put("celery", "Apium graveolens var. dulce");
                this.put("chard", "Beta vulgaris subsp. vulgaris var. cicla");
                this.put("chili_pepper", "");
                this.put("collard", "Brassica oleracea var. viridis");
                this.put("daikon", "Raphanus sativus var. longipinnatus");
                this.put("eddoe", "Colocasia antiquorum");
                this.put("eggplant", "Solanum melongena");
                this.put("endive", "Cichorium intybus");
                this.put("garlic", "Allium sativum");
                this.put("iceberg_lettuce", "Lactuca sativa var. capitata");
                this.put("jalapeno", "Capsicum annuum");
                this.put("jute", "Corchorus capsularis");
                this.put("kale", "Brassica oleracea var. sabellica");
                this.put("kidney_beans", "Phaseolus vulgaris");
                this.put("kohlrabi", "Brassica oleracea var. gongylodes");
                this.put("leek", "Allium ampeloprasum var. porrum");
                this.put("lima_beans", "Phaseolus lunatus");
                this.put("onion", "Allium cepa");
                this.put("parsnip", "Pastinaca sativa");
                this.put("peas", "Lathyrus oleraceus");
                this.put("pinto_beans", "Phaseolus vulgaris");
                this.put("radish", "Raphanus sativus");
                this.put("rhubarb", "Rheum rhabarbarum");
                this.put("romain_lettuce", "Lactuca sativa var. longifolia");
                this.put("rutabaga", "Brassica napus var. napobrassica");
                this.put("salsify", "Tragopogon porrifolius");
                this.put("spinach", "Spinacia oleracea");
                this.put("strawberry", "Fragaria \u00d7 ananassa");
                this.put("sugar_beet", "Beta vulgaris var. saccharifera");
                this.put("turnip", "Brassica rapa var. rapa");
                this.put("ulluco", "Ullucus tuberosus");
                this.put("wasabi", "Eutrema japonicum");
                this.put("yam", "Dioscorea cayenensis");
                this.put("peanuts", "Arachis hypogaea");
                this.put("ginger", "Zingiber officinale");
                this.put("green_bean", "Phaseolus vulgaris");
                this.put("spring_onion", "Allium fistulosum");
                this.put("saguaro", "Carnegiea gigantea");
                this.put("squash", "Cucurbita Pepo");
                this.put("sarsaparilla", "Smilax ornata");
                this.put("sweet_potato", "Ipomoea batatas");
                this.put("lentils", "Vicia lens");
                this.put("chickpeas", "Cicer arietinum");
                this.put("mustard", "Brassica juncea");
                this.put("black_pepper", "Piper nigrum");
                this.put("turmeric", "Curcuma longa");
                this.put("rice", "Oryza sativa");
                this.put("oats", "Avena sativa");
                this.put("barley", "Hordeum vulgare");
                this.put("rye", "Secale cereale");
                this.put("amaranth", "Amaranthus blitum");
                this.put("teff", "Eragrostis tef");
                this.put("pitaya", "Selenicereus undatus");
                this.put("monstera_deliciosa", "Monstera deliciosa");
                this.put("tobacco", "Nicotiana tabacum");
                this.put("tea", "Camellia sinensis");
                this.put("pineapple", "Ananas comosus");
                this.put("quinoa", "Chenopodium quinoa");
                this.put("yellow_dent_corn", "Zea mays convar. saccharata var. rugosa");
                this.put("sugar_pearl_corn", "Zea mays convar. saccharata var. rugosa");
                this.put("rainbow_corn", "Zea mays convar. saccharata var. rugosa");
                this.put("blue_jade_corn", "Zea mays convar. saccharata var. rugosa");
                this.put("black_aztec_corn", "Zea mays convar. saccharata var. rugosa");
                this.put("tomatillo", "Physalis philadelphica");
                this.put("thyme", "Thymus vulgaris");
                this.put("beefsteak_tomato", "Solanum lycopersicum var. coustralee");
                this.put("black_beauty_tomato", "Solanum lycopersicum var. gates");
                this.put("blue_beauty_tomato", "Solanum lycopersicum");
                this.put("chocolate_pear_tomato", "Solanum lycopersicum var. terrior");
                this.put("sungold_tomato", "Solanum lycopersicum");
                this.put("white_wonder_tomato", "Solanum lycopersicum");
                this.put("yellow_pear_tomato", "Solanum lycopersicum");
                this.put("roma_tomato", "Solanum lycopersicum var. roma");
                this.put("cherry_tomato", "Solanum lycopersicum var. cerasiforme");
                this.put("konjac", "Amorphophallus konjac");
                this.put("okra", "Abelmoschus esculentus");
                this.put("asparagus", "Asparagus officinalis");
                this.put("artichoke", "Cynara cardunculus var. scolymus");
                this.put("malanga", "Xanthosoma sagittifolium");
                this.put("water_chestnut", "Eleocharis dulcis");
                this.put("watercress", "Nasturtium officinale");
                this.put("water_caltrop", "Trapa natans");
                this.put("prickly_pear", "Opuntia ficus-indica");
                this.put("sea_buckthorn", "Hippophae rhamnoides");
                this.put("soy_bean", "Glycine max");
                this.put("sweet_marjoram", "Origanum majorana");
                this.put("sorghum", "Sorghum bicolor");
                this.put("spearmint", "Mentha spicata");
                this.put("peppermint", "Mentha \u00d7 piperita");
                this.put("watermint", "Mentha aquatica");
                this.put("lemon_balm", "Melissa officinalis");
                this.put("lemongrass", "Cymbopogon schoenanthus");
                this.put("wintergreen", "Gaultheria procumbens");
                this.put("red_mushroom", "Amanita muscaria");
                this.put("brown_mushroom", "Boletus edulis");
                this.put("warped_fungus", "Fungus contortus");
                this.put("crimson_fungus", "Fungus coccinus");
                this.put("black_truffle", "Tuber melanosporum");
                this.put("chanterelle", "Cantharellus cibarius");
                this.put("laetiporus", "Laetiporus speciosus");
                this.put("lions_mane", "Hericium erinaceus");
                this.put("morel", "Morchella esculenta");
                this.put("oyster_mushroom", "Pleurotus ostreatus");
                this.put("porcini", "Boletus edulis");
                this.put("portobello", "Agaricus bisporus");
                this.put("shiitake", "Lentinula edodes");
            }
        };
        return (String)((Object)names.getOrDefault(name, "Missing taxonomy for " + name));
    }
}

