/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivefarming.datagen;

import cy.jdkdigital.productivefarming.registry.FarmingRegistrator;
import cy.jdkdigital.productivefarming.registry.ModTags;
import cy.jdkdigital.productivefarming.util.CropConfig;
import cy.jdkdigital.productivefarming.util.FishConfig;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.IntrinsicHolderTagsProvider;
import net.minecraft.data.tags.ItemTagsProvider;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class ItemTagProvider
extends ItemTagsProvider {
    public ItemTagProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> future, CompletableFuture<TagsProvider.TagLookup<Block>> provider, ExistingFileHelper helper) {
        super(output, future, provider, "productivefarming", helper);
    }

    protected void addTags(HolderLookup.Provider provider) {
        TagKey tag;
        this.copy(BlockTags.SMALL_FLOWERS, ItemTags.SMALL_FLOWERS);
        this.copy(BlockTags.TALL_FLOWERS, ItemTags.TALL_FLOWERS);
        this.copy(ModTags.Blocks.FARM_WALL_BLOCKS, ModTags.Items.FARM_WALL_BLOCKS);
        this.tag(ItemTags.DURABILITY_ENCHANTABLE).add((Object)((Item)FarmingRegistrator.CORN_COB_PIPE.get()));
        this.tag(ModTags.Items.FERTILIZERS).add((Object)Items.BONE_MEAL);
        this.tag(ModTags.Items.MUSHROOMS).add((Object[])new Item[]{Items.BROWN_MUSHROOM, Items.RED_MUSHROOM, Items.CRIMSON_FUNGUS, Items.WARPED_FUNGUS});
        this.tag(ModTags.Items.DRIED_TOBACCO).add((Object)((Item)FarmingRegistrator.DRIED_TOBACCO.get()));
        this.tag(ModTags.Items.TOBACCO).addTag(ModTags.Items.DRIED_TOBACCO);
        this.tag(ModTags.Items.VANILLA_SEEDS).add((Object[])new Item[]{Items.WHEAT_SEEDS, Items.BEETROOT_SEEDS, Items.POTATO, Items.CARROT, Items.RED_MUSHROOM, Items.BROWN_MUSHROOM, Items.CRIMSON_FUNGUS, Items.WARPED_FUNGUS});
        for (CropConfig crop : FarmingRegistrator.HERBS) {
            TagKey herbTag = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)("herbs/" + crop.name())));
            this.tag(herbTag).add((Object)((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)crop.name()))));
            this.tag(ModTags.Items.HERBS).addTag(herbTag);
            this.addSeed(crop);
            this.addParentTag("herbs", "herbs/" + crop.name());
        }
        for (CropConfig crop : FarmingRegistrator.BERRIES) {
            tag = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)("berries/" + crop.name())));
            this.tag(tag).add((Object)((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)crop.name()))));
            this.tag(ModTags.Items.BERRIES).addTag(tag);
            this.addSeed(crop);
        }
        for (CropConfig crop : FarmingRegistrator.CROPS) {
            tag = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)("crops/" + crop.name())));
            this.addParentTag("crops", "crops/" + crop.name());
            this.tag(tag).add((Object)((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)crop.name()))));
            this.addSeed(crop);
        }
        for (CropConfig crop : FarmingRegistrator.TRELLIS) {
            tag = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)("crops/" + crop.name())));
            this.tag(tag).add((Object)((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)crop.name()))));
            this.addParentTag("crops", "crops/" + crop.name());
            this.addSeed(crop);
            this.tag(ModTags.Items.FENCEPOST_CROP).add((Object)((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)crop.name()))));
        }
        for (CropConfig crop : FarmingRegistrator.VERTICAL_TRELLIS) {
            tag = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)("crops/" + crop.name())));
            this.addParentTag("crops", "crops/" + crop.name());
            this.tag(tag).add((Object)((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)crop.name()))));
            this.addSeed(crop);
            this.tag(ModTags.Items.FENCEPOST_CROP).add((Object)((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)crop.name()))));
        }
        for (CropConfig crop : FarmingRegistrator.GRAPES) {
            tag = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)("crops/" + crop.name())));
            this.addParentTag("crops", "crops/" + crop.name());
            this.tag(tag).add((Object)((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)crop.name()))));
            this.addSeed(crop);
            this.tag(ModTags.Items.FENCEPOST_CROP).add((Object)((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)crop.name()))));
        }
        for (CropConfig crop : FarmingRegistrator.STEMS) {
            tag = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)("crops/" + crop.name())));
            this.addParentTag("crops", "crops/" + crop.name());
            this.tag(tag).add((Object)((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)crop.name()))));
            this.addSeed(crop);
        }
        for (CropConfig crop : FarmingRegistrator.SHROOMS) {
            this.tag(ModTags.Items.MUSHROOMS).add((Object)((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)crop.name()))));
        }
        for (FishConfig fish : FarmingRegistrator.FISHIES) {
            tag = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)fish.name()));
            if (fish.hasBlock()) {
                this.tag(tag).add((Object)((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)fish.name()))));
            } else {
                this.tag(tag).add((Object)((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)("raw_" + fish.name())))));
            }
            this.tag(ModTags.Items.FISHES).addTag(tag);
        }
        FarmingRegistrator.CRATED_CROPS.forEach(resourceLocation -> {
            TagKey bTagKey = BlockTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)("storage_blocks/" + resourceLocation.getPath())));
            TagKey tagKey = ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)("storage_blocks/" + resourceLocation.getPath())));
            this.copy(bTagKey, tagKey);
            this.tag(Tags.Items.STORAGE_BLOCKS).addTag(tagKey);
        });
        FarmingRegistrator.SEED_BAGS.forEach(resourceLocation -> {
            TagKey tagKey = ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)("storage_blocks/" + resourceLocation.getPath())));
            this.tag(tagKey).add((Object)((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)resourceLocation.withPath(p -> p + "_bag").getPath()))));
            this.tag(Tags.Items.STORAGE_BLOCKS).addTag(tagKey);
        });
        this.addGeneralTag("leafy_greens", "arugula", "bok_choy", "butterhead_lettuce", "celery", "chard", "collard", "endive", "iceberg_lettuce", "kale", "romain_lettuce", "spinach", "watercress");
        this.addGeneralTag("tomatoes", "roma_tomato", "beefsteak_tomato", "black_beauty_tomato", "blue_beauty_tomato", "white_wonder_tomato");
        this.addGeneralTag("cherry_tomatoes", "cherry_tomato", "chocolate_pear_tomato", "yellow_pear_tomato", "sungold_tomato");
        this.addGeneralTag("vegetables", "arrowroot", "green_bell_pepper", "yellow_bell_pepper", "orange_bell_pepper", "red_bell_pepper", "black_bell_pepper", "purple_bell_pepper", "white_bell_pepper", "broccoli", "brussels_sprout", "burdock_root", "cauliflower", "daikon", "eddoe", "eggplant", "endive", "kohlrabi", "leek", "onion", "parsnip", "peas", "pineapple", "radish", "rhubarb", "rutabaga", "salsify", "sugar_beet", "turnip", "ulluco", "wasabi", "peanuts", "ginger", "green_bean", "spring_onion", "sweet_potato", "wintergreen", "pitaya", "monstera_deliciosa", "black_aztec_corn", "blue_jade_corn", "rainbow_corn", "sugar_pearl_corn", "yellow_dent_corn", "tomatillo", "konjac", "okra", "asparagus", "artichoke", "malanga", "yam", "water_chestnut", "water_caltrop");
        this.addGeneralTag("corn", "black_aztec_corn", "blue_jade_corn", "rainbow_corn", "sugar_pearl_corn", "yellow_dent_corn");
        this.addParentTag("leafy_green", "leafy_greens");
        this.addParentTag("tomatoes", "cherry_tomatoes");
        this.addParentTag("tomato", "tomatoes");
        this.addParentTag("cherry_tomato", "cherry_tomatoes");
        this.addParentTag("vegetable", "vegetables");
    }

    private void addParentTag(String parentTag, String tagName) {
        IntrinsicHolderTagsProvider.IntrinsicTagAppender parent = this.tag(ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)parentTag)));
        TagKey tag = ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)tagName));
        parent.addTag(tag);
    }

    private void addGeneralTag(String tagName, String ... crops) {
        IntrinsicHolderTagsProvider.IntrinsicTagAppender tag = this.tag(ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)tagName)));
        for (String crop : crops) {
            tag.add((Object)((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)crop))));
        }
    }

    private void addSeed(CropConfig crop) {
        if (crop.hasSeed()) {
            IntrinsicHolderTagsProvider.IntrinsicTagAppender seedTag = this.tag(Tags.Items.SEEDS);
            TagKey cropSeedTag = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)("seeds/" + crop.name())));
            this.tag(cropSeedTag).add((Object)((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)(crop.name() + "_seeds")))));
            this.tag(ItemTags.VILLAGER_PLANTABLE_SEEDS).addTag(cropSeedTag);
            seedTag.addTag(cropSeedTag);
        }
    }

    public String getName() {
        return "Productive Farming Item Tags Provider";
    }
}

