/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivefarming.datagen;

import cy.jdkdigital.productivefarming.registry.FarmingRegistrator;
import cy.jdkdigital.productivefarming.registry.ModTags;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.IntrinsicHolderTagsProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.data.BlockTagsProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class BlockTagProvider
extends BlockTagsProvider {
    public BlockTagProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> provider, ExistingFileHelper helper) {
        super(output, provider, "productivefarming", helper);
    }

    protected void addTags(HolderLookup.Provider provider) {
        this.tag(BlockTags.MINEABLE_WITH_PICKAXE).add((Object[])new Block[]{(Block)FarmingRegistrator.FARM_CONTROLLER.get(), (Block)FarmingRegistrator.FEEDING_TROUGH.get(), (Block)FarmingRegistrator.WATERING_TROUGH.get()});
        this.tag(ModTags.Blocks.FARMLAND).add((Object)Blocks.FARMLAND);
        this.tag(ModTags.Blocks.FARM_WALL_BLOCKS).addTag(BlockTags.STONE_BRICKS).addTag(Tags.Blocks.GLASS_BLOCKS).add((Object)Blocks.HOPPER).add((Object[])new Block[]{Blocks.BRICKS, Blocks.MUD_BRICKS, Blocks.QUARTZ_BRICKS, Blocks.PRISMARINE_BRICKS}).add((Object[])new Block[]{Blocks.DEEPSLATE_BRICKS, Blocks.CRACKED_DEEPSLATE_BRICKS, Blocks.END_STONE_BRICKS}).add((Object[])new Block[]{Blocks.NETHER_BRICKS, Blocks.CRACKED_NETHER_BRICKS, Blocks.CHISELED_NETHER_BRICKS, Blocks.RED_NETHER_BRICKS}).add((Object[])new Block[]{Blocks.TUFF_BRICKS, Blocks.CHISELED_TUFF_BRICKS, Blocks.POLISHED_BLACKSTONE_BRICKS, Blocks.CRACKED_POLISHED_BLACKSTONE_BRICKS});
        this.tag(ModTags.Blocks.FARM_BLOCKS).addTag(ModTags.Blocks.FARM_WALL_BLOCKS).add((Object[])new Block[]{(Block)FarmingRegistrator.FARM_CONTROLLER.get(), (Block)FarmingRegistrator.FARM_HATCH.get()});
        this.tag(BlockTags.MAINTAINS_FARMLAND).addTag(Tags.Blocks.FENCES).add((Object[])new Block[]{(Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)"cantaloupe")), (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)"honeydew_melon"))});
        this.tag(BlockTags.create((ResourceLocation)ResourceLocation.parse((String)"utilitarian:farmland_cansurvive"))).addTag(Tags.Blocks.FENCES).add((Object[])new Block[]{(Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)"cantaloupe")), (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)"honeydew_melon"))});
        IntrinsicHolderTagsProvider.IntrinsicTagAppender umBlacklist = this.tag(BlockTags.create((ResourceLocation)ResourceLocation.parse((String)"ftbultimine:single_crop_harvesting_blacklist")));
        for (Block cropBlock : FarmingRegistrator.getAllCrops()) {
            umBlacklist.add((Object)cropBlock);
        }
        this.tag(ModTags.Blocks.CAN_SPAWN_FROM_BONEMEAL).add((Object[])new Block[]{(Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)"amaryllis")), (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)"anemone")), (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)"balloon_flower")), (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)"black_bearded_iris")), (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)"cattail")), (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)"cape_leadwort")), (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)"chrysanthemum")), (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)"dahlia")), (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)"great_lobelia")), (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)"hellebore")), (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)"himalayan_poppy")), (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)"hydrangea")), (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)"motherwort")), (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)"sea_holly")), (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)"skullcap")), (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)"stinging_nettle")), (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)"valerian_root")), (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)"zinnia"))});
        this.tag(ModTags.Blocks.PLAINS_VILLAGE_FARM_CROPS).add((Object[])new Block[]{(Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)"bok_choy")), (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)"broccoli")), (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)"green_bell_pepper")), (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)"brussels_sprout")), (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)"butterhead_lettuce")), (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)"cabbage")), (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)"cauliflower")), (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)"celery")), (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)"eggplant")), (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)"kale")), (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)"onion")), (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)"radish")), (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)"spinach")), (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)"turnip")), (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)"spring_onion"))});
        this.tag(ModTags.Blocks.SAVANNA_VILLAGE_FARM_CROPS).add((Object[])new Block[]{(Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)"kale")), (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)"chard")), (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)"leek")), (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)"broccoli")), (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)"spinach")), (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)"cabbage")), (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)"butterhead_lettuce")), (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)"turnip")), (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)"brussels_sprout")), (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)"rutabaga")), (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)"collards"))});
        this.tag(ModTags.Blocks.SNOWY_VILLAGE_FARM_CROPS).add((Object[])new Block[]{(Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)"kale")), (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)"chard")), (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)"leek")), (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)"broccoli")), (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)"spinach")), (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)"cabbage")), (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)"butterhead_lettuce")), (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)"turnip")), (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)"brussels_sprout")), (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)"rutabaga")), (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)"collards"))});
        this.tag(ModTags.Blocks.TAIGA_VILLAGE_FARM_CROPS).add((Object[])new Block[]{(Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)"kale")), (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)"chard")), (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)"leek")), (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)"broccoli")), (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)"spinach")), (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)"cabbage")), (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)"butterhead_lettuce")), (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)"turnip")), (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)"brussels_sprout")), (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)"rutabaga")), (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)"collards"))});
        this.tag(ModTags.Blocks.DESERT_VILLAGE_FARM_CROPS).add((Object[])new Block[]{(Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)"eggplant")), (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)"squash")), (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)"lentils")), (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)"mustard"))});
        FarmingRegistrator.FLOWERS.forEach(flowerConfig -> {
            if (flowerConfig.isDouble()) {
                this.tag(BlockTags.TALL_FLOWERS).add((Object)((Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)flowerConfig.name()))));
            } else {
                this.tag(BlockTags.SMALL_FLOWERS).add((Object)((Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)flowerConfig.name()))));
            }
        });
        FarmingRegistrator.VINES.forEach(flowerConfig -> this.tag(BlockTags.FLOWERS).add((Object)((Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)flowerConfig.name())))));
        this.tag(ModTags.Blocks.POLLINATABLE).addTag(BlockTags.FLOWERS).addTag(BlockTags.CROPS);
        Arrays.stream(FarmingRegistrator.getAllCrops()).forEach(crop -> this.tag(BlockTags.CROPS).add(crop));
        FarmingRegistrator.GRAPES.forEach(crop -> {
            Block block = (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)(crop.name() + "_leaves")));
            this.tag(BlockTags.FENCES).add((Object)block);
        });
        FarmingRegistrator.TRELLIS.forEach(crop -> {
            Block block = (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)(crop.name() + "_leaves")));
            this.tag(BlockTags.FENCES).add((Object)block);
        });
        FarmingRegistrator.VERTICAL_TRELLIS.forEach(crop -> {
            Block block = (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)crop.name()));
            this.tag(BlockTags.FENCES).add((Object)block);
        });
        FarmingRegistrator.FISHIES.forEach(fishConfig -> {
            if (fishConfig.hasBlock()) {
                this.tag(ModTags.Blocks.FARMABLE_FISH_BLOCKS).add((Object)((Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)fishConfig.name()))));
            }
        });
        FarmingRegistrator.CRATED_CROPS.forEach(resourceLocation -> {
            TagKey tagKey = BlockTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)("storage_blocks/" + resourceLocation.getPath())));
            this.tag(tagKey).add((Object)((Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)resourceLocation.withPath(p -> p + "_crate").getPath()))));
            this.tag(Tags.Blocks.STORAGE_BLOCKS).addTag(tagKey);
        });
    }

    public String getName() {
        return "Productive Farming Block Tags Provider";
    }
}

