/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivefarming.common.item;

import cy.jdkdigital.productivefarming.common.block.entity.FencedCropBlockEntity;
import cy.jdkdigital.productivefarming.common.item.CropBlockItem;
import cy.jdkdigital.productivefarming.registry.ModTags;
import cy.jdkdigital.productivefarming.world.context.FenceCropBlockPlaceContext;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.Tags;

public class StemGrowinSeedItem
extends CropBlockItem {
    public StemGrowinSeedItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    public InteractionResult useOn(UseOnContext context) {
        BlockEntity blockEntity;
        Level level = context.getLevel();
        BlockState state = level.getBlockState(context.getClickedPos());
        BlockState stateBelow = level.getBlockState(context.getClickedPos().below());
        if (state.is(Tags.Blocks.FENCES) && stateBelow.is(ModTags.Blocks.FARMLAND)) {
            context = new UseOnContext(context.getLevel(), context.getPlayer(), context.getHand(), context.getItemInHand(), new BlockHitResult(Vec3.ZERO, Direction.UP, context.getClickedPos().below(), true));
        } else {
            state = level.getBlockState(context.getClickedPos().above());
        }
        InteractionResult interactionresult = this.place(new FenceCropBlockPlaceContext(context));
        if (!interactionresult.consumesAction() && context.getItemInHand().has(DataComponents.FOOD)) {
            InteractionResult interactionResult = super.use(context.getLevel(), context.getPlayer(), context.getHand()).getResult();
            return interactionResult == InteractionResult.CONSUME ? InteractionResult.CONSUME_PARTIAL : interactionResult;
        }
        if (!level.isClientSide() && (blockEntity = level.getBlockEntity(context.getClickedPos().above())) instanceof FencedCropBlockEntity) {
            FencedCropBlockEntity fencedCropBlockEntity = (FencedCropBlockEntity)blockEntity;
            fencedCropBlockEntity.setFence(state.getBlock().defaultBlockState());
        }
        return interactionresult;
    }
}

