/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivefarming.common.item;

import cy.jdkdigital.productivefarming.client.render.item.SeedBagItemRenderer;
import cy.jdkdigital.productivefarming.registry.ModTags;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public class SeedBagItem
extends Item {
    private final ResourceLocation seed;

    public SeedBagItem(ResourceLocation seed, Item.Properties pProperties) {
        super(pProperties);
        this.seed = seed;
    }

    public InteractionResult useOn(UseOnContext pContext) {
        Item seedItem;
        if (pContext.getPlayer() != null && pContext.getLevel().getBlockState(pContext.getClickedPos()).is(ModTags.Blocks.FARMLAND) && (seedItem = (Item)BuiltInRegistries.ITEM.get(this.seed)) instanceof BlockItem) {
            ItemStack leftOver;
            IItemHandler iItemHandler;
            BlockItem seedBlock = (BlockItem)seedItem;
            AABB area = new AABB(pContext.getClickedPos()).inflate(1.0);
            AtomicInteger plantedSeeds = new AtomicInteger(0);
            BlockPos.betweenClosedStream((AABB)area).forEach(blockPos -> {
                if (pContext.getLevel().getBlockState(blockPos).is(ModTags.Blocks.FARMLAND) && pContext.getLevel().getBlockState(blockPos.above()).isAir()) {
                    pContext.getLevel().setBlockAndUpdate(blockPos.above(), seedBlock.getBlock().defaultBlockState());
                    plantedSeeds.getAndIncrement();
                }
            });
            if (plantedSeeds.get() < 9 && (iItemHandler = (IItemHandler)pContext.getPlayer().getCapability(Capabilities.ItemHandler.ENTITY)) != null && !(leftOver = ItemHandlerHelper.insertItemStacked((IItemHandler)iItemHandler, (ItemStack)new ItemStack((ItemLike)seedItem, 9 - plantedSeeds.get()), (boolean)false)).isEmpty()) {
                Block.popResource((Level)pContext.getLevel(), (BlockPos)pContext.getClickedPos().above(), (ItemStack)leftOver);
            }
            if (plantedSeeds.get() > 0 && !pContext.getPlayer().isCreative()) {
                pContext.getItemInHand().shrink(1);
                pContext.getPlayer().swing(pContext.getHand());
            }
            return InteractionResult.CONSUME;
        }
        return super.useOn(pContext);
    }

    public ResourceLocation getSeed() {
        return this.seed;
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(this){
            final BlockEntityWithoutLevelRenderer myRenderer = new SeedBagItemRenderer();

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return this.myRenderer;
            }
        });
    }
}

