/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivefarming.common.item;

import cy.jdkdigital.productivefarming.common.block.ProductiveCropBlock;
import cy.jdkdigital.productivefarming.registry.FarmingDataComponents;
import cy.jdkdigital.productivefarming.util.FarmUtil;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.FoliageColor;
import net.minecraft.world.level.block.Block;

public class PollenItem
extends Item {
    public PollenItem(Item.Properties properties) {
        super(properties);
    }

    public void appendHoverText(ItemStack pStack, Item.TooltipContext pContext, List<Component> pTooltipComponents, TooltipFlag pTooltipFlag) {
        super.appendHoverText(pStack, pContext, pTooltipComponents, pTooltipFlag);
        if (pStack.has(FarmingDataComponents.POLLEN_BLOCK_COMPONENT)) {
            Block leaf = (Block)BuiltInRegistries.BLOCK.get((ResourceLocation)pStack.get(FarmingDataComponents.POLLEN_BLOCK_COMPONENT));
            pTooltipComponents.add((Component)Component.translatable((String)"productivefarming.pollen.name", (Object[])new Object[]{Component.translatable((String)leaf.getDescriptionId()).withStyle(ChatFormatting.GREEN)}).withStyle(ChatFormatting.DARK_BLUE));
        }
        pTooltipComponents.add((Component)Component.translatable((String)"productivefarming.information.pollen").withStyle(ChatFormatting.GOLD));
    }

    public static int getColor(ItemStack stack) {
        if (stack.has(FarmingDataComponents.POLLEN_BLOCK_COMPONENT)) {
            Object object = BuiltInRegistries.BLOCK.get((ResourceLocation)stack.get(FarmingDataComponents.POLLEN_BLOCK_COMPONENT));
            if (object instanceof ProductiveCropBlock) {
                ProductiveCropBlock cropBlock = (ProductiveCropBlock)object;
                return cropBlock.getCropConfig().getCropColor();
            }
            if (FarmUtil.VANILLA_FLOWER_COLORS.containsKey(stack.get(FarmingDataComponents.POLLEN_BLOCK_COMPONENT))) {
                return FarmUtil.VANILLA_FLOWER_COLORS.get(stack.get(FarmingDataComponents.POLLEN_BLOCK_COMPONENT));
            }
        }
        return FoliageColor.getDefaultColor();
    }
}

