/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivefarming.common.item;

import cy.jdkdigital.productivefarming.registry.FarmingDataComponents;
import cy.jdkdigital.productivefarming.registry.ModTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class CornPipeItem
extends Item {
    public CornPipeItem(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.EAT;
    }

    public boolean isEnchantable(ItemStack stack) {
        return super.isEnchantable(stack);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        boolean isStuffed;
        ItemStack itemStack = player.getItemInHand(hand);
        boolean hasTobacco = player.getItemInHand(InteractionHand.OFF_HAND).is(ModTags.Items.DRIED_TOBACCO);
        boolean hasLighter = player.getItemInHand(InteractionHand.OFF_HAND).is(Items.FLINT_AND_STEEL);
        boolean bl = isStuffed = (Integer)itemStack.getOrDefault(FarmingDataComponents.CHARGES, (Object)16) > 0;
        if (isStuffed && ((Boolean)itemStack.getOrDefault(FarmingDataComponents.IS_LIT, (Object)false)).booleanValue()) {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                itemStack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
                int charges = (Integer)itemStack.getOrDefault(FarmingDataComponents.CHARGES, (Object)32);
                if (charges == 1) {
                    itemStack.set(FarmingDataComponents.IS_LIT, (Object)false);
                }
                itemStack.set(FarmingDataComponents.CHARGES, (Object)(charges - 1));
                serverPlayer.awardStat(Stats.ITEM_USED.get((Object)itemStack.getItem()));
            } else {
                BlockPos pos = player.blockPosition().relative(Direction.UP);
                for (int i = 0; i < 5; ++i) {
                    level.addParticle((ParticleOptions)(level.random.nextBoolean() ? ParticleTypes.CAMPFIRE_SIGNAL_SMOKE : ParticleTypes.CAMPFIRE_COSY_SMOKE), (double)pos.getX() + 0.5 + level.random.nextDouble() / 4.0 * (double)(level.random.nextBoolean() ? 1 : -1) + player.getLookAngle().x, (double)pos.getY() + 0.4, (double)pos.getZ() + 0.5 + level.random.nextDouble() / 4.0 * (double)(level.random.nextBoolean() ? 1 : -1) + player.getLookAngle().z, (double)((float)(level.random.nextBoolean() ? 1 : -1) * (float)level.random.nextInt(0, 4) / 100.0f), (double)((float)level.random.nextInt(1, 7) / 100.0f), (double)((float)(level.random.nextBoolean() ? 1 : -1) * (float)level.random.nextInt(0, 4) / 100.0f));
                }
            }
            return InteractionResultHolder.sidedSuccess((Object)itemStack, (boolean)level.isClientSide());
        }
        if (hasLighter && isStuffed) {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                itemStack.set(FarmingDataComponents.IS_LIT, (Object)true);
                itemStack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)InteractionHand.OFF_HAND));
            } else {
                BlockPos pos = player.blockPosition().relative(Direction.UP);
                level.addParticle((ParticleOptions)ParticleTypes.LAVA, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, (double)(level.random.nextFloat() / 2.0f), 5.0E-5, (double)(level.random.nextFloat() / 2.0f));
                level.playSound(player, pos, SoundEvents.FLINTANDSTEEL_USE, SoundSource.BLOCKS, 1.0f, level.getRandom().nextFloat() * 0.4f + 0.8f);
            }
            return InteractionResultHolder.sidedSuccess((Object)itemStack, (boolean)level.isClientSide());
        }
        if (hasTobacco && !isStuffed) {
            player.startUsingItem(hand);
            return InteractionResultHolder.consume((Object)itemStack);
        }
        return InteractionResultHolder.fail((Object)itemStack);
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 60;
    }

    @NotNull
    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity livingEntity) {
        boolean hasTobacco = livingEntity.getItemInHand(InteractionHand.OFF_HAND).is(ModTags.Items.DRIED_TOBACCO);
        if (hasTobacco) {
            stack.set(FarmingDataComponents.CHARGES, (Object)32);
            if (!livingEntity.hasInfiniteMaterials()) {
                livingEntity.getItemInHand(InteractionHand.OFF_HAND).shrink(1);
            }
        }
        return super.finishUsingItem(stack, level, livingEntity);
    }
}

