/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivefarming.common.feature;

import com.mojang.serialization.Codec;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.CountConfiguration;

public class SeaFloorFeature
extends Feature<CountConfiguration> {
    private final Supplier<Block> blockSupplier;

    public SeaFloorFeature(Codec<CountConfiguration> codec, Supplier<Block> blockSupplier) {
        super(codec);
        this.blockSupplier = blockSupplier;
    }

    public boolean place(FeaturePlaceContext<CountConfiguration> pContext) {
        int i = 0;
        RandomSource randomsource = pContext.random();
        WorldGenLevel worldgenlevel = pContext.level();
        BlockPos blockpos = pContext.origin();
        int j = ((CountConfiguration)pContext.config()).count().sample(randomsource);
        for (int k = 0; k < j; ++k) {
            int l = randomsource.nextInt(8) - randomsource.nextInt(8);
            int i1 = randomsource.nextInt(8) - randomsource.nextInt(8);
            int j1 = worldgenlevel.getHeight(Heightmap.Types.OCEAN_FLOOR, blockpos.getX() + l, blockpos.getZ() + i1);
            BlockPos blockpos1 = new BlockPos(blockpos.getX() + l, j1, blockpos.getZ() + i1);
            BlockState blockstate = (BlockState)this.blockSupplier.get().defaultBlockState().setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(true));
            if (!worldgenlevel.getBlockState(blockpos1).is(Blocks.WATER) || !blockstate.canSurvive((LevelReader)worldgenlevel, blockpos1)) continue;
            worldgenlevel.setBlock(blockpos1, blockstate, 2);
            ++i;
        }
        return i > 0;
    }
}

