/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivefarming.common.entity;

import com.mojang.serialization.Codec;
import cy.jdkdigital.productivefarming.common.entity.ProductiveFish;
import cy.jdkdigital.productivefarming.registry.ModTags;
import java.util.Arrays;
import java.util.function.IntFunction;
import net.minecraft.Util;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.PathType;
import net.neoforged.neoforge.fluids.FluidType;
import org.jetbrains.annotations.Nullable;

public class Crab
extends Animal
implements VariantHolder<Variant>,
ProductiveFish {
    private static final EntityDataAccessor<Integer> DATA_VARIANT = SynchedEntityData.defineId(Crab.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> FROM_BUCKET = SynchedEntityData.defineId(Crab.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);

    public Crab(EntityType<? extends Animal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.setPathfindingMalus(PathType.WATER, 0.0f);
    }

    @Override
    public String getFishName() {
        return "crab";
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_VARIANT, (Object)0);
        builder.define(FROM_BUCKET, (Object)false);
    }

    public boolean fromBucket() {
        return (Boolean)this.entityData.get(FROM_BUCKET);
    }

    public void setFromBucket(boolean pFromBucket) {
        this.entityData.set(FROM_BUCKET, (Object)pFromBucket);
    }

    public void saveToBucketTag(ItemStack stack) {
        Bucketable.saveDefaultDataToBucketTag((Mob)this, (ItemStack)stack);
        CustomData.update((DataComponentType)DataComponents.BUCKET_ENTITY_DATA, (ItemStack)stack, tag -> {
            tag.putInt("Variant", this.getVariant().getId());
            tag.putInt("Age", this.getAge());
            Brain brain = this.getBrain();
            if (brain.hasMemoryValue(MemoryModuleType.HAS_HUNTING_COOLDOWN)) {
                tag.putLong("HuntingCooldown", brain.getTimeUntilExpiry(MemoryModuleType.HAS_HUNTING_COOLDOWN));
            }
        });
    }

    public void loadFromBucketTag(CompoundTag tag) {
        Bucketable.loadDefaultDataFromBucketTag((Mob)this, (CompoundTag)tag);
        this.setVariant(Variant.byId(tag.getInt("Variant")));
        if (tag.contains("Age")) {
            this.setAge(tag.getInt("Age"));
        }
        if (tag.contains("HuntingCooldown")) {
            this.getBrain().setMemoryWithExpiry(MemoryModuleType.HAS_HUNTING_COOLDOWN, (Object)true, tag.getLong("HuntingCooldown"));
        }
    }

    public ItemStack getBucketItemStack() {
        return this.getBucket();
    }

    public SoundEvent getPickupSound() {
        return SoundEvents.BUCKET_FILL_AXOLOTL;
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel pLevel, AgeableMob pOtherParent) {
        Entity entity = this.getType().create((Level)pLevel);
        if (entity instanceof Crab) {
            Crab crab = (Crab)entity;
            Variant variant = this.random.nextInt(1200) == 0 ? Variant.getRareSpawnVariant(this.random) : (this.random.nextBoolean() ? this.getVariant() : ((Crab)pOtherParent).getVariant());
            crab.setVariant(variant);
            crab.setPersistenceRequired();
            return crab;
        }
        return null;
    }

    public boolean canDrownInFluidType(FluidType type) {
        return false;
    }

    public void setVariant(Variant pVariant) {
        this.entityData.set(DATA_VARIANT, (Object)pVariant.getId());
    }

    public Variant getVariant() {
        return Variant.byId((Integer)this.entityData.get(DATA_VARIANT));
    }

    public void addAdditionalSaveData(CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
        pCompound.putInt("Variant", this.getVariant().getId());
        pCompound.putBoolean("FromBucket", this.fromBucket());
    }

    public void readAdditionalSaveData(CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
        this.setVariant(Variant.byId(pCompound.getInt("Variant")));
        this.setFromBucket(pCompound.getBoolean("FromBucket"));
    }

    public boolean isFood(ItemStack stack) {
        return stack.is(ModTags.Items.CRAB_FOOD);
    }

    public static enum Variant implements StringRepresentable
    {
        BLUE(0, "blue", true),
        BROWN(1, "brown", true),
        GOLD(2, "gold", false);

        private static final IntFunction<Variant> BY_ID;
        public static final Codec<Variant> CODEC;
        private final int id;
        private final String name;
        private final boolean common;

        private Variant(int pId, String pName, boolean pCommon) {
            this.id = pId;
            this.name = pName;
            this.common = pCommon;
        }

        public int getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String getSerializedName() {
            return this.name;
        }

        public static Variant byId(int id) {
            return BY_ID.apply(id);
        }

        public static Variant getCommonSpawnVariant(RandomSource pRandom) {
            return Variant.getSpawnVariant(pRandom, true);
        }

        public static Variant getRareSpawnVariant(RandomSource pRandom) {
            return Variant.getSpawnVariant(pRandom, false);
        }

        private static Variant getSpawnVariant(RandomSource pRandom, boolean pCommon) {
            Variant[] variants = (Variant[])Arrays.stream(Variant.values()).filter(variant -> variant.common == pCommon).toArray(Variant[]::new);
            return (Variant)((Object)Util.getRandom((Object[])variants, (RandomSource)pRandom));
        }

        static {
            BY_ID = ByIdMap.continuous(Variant::getId, (Object[])Variant.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO);
            CODEC = StringRepresentable.fromEnum(Variant::values);
        }
    }
}

