/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivefarming.common.block.entity;

import cy.jdkdigital.productivefarming.Config;
import cy.jdkdigital.productivefarming.common.block.entity.TickingBlockEntity;
import cy.jdkdigital.productivefarming.registry.FarmingRegistrator;
import cy.jdkdigital.productivelib.common.block.entity.InventoryHandlerHelper;
import cy.jdkdigital.productivelib.common.block.entity.UpgradeableBlockEntity;
import cy.jdkdigital.productivelib.registry.LibItems;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.items.IItemHandlerModifiable;

public class WateringTroughBlockEntity
extends TickingBlockEntity
implements UpgradeableBlockEntity {
    protected FluidTank fluidHandler = new FluidTank(10000, fluidStack -> fluidStack.is(Tags.Fluids.WATER));
    protected IItemHandlerModifiable upgradeHandler = new InventoryHandlerHelper.UpgradeHandler(4, (BlockEntity)this, List.of((Item)LibItems.UPGRADE_RANGE.get(), (Item)LibItems.UPGRADE_TIME.get()));

    public WateringTroughBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)FarmingRegistrator.WATERING_TROUGH_BLOCK_ENTITY.get(), pos, state);
    }

    public FluidTank getFluidHandler() {
        return this.fluidHandler;
    }

    public IItemHandlerModifiable getUpgradeHandler() {
        return this.upgradeHandler;
    }

    @Override
    int tickRate() {
        int speed = (Integer)Config.SERVER.wateringTroughTickRate.get();
        int speedUpgrades = this.getUpgradeCount((Item)LibItems.UPGRADE_TIME.get());
        return speed - speed / 20 * speedUpgrades;
    }

    @Override
    public void tickServer(ServerLevel level, BlockPos blockPos, BlockState blockState, TickingBlockEntity blockEntity) {
        double range;
        List<Animal> entities;
        WateringTroughBlockEntity wateringTroughBlockEntity;
        if (blockEntity instanceof WateringTroughBlockEntity && (wateringTroughBlockEntity = (WateringTroughBlockEntity)blockEntity).getFluidHandler().getFluidAmount() > 100 && !(entities = level.getEntitiesOfClass(Animal.class, new AABB(blockPos).inflate(range = 4.0 + (double)this.getUpgradeCount((Item)LibItems.UPGRADE_RANGE.get()), range - 3.0, range)).stream().filter(animal -> !animal.isBaby() && animal.getAge() > 0).toList()).isEmpty()) {
            entities.forEach(animal -> {
                if (wateringTroughBlockEntity.getFluidHandler().getFluidAmount() > 100) {
                    animal.setAge(Math.max(animal.getAge() - 200, 0));
                    wateringTroughBlockEntity.getFluidHandler().drain(100, IFluidHandler.FluidAction.EXECUTE);
                }
            });
        }
    }
}

