/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivefarming.common.block.entity;

import cy.jdkdigital.productivelib.common.block.entity.CapabilityBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public abstract class TickingBlockEntity
extends CapabilityBlockEntity {
    int tickCounter = 0;

    public TickingBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    abstract int tickRate();

    public void tickClient(Level level, BlockPos blockPos, BlockState blockState, TickingBlockEntity blockEntity) {
    }

    public void tickServer(ServerLevel level, BlockPos blockPos, BlockState blockState, TickingBlockEntity blockEntity) {
    }

    boolean shouldTick() {
        return this.tickCounter % this.tickRate() == 0;
    }

    public void tickHandler(Level level, BlockPos blockPos, BlockState blockState, TickingBlockEntity blockEntity) {
        ++this.tickCounter;
        if (this.shouldTick()) {
            this.tickCounter = 0;
            if (level.isClientSide) {
                this.tickClient(level, blockPos, blockState, blockEntity);
            } else {
                this.tickServer((ServerLevel)level, blockPos, blockState, blockEntity);
            }
        }
    }

    public static void tick(Level level, BlockPos blockPos, BlockState blockState, TickingBlockEntity blockEntity) {
        blockEntity.tickHandler(level, blockPos, blockState, blockEntity);
    }

    public void savePacketNBT(CompoundTag tag, HolderLookup.Provider provider) {
        super.savePacketNBT(tag, provider);
        tag.putInt("tickCounter", this.tickCounter);
    }

    public void loadPacketNBT(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadPacketNBT(tag, provider);
        if (tag.contains("tickCounter")) {
            this.tickCounter = tag.getInt("tickCounter");
        }
    }
}

