/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivefarming.common.block.entity;

import cy.jdkdigital.productivefarming.common.block.entity.CropBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public abstract class FencedCropBlockEntity
extends CropBlockEntity {
    private BlockState fence;

    public FencedCropBlockEntity(BlockEntityType<?> blockEntityType, BlockPos blockPos, BlockState blockState) {
        super(blockEntityType, blockPos, blockState);
    }

    public BlockState getFence() {
        return this.fence;
    }

    public void setFence(BlockState fence) {
        this.fence = fence;
        this.setChanged();
    }

    @Override
    public void loadPacketNBT(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadPacketNBT(tag, provider);
        if (tag.contains("fence")) {
            BlockState fence = ((Block)BuiltInRegistries.BLOCK.get(ResourceLocation.parse((String)tag.getString("fence")))).defaultBlockState();
            fence = (BlockState)((BlockState)((BlockState)((BlockState)fence.setValue((Property)FenceBlock.NORTH, (Comparable)Boolean.valueOf(tag.getBoolean("north")))).setValue((Property)FenceBlock.SOUTH, (Comparable)Boolean.valueOf(tag.getBoolean("south")))).setValue((Property)FenceBlock.EAST, (Comparable)Boolean.valueOf(tag.getBoolean("east")))).setValue((Property)FenceBlock.WEST, (Comparable)Boolean.valueOf(tag.getBoolean("west")));
            this.setFence(fence);
        }
    }

    @Override
    public void savePacketNBT(CompoundTag tag, HolderLookup.Provider provider) {
        super.savePacketNBT(tag, provider);
        if (this.fence != null) {
            tag.putString("fence", BuiltInRegistries.BLOCK.getKey((Object)this.fence.getBlock()).toString());
            tag.putBoolean("north", ((Boolean)this.fence.getValue((Property)FenceBlock.NORTH)).booleanValue());
            tag.putBoolean("south", ((Boolean)this.fence.getValue((Property)FenceBlock.SOUTH)).booleanValue());
            tag.putBoolean("east", ((Boolean)this.fence.getValue((Property)FenceBlock.EAST)).booleanValue());
            tag.putBoolean("west", ((Boolean)this.fence.getValue((Property)FenceBlock.WEST)).booleanValue());
        }
    }
}

