/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivefarming.common.block.entity;

import com.mojang.authlib.GameProfile;
import cy.jdkdigital.productivefarming.Config;
import cy.jdkdigital.productivefarming.common.block.FeedingTroughBlock;
import cy.jdkdigital.productivefarming.common.block.entity.TickingBlockEntity;
import cy.jdkdigital.productivefarming.inventory.FeedingTroughContainer;
import cy.jdkdigital.productivefarming.registry.FarmingRegistrator;
import cy.jdkdigital.productivelib.common.block.entity.InventoryHandlerHelper;
import cy.jdkdigital.productivelib.common.block.entity.UpgradeableBlockEntity;
import cy.jdkdigital.productivelib.registry.LibItems;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.common.util.FakePlayerFactory;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FeedingTroughBlockEntity
extends TickingBlockEntity
implements MenuProvider,
UpgradeableBlockEntity {
    static final UUID PLAYER_UUID = UUID.nameUUIDFromBytes("feeding_trough".getBytes(StandardCharsets.UTF_8));
    protected final IItemHandlerModifiable inventoryHandler = new InventoryHandlerHelper.BlockEntityItemStackHandler(this, 9, (BlockEntity)this){

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return true;
        }

        public boolean isInsertableSlot(int slot) {
            return true;
        }

        public boolean isInputSlotItem(int slot, ItemStack item) {
            return true;
        }

        public int[] getOutputSlots() {
            return new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8};
        }

        protected void onContentsChanged(int slot) {
            Level level;
            int level2;
            super.onContentsChanged(slot);
            int itemCount = 0;
            for (int i = 0; i < this.getSlots(); ++i) {
                ItemStack stack = this.getStackInSlot(i);
                if (stack.isEmpty()) continue;
                itemCount += stack.getCount();
            }
            int n = itemCount >= 160 ? 2 : (level2 = itemCount > 0 ? 1 : 0);
            if (this.blockEntity.getBlockState().hasProperty((Property)FeedingTroughBlock.LEVEL) && (level = this.blockEntity.getLevel()) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                Integer currentLevel = (Integer)this.blockEntity.getBlockState().getValue((Property)FeedingTroughBlock.LEVEL);
                if (currentLevel != level2) {
                    serverLevel.setBlockAndUpdate(this.blockEntity.getBlockPos(), (BlockState)this.blockEntity.getBlockState().setValue((Property)FeedingTroughBlock.LEVEL, (Comparable)Integer.valueOf(level2)));
                }
            }
        }
    };
    protected IItemHandlerModifiable upgradeHandler = new InventoryHandlerHelper.UpgradeHandler(4, (BlockEntity)this, List.of((Item)LibItems.UPGRADE_RANGE.get(), (Item)LibItems.UPGRADE_CHILD.get(), (Item)LibItems.UPGRADE_TIME.get()));

    public FeedingTroughBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)FarmingRegistrator.FEEDING_TROUGH_BLOCK_ENTITY.get(), pos, state);
    }

    public IItemHandler getItemHandler() {
        return this.inventoryHandler;
    }

    public IItemHandlerModifiable getUpgradeHandler() {
        return this.upgradeHandler;
    }

    @Override
    int tickRate() {
        int speed = (Integer)Config.SERVER.feedingTroughTickRate.get();
        int speedUpgrades = this.getUpgradeCount((Item)LibItems.UPGRADE_TIME.get());
        return speed - speed / 20 * speedUpgrades;
    }

    @Override
    public void tickServer(ServerLevel level, BlockPos blockPos, BlockState blockState, TickingBlockEntity blockEntity) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (int i = 0; i < this.inventoryHandler.getSlots(); ++i) {
            ItemStack stack = this.inventoryHandler.getStackInSlot(i);
            if (stack.isEmpty()) continue;
            stacks.add(stack);
        }
        if (!stacks.isEmpty()) {
            double range = 4.0 + (double)this.getUpgradeCount((Item)LibItems.UPGRADE_RANGE.get());
            boolean hasChildUpgrade = this.getUpgradeCount((Item)LibItems.UPGRADE_CHILD.get()) > 0;
            List entities = level.getEntitiesOfClass(Animal.class, new AABB(blockPos).inflate(range, range - 3.0, range)).stream().toList();
            if (!entities.isEmpty()) {
                FakePlayer fakePlayer = FakePlayerFactory.get((ServerLevel)level, (GameProfile)new GameProfile(PLAYER_UUID, "feeding_trough"));
                entities.forEach(arg_0 -> FeedingTroughBlockEntity.lambda$tickServer$0(stacks, hasChildUpgrade, (Player)fakePlayer, arg_0));
            }
        }
    }

    @Nullable
    public AbstractContainerMenu createMenu(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return new FeedingTroughContainer(pContainerId, pPlayerInventory, this);
    }

    private static /* synthetic */ void lambda$tickServer$0(List stacks, boolean hasChildUpgrade, Player fakePlayer, Animal animal) {
        for (ItemStack stack : stacks) {
            if (stack.isEmpty() || !animal.isFood(stack) || !hasChildUpgrade && animal.isBaby()) continue;
            fakePlayer.setItemInHand(InteractionHand.MAIN_HAND, stack);
            if (!animal.mobInteract(fakePlayer, InteractionHand.MAIN_HAND).equals((Object)InteractionResult.SUCCESS)) continue;
            break;
        }
    }
}

