/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivefarming.common.block.entity;

import cy.jdkdigital.productivefarming.Config;
import cy.jdkdigital.productivefarming.common.block.entity.TickingBlockEntity;
import cy.jdkdigital.productivefarming.inventory.FarmControllerContainer;
import cy.jdkdigital.productivefarming.registry.FarmingRegistrator;
import cy.jdkdigital.productivefarming.registry.ModTags;
import cy.jdkdigital.productivelib.common.block.entity.IMultiBlockControllerBlockEntity;
import cy.jdkdigital.productivelib.common.block.entity.IUpgradeableBlockEntity;
import cy.jdkdigital.productivelib.common.block.entity.InventoryHandlerHelper;
import cy.jdkdigital.productivelib.registry.LibItems;
import cy.jdkdigital.productivelib.util.MultiBlockDetector;
import cy.jdkdigital.productivelib.util.harvest.HarvestCompatHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FarmControllerBlockEntity
extends TickingBlockEntity
implements IMultiBlockControllerBlockEntity,
IUpgradeableBlockEntity,
MenuProvider {
    private MultiBlockDetector.MultiBlockData farmConfig;
    public final IItemHandlerModifiable inventoryHandler = new InventoryHandlerHelper.BlockEntityItemStackHandler(this, 27, (BlockEntity)this){

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return true;
        }

        public boolean isInsertableSlot(int slot) {
            return true;
        }

        public boolean isInputSlot(int slot) {
            return false;
        }

        public int[] getOutputSlots() {
            return new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26};
        }
    };
    private final IFluidHandler fluidHandler = new FluidTank(10000, fluidStack -> fluidStack.getFluid().isSame((Fluid)FarmingRegistrator.NUTRIENT_WATER.get()));
    protected IItemHandlerModifiable upgradeHandler = new InventoryHandlerHelper.UpgradeHandler(4, (BlockEntity)this, List.of((Item)LibItems.UPGRADE_TIME.get(), (Item)LibItems.UPGRADE_TIME_2.get(), (Item)LibItems.UPGRADE_STABILITY.get()));

    public FarmControllerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)FarmingRegistrator.FARM_CONTROLLER_BLOCK_ENTITY.get(), pos, state);
    }

    public Component getName() {
        return Component.translatable((String)this.getBlockState().getBlock().getDescriptionId());
    }

    @Nullable
    public AbstractContainerMenu createMenu(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return new FarmControllerContainer(pContainerId, pPlayerInventory, this);
    }

    @Override
    int tickRate() {
        return 300;
    }

    @Override
    public void tickServer(ServerLevel level, BlockPos blockPos, BlockState blockState, TickingBlockEntity blockEntity) {
        if (blockEntity instanceof FarmControllerBlockEntity) {
            FarmControllerBlockEntity farmControllerBlockEntity = (FarmControllerBlockEntity)blockEntity;
            boolean canHarvest = false;
            for (int slot = 0; slot < farmControllerBlockEntity.getItemHandler().getSlots(); ++slot) {
                if (!farmControllerBlockEntity.getItemHandler().getStackInSlot(slot).isEmpty()) continue;
                canHarvest = true;
            }
            if (canHarvest) {
                MultiBlockDetector.MultiBlockData farmConfig = farmControllerBlockEntity.farmConfig;
                ArrayList cropPositions = BlockPos.betweenClosedStream((BlockPos)((BlockPos)farmConfig.topCorners().getFirst()), (BlockPos)((BlockPos)farmConfig.topCorners().getSecond())).map(BlockPos::above).collect(Collectors.toCollection(ArrayList::new));
                if (farmConfig.height() > 1) {
                    farmControllerBlockEntity.processFishFarm(cropPositions);
                }
                this.processCropFarm(cropPositions);
                List lootStacks = level.getEntitiesOfClass(ItemEntity.class, new AABB(((BlockPos)farmConfig.topCorners().getFirst()).above(3).getCenter(), ((BlockPos)farmConfig.topCorners().getSecond()).below(farmConfig.height() + 1).getBottomCenter())).stream().toList();
                lootStacks.forEach(itemEntity -> {
                    InventoryHandlerHelper.BlockEntityItemStackHandler handler;
                    IItemHandlerModifiable patt0$temp = this.inventoryHandler;
                    if (patt0$temp instanceof InventoryHandlerHelper.BlockEntityItemStackHandler && (handler = (InventoryHandlerHelper.BlockEntityItemStackHandler)patt0$temp).addOutput(itemEntity.getItem()).isEmpty()) {
                        itemEntity.kill();
                    }
                });
            }
        }
    }

    public static <E extends BlockEntity> void tick(Level level, BlockPos blockPos, BlockState blockState, FarmControllerBlockEntity blockEntity) {
        if (blockEntity.farmConfig != null) {
            blockEntity.tickHandler(level, blockPos, blockState, blockEntity);
        }
    }

    public IItemHandler getItemHandler() {
        return this.inventoryHandler;
    }

    public IFluidHandler getFluidHandler() {
        return this.fluidHandler;
    }

    public IItemHandlerModifiable getUpgradeHandler() {
        return null;
    }

    @Override
    public void savePacketNBT(CompoundTag tag, HolderLookup.Provider provider) {
        super.savePacketNBT(tag, provider);
        if (this.getMultiblockData() != null) {
            tag.put("multiData", this.getMultiblockData().serializeNBT(provider));
        }
    }

    @Override
    public void loadPacketNBT(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadPacketNBT(tag, provider);
        if (tag.contains("multiData")) {
            MultiBlockDetector.MultiBlockData data = new MultiBlockDetector.MultiBlockData(null, null, List.of(), 0, 0);
            data.deserializeNBT(provider, Objects.requireNonNull(tag.get("multiData")));
            this.setMultiBlockData(data);
        }
    }

    private void processFishFarm(List<BlockPos> cropPositions) {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            List<LivingEntity> entities = serverLevel.getEntitiesOfClass(LivingEntity.class, new AABB(((BlockPos)this.farmConfig.topCorners().getFirst()).below(this.farmConfig.height()).getCenter(), ((BlockPos)this.farmConfig.topCorners().getSecond()).getCenter())).stream().filter(e -> e.getType().is(ModTags.FISH_FARM_ENTITIES) || e instanceof AbstractFish).toList();
            if (entities.size() > 1) {
                HashMap entityCount = new HashMap();
                entities.forEach(livingEntity -> {
                    EntityType type = livingEntity.getType();
                    if (entityCount.containsKey(type)) {
                        entityCount.put(type, (Integer)entityCount.get(type) + 1);
                    } else {
                        entityCount.put(type, 1);
                    }
                });
                LinkedList list = new LinkedList(entityCount.entrySet());
                list.sort(Comparator.comparingInt(Map.Entry::getValue));
                int maxAllowedEntities = cropPositions.size() / 2;
                if (maxAllowedEntities < entities.size()) {
                    AtomicInteger toKill = new AtomicInteger(entities.size() - maxAllowedEntities);
                    entities.forEach(entity -> {
                        if (toKill.getAndDecrement() >= 0 && (Integer)entityCount.get(entity.getType()) > 2) {
                            entity.kill();
                            entityCount.put(entity.getType(), (Integer)entityCount.get(entity.getType()) - 1);
                        }
                    });
                }
                BlockPos middle = new BlockPos((((BlockPos)this.farmConfig.topCorners().getFirst()).getX() + ((BlockPos)this.farmConfig.topCorners().getSecond()).getX()) / 2, ((BlockPos)this.farmConfig.topCorners().getFirst()).getY() - 1, (((BlockPos)this.farmConfig.topCorners().getFirst()).getZ() + ((BlockPos)this.farmConfig.topCorners().getSecond()).getZ()) / 2);
                ArrayList arrayList = new ArrayList();
                entities.forEach(livingEntity -> {
                    Integer count = (Integer)entityCount.get(livingEntity.getType());
                    if (count >= 2 && !bredSpecies.contains(livingEntity.getType())) {
                        bredSpecies.add(livingEntity.getType());
                        int newBreeds = serverLevel.random.nextInt(count / 2);
                        for (int i = 0; i < newBreeds; ++i) {
                            if (!serverLevel.random.nextBoolean()) continue;
                            if (livingEntity instanceof Animal) {
                                Animal animal = (Animal)livingEntity;
                                AgeableMob offSpring = animal.getBreedOffspring(serverLevel, (AgeableMob)animal);
                                if (offSpring == null) continue;
                                offSpring.setPos((double)middle.getX(), (double)middle.getY(), (double)middle.getZ());
                                serverLevel.addFreshEntity((Entity)offSpring);
                                continue;
                            }
                            livingEntity.getType().spawn(serverLevel, middle.relative(Direction.fromYRot((double)serverLevel.random.nextInt(360))), MobSpawnType.BREEDING);
                        }
                    }
                });
            }
            HashMap<BlockPos, BlockState> clamMap = new HashMap<BlockPos, BlockState>();
            for (BlockPos pos : BlockPos.betweenClosed((BlockPos)((BlockPos)this.farmConfig.topCorners().getFirst()), (BlockPos)((BlockPos)this.farmConfig.topCorners().getSecond()))) {
                BlockState state = serverLevel.getBlockState(pos);
                if (!state.is(ModTags.Blocks.FARMABLE_FISH_BLOCKS)) continue;
                clamMap.put(new BlockPos((Vec3i)pos), state);
            }
            float clamChance = (float)Config.SERVER.clamSpreadChance.getAsDouble();
            List<Direction> directions = Arrays.asList(Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST);
            for (Map.Entry entry : clamMap.entrySet()) {
                BlockState state = (BlockState)entry.getValue();
                if (!(serverLevel.random.nextFloat() < clamChance)) continue;
                boolean hasPropagated = false;
                Collections.shuffle(directions);
                for (Direction dir : directions) {
                    BlockState neighborState;
                    if (hasPropagated || !(neighborState = serverLevel.getBlockState(((BlockPos)entry.getKey()).relative(dir))).getFluidState().is(FluidTags.WATER) || !serverLevel.random.nextBoolean()) continue;
                    serverLevel.setBlockAndUpdate(((BlockPos)entry.getKey()).relative(dir), (BlockState)state.getBlock().defaultBlockState().setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(true)));
                    hasPropagated = true;
                }
                if (!hasPropagated || !serverLevel.random.nextBoolean()) continue;
                serverLevel.destroyBlock((BlockPos)entry.getKey(), true);
            }
            int sludge = Math.max(entities.size() * 50 - clamMap.size() * 5, 0);
            this.fluidHandler.fill(new FluidStack((Fluid)FarmingRegistrator.NUTRIENT_WATER.get(), sludge), IFluidHandler.FluidAction.EXECUTE);
        }
    }

    private void processCropFarm(List<BlockPos> cropPositions) {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Collections.shuffle(cropPositions);
            cropPositions.forEach(p -> {
                for (BlockPos pos : new BlockPos[]{p, p.above()}) {
                    BlockState state;
                    Block patt0$temp;
                    HarvestCompatHandler.harvestBlock((Level)serverLevel, (BlockPos)pos);
                    if (this.fluidHandler.getFluidInTank(0).getAmount() < 100 || !((patt0$temp = (state = serverLevel.getBlockState(pos)).getBlock()) instanceof BonemealableBlock)) continue;
                    BonemealableBlock bonemealableBlock = (BonemealableBlock)patt0$temp;
                    bonemealableBlock.performBonemeal(serverLevel, serverLevel.random, pos, state);
                    this.fluidHandler.drain(100, IFluidHandler.FluidAction.EXECUTE);
                    this.level.levelEvent(1505, pos, 15);
                }
            });
        }
    }

    public void setMultiBlockData(MultiBlockDetector.MultiBlockData multiBlockData) {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.farmConfig != multiBlockData || multiBlockData != null) {
                this.sync((Level)serverLevel);
            }
        }
        this.farmConfig = multiBlockData;
        this.setChanged();
    }

    public MultiBlockDetector.MultiBlockData getMultiblockData() {
        return this.farmConfig;
    }

    public void sync(Level level) {
        level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 2);
        this.invalidateCapabilities();
    }
}

