/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivefarming.common.block.entity;

import cy.jdkdigital.productivefarming.common.block.DoubleCropBlock;
import cy.jdkdigital.productivefarming.common.item.PollenItem;
import cy.jdkdigital.productivefarming.registry.FarmingDataComponents;
import cy.jdkdigital.productivefarming.util.TraitsHelper;
import cy.jdkdigital.productivelib.common.block.entity.AbstractBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;

public abstract class CropBlockEntity
extends AbstractBlockEntity {
    private ResourceLocation mutation;
    private int growth;
    private int yield;
    private int resistance;
    private int mutability;

    public CropBlockEntity(BlockEntityType<?> blockEntityType, BlockPos blockPos, BlockState blockState) {
        super(blockEntityType, blockPos, blockState);
    }

    public ResourceLocation getMutation() {
        return this.mutation;
    }

    public void setMutation(ResourceLocation mutation) {
        this.setMutation(mutation, false);
    }

    public void setMutation(ResourceLocation mutation, boolean isFromLoop) {
        this.mutation = mutation;
        this.setChanged();
        if (this.level != null) {
            CropBlockEntity otherCropBlockEntity;
            BlockEntity otherHalf;
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 2);
            if (!isFromLoop && this.getBlockState().getBlock() instanceof DoubleCropBlock && (otherHalf = this.level.getBlockEntity(this.getBlockPos().relative(((DoubleBlockHalf)this.getBlockState().getValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF)).equals((Object)DoubleBlockHalf.LOWER) ? Direction.UP : Direction.DOWN))) instanceof CropBlockEntity && !(otherCropBlockEntity = (CropBlockEntity)otherHalf).hasMutation()) {
                otherCropBlockEntity.setMutation(mutation, true);
            }
        }
    }

    public int getGrowth() {
        return this.growth;
    }

    public void setGrowth(int growth) {
        this.growth = Math.min(growth, TraitsHelper.getMaxValue("growth"));
    }

    public int getYield() {
        return this.yield;
    }

    public void setYield(int yield) {
        this.yield = Math.min(yield, TraitsHelper.getMaxValue("yield"));
    }

    public int getResistance() {
        return this.resistance;
    }

    public void setResistance(int resistance) {
        this.resistance = Math.min(resistance, TraitsHelper.getMaxValue("resistance"));
    }

    public int getMutability() {
        return this.mutability;
    }

    public void setMutability(int mutability) {
        this.mutability = Math.min(mutability, TraitsHelper.getMaxValue("mutability"));
    }

    public boolean hasMutation() {
        return this.mutation != null;
    }

    public int getMutationColor() {
        if (this.hasMutation()) {
            return PollenItem.getColor(((Item)BuiltInRegistries.ITEM.get(this.mutation)).getDefaultInstance());
        }
        return -1;
    }

    public void loadPacketNBT(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadPacketNBT(tag, provider);
        if (tag.contains("mutation")) {
            this.mutation = ResourceLocation.parse((String)tag.getString("mutation"));
        }
        this.setGrowth(tag.contains("growth") ? tag.getInt("growth") : 0);
        this.setYield(tag.contains("yield") ? tag.getInt("yield") : 0);
        this.setResistance(tag.contains("resistance") ? tag.getInt("resistance") : 0);
        this.setMutability(tag.contains("mutability") ? tag.getInt("mutability") : 0);
    }

    public void savePacketNBT(CompoundTag tag, HolderLookup.Provider provider) {
        super.savePacketNBT(tag, provider);
        if (this.hasMutation()) {
            tag.putString("mutation", this.mutation.toString());
        }
        tag.putInt("growth", this.growth);
        tag.putInt("yield", this.yield);
        tag.putInt("resistance", this.resistance);
        tag.putInt("mutability", this.mutability);
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput componentInput) {
        super.applyImplicitComponents(componentInput);
        this.setGrowth((Integer)componentInput.getOrDefault(FarmingDataComponents.GROWTH, (Object)0));
        this.setYield((Integer)componentInput.getOrDefault(FarmingDataComponents.YIELD, (Object)0));
        this.setResistance((Integer)componentInput.getOrDefault(FarmingDataComponents.RESISTANCE, (Object)0));
        this.setMutability((Integer)componentInput.getOrDefault(FarmingDataComponents.MUTABILITY, (Object)0));
    }

    protected void collectImplicitComponents(DataComponentMap.Builder components) {
        super.collectImplicitComponents(components);
        components.set(FarmingDataComponents.GROWTH, (Object)this.getGrowth());
        components.set(FarmingDataComponents.YIELD, (Object)this.getYield());
        components.set(FarmingDataComponents.RESISTANCE, (Object)this.getResistance());
        components.set(FarmingDataComponents.MUTABILITY, (Object)this.getMutability());
    }

    public void copyTraitsFromOtherCrop(CropBlockEntity cropBlockEntity) {
        this.setGrowth(cropBlockEntity.getGrowth());
        this.setYield(cropBlockEntity.getYield());
        this.setResistance(cropBlockEntity.getResistance());
        this.setMutability(cropBlockEntity.getMutability());
    }

    public ItemStack getMutatedSeedStack(ResourceLocation mutation) {
        ItemStack seed = ((Item)BuiltInRegistries.ITEM.get(mutation.withPath(p -> p + "_seeds"))).getDefaultInstance();
        if (seed.is(Items.AIR)) {
            seed = ((Item)BuiltInRegistries.ITEM.get(mutation)).getDefaultInstance();
        }
        return this.applyComponentsToItemStack(seed);
    }

    public ItemStack applyComponentsToItemStack(ItemStack stack) {
        stack.set(FarmingDataComponents.GROWTH, (Object)this.getGrowth());
        stack.set(FarmingDataComponents.YIELD, (Object)this.getYield());
        stack.set(FarmingDataComponents.RESISTANCE, (Object)this.getResistance());
        stack.set(FarmingDataComponents.MUTABILITY, (Object)this.getMutability());
        return stack;
    }
}

