/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivefarming.common.block.entity;

import cy.jdkdigital.productivefarming.registry.FarmingDataComponents;
import cy.jdkdigital.productivefarming.registry.FarmingRegistrator;
import cy.jdkdigital.productivelib.common.block.entity.AbstractBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class ColorfulFlowerBlockEntity
extends AbstractBlockEntity {
    private int color;

    public ColorfulFlowerBlockEntity(BlockPos pos, BlockState state) {
        this(pos, state, 255);
    }

    public ColorfulFlowerBlockEntity(BlockPos pos, BlockState state, int defaultColor) {
        super((BlockEntityType)FarmingRegistrator.FLOWER_BLOCK_ENTITY.get(), pos, state);
        this.setColor(defaultColor);
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int color) {
        this.color = color;
    }

    public void loadPacketNBT(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadPacketNBT(tag, provider);
        if (tag.contains("color")) {
            this.setColor(tag.getInt("color"));
        }
    }

    public void savePacketNBT(CompoundTag tag, HolderLookup.Provider provider) {
        super.savePacketNBT(tag, provider);
        tag.putInt("color", this.color);
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput componentInput) {
        super.applyImplicitComponents(componentInput);
        this.setColor((Integer)componentInput.getOrDefault(FarmingDataComponents.COLOR, (Object)this.color));
    }

    protected void collectImplicitComponents(DataComponentMap.Builder components) {
        super.collectImplicitComponents(components);
        components.set(FarmingDataComponents.COLOR, (Object)this.getColor());
    }
}

