/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivefarming.common.block;

import com.mojang.serialization.MapCodec;
import cy.jdkdigital.productivefarming.common.block.FeedingTroughBlock;
import cy.jdkdigital.productivefarming.common.block.entity.TickingBlockEntity;
import cy.jdkdigital.productivefarming.common.block.entity.WateringTroughBlockEntity;
import cy.jdkdigital.productivefarming.registry.FarmingRegistrator;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.Nullable;

public class WateringTroughBlock
extends FeedingTroughBlock {
    public static final MapCodec<WateringTroughBlock> CODEC = WateringTroughBlock.simpleCodec(WateringTroughBlock::new);

    public WateringTroughBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    @Override
    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @Override
    @Nullable
    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return new WateringTroughBlockEntity(pPos, pState);
    }

    @Override
    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return level.isClientSide ? null : WateringTroughBlock.createTickerHelper(blockEntityType, (BlockEntityType)((BlockEntityType)FarmingRegistrator.WATERING_TROUGH_BLOCK_ENTITY.get()), TickingBlockEntity::tick);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity blockEntity;
        if (stack.is(Items.WATER_BUCKET) && (blockEntity = level.getBlockEntity(pos)) instanceof WateringTroughBlockEntity) {
            WateringTroughBlockEntity wateringTroughBlockEntity = (WateringTroughBlockEntity)blockEntity;
            FluidUtil.tryEmptyContainer((ItemStack)stack, (IFluidHandler)wateringTroughBlockEntity.getFluidHandler(), (int)1000, (Player)player, (boolean)true);
            if (state.hasProperty((Property)LEVEL) && level instanceof ServerLevel) {
                int newLevel;
                ServerLevel serverLevel = (ServerLevel)level;
                int fluidAmount = wateringTroughBlockEntity.getFluidHandler().getFluidAmount();
                Integer currentLevel = (Integer)state.getValue((Property)LEVEL);
                int n = fluidAmount > 5000 ? 2 : (newLevel = fluidAmount > 0 ? 1 : 0);
                if (currentLevel != newLevel) {
                    serverLevel.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)LEVEL, (Comparable)Integer.valueOf(newLevel)));
                }
            }
            return ItemInteractionResult.CONSUME;
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }
}

