/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivefarming.common.block;

import cy.jdkdigital.productivefarming.common.block.FencedPlantLeafBlock;
import cy.jdkdigital.productivefarming.common.block.entity.FencedLeafBlockEntity;
import cy.jdkdigital.productivefarming.util.CropConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.common.Tags;
import org.jetbrains.annotations.Nullable;

public class VineLeafBlock
extends FencedPlantLeafBlock {
    public VineLeafBlock(CropConfig crop, BlockBehaviour.Properties pProperties) {
        super(crop, pProperties);
    }

    @Override
    @Nullable
    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return new FencedLeafBlockEntity(pPos, pState);
    }

    @Override
    Direction[] validGrowthDirections(Level level, BlockPos pos) {
        return new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};
    }

    @Override
    boolean isValidPropagationLeaf(ServerLevel level, BlockPos pos, Direction dir) {
        BlockState attachedState = level.getBlockState(pos);
        boolean requiresSupport = (Integer)attachedState.getValue((Property)BlockStateProperties.DISTANCE) % 2 == 0;
        return level.getBlockState(pos.below()).is(this.stem) || (Integer)attachedState.getValue((Property)BlockStateProperties.DISTANCE) < 4 && (level.getBlockState(pos.relative(dir).below()).is(Tags.Blocks.FENCES) || !requiresSupport);
    }

    @Override
    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockState attachedState = level.getBlockState(pos.relative((Direction)state.getValue((Property)BlockStateProperties.FACING)));
        return VineLeafBlock.hasSufficientLight((LevelReader)level, (BlockPos)pos) && (attachedState.is(this.stem) || attachedState.is((Block)this));
    }
}

