/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivefarming.common.block;

import cy.jdkdigital.productivefarming.Config;
import cy.jdkdigital.productivefarming.common.block.IAgeableCropBlock;
import cy.jdkdigital.productivefarming.common.block.entity.CropBlockEntity;
import cy.jdkdigital.productivefarming.common.block.entity.SimpleCropBlockEntity;
import cy.jdkdigital.productivefarming.recipe.CropMutationRecipe;
import cy.jdkdigital.productivefarming.registry.FarmingDataComponents;
import cy.jdkdigital.productivefarming.registry.FarmingRegistrator;
import cy.jdkdigital.productivefarming.util.CropConfig;
import cy.jdkdigital.productivefarming.util.RecipeHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.common.CommonHooks;
import org.jetbrains.annotations.Nullable;

public class ProductiveCropBlock
extends CropBlock
implements IAgeableCropBlock,
EntityBlock {
    public static final IntegerProperty AGE_6 = IntegerProperty.create((String)"age", (int)0, (int)6);
    protected final Supplier<Item> itemSupplier = () -> (Item)BuiltInRegistries.ITEM.get(BuiltInRegistries.BLOCK.getKey((Object)this).withPath(p -> cropConfig.hasSeed() ? p + "_seeds" : p));
    private final CropConfig cropConfig;

    public ProductiveCropBlock(CropConfig cropConfig, BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.cropConfig = cropConfig;
    }

    protected void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        int i;
        if (!level.isAreaLoaded(pos, 1)) {
            return;
        }
        if (level.getRawBrightness(pos, 0) >= 9 && (i = this.getAge(state)) < this.getMaxAge() && CommonHooks.canCropGrow((Level)level, (BlockPos)pos, (BlockState)state, (random.nextInt((int)(25.0f / ProductiveCropBlock.getModifiedGrowthSpeed(state, (BlockGetter)level, pos)) + 1) == 0 ? 1 : 0) != 0)) {
            BlockState growthState = this.getStateForAge(state, (Level)level, pos, i + 1);
            level.setBlock(pos, growthState, 2);
            this.increaseStatOnGrowth((Level)level, growthState, pos);
            CommonHooks.fireCropGrowPost((Level)level, (BlockPos)pos, (BlockState)state);
        }
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity blockEntity;
        if (this.isMaxAge(state) && (blockEntity = level.getBlockEntity(pos)) instanceof CropBlockEntity) {
            RecipeHolder<CropMutationRecipe> recipe;
            CropBlockEntity cropBlockEntity = (CropBlockEntity)blockEntity;
            if (stack.is((Item)FarmingRegistrator.POLLEN.get()) && stack.has(FarmingDataComponents.POLLEN_BLOCK_COMPONENT) && (recipe = RecipeHelper.getPollinationRecipe(level, BuiltInRegistries.BLOCK.getKey((Object)state.getBlock()), (ResourceLocation)stack.get(FarmingDataComponents.POLLEN_BLOCK_COMPONENT))) != null) {
                if (!level.isClientSide) {
                    cropBlockEntity.setMutation(((CropMutationRecipe)recipe.value()).mutation());
                    if (!player.hasInfiniteMaterials()) {
                        stack.shrink(1);
                    }
                    level.levelEvent(2005, pos, 0);
                    return ItemInteractionResult.FAIL;
                }
                return ItemInteractionResult.sidedSuccess((boolean)true);
            }
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (this.isMaxAge(state)) {
            BlockEntity blockEntity;
            if (!level.isClientSide && (blockEntity = level.getBlockEntity(pos)) instanceof CropBlockEntity) {
                ProductiveCropBlock cropBlock;
                CropBlockEntity cropBlockEntity = (CropBlockEntity)blockEntity;
                ItemStack cropStack = this.getHarvestItemStack((LevelReader)level, pos, state);
                Block block = state.getBlock();
                if (block instanceof ProductiveCropBlock && !(cropBlock = (ProductiveCropBlock)block).getCropConfig().hasSeed()) {
                    cropBlockEntity.applyComponentsToItemStack(cropStack);
                }
                if (cropBlockEntity.hasMutation()) {
                    cropStack = cropBlockEntity.getMutatedSeedStack(cropBlockEntity.getMutation());
                    cropBlockEntity.setMutation(null);
                }
                cropStack.grow(cropBlockEntity.getYield());
                ProductiveCropBlock.popResource((Level)level, (BlockPos)pos.relative(hitResult.getDirection()), (ItemStack)cropStack);
                level.playSound(null, pos, SoundEvents.SWEET_BERRY_BUSH_PICK_BERRIES, SoundSource.BLOCKS, 1.0f, 0.8f + level.random.nextFloat() * 0.4f);
                level.setBlock(pos, (BlockState)state.setValue((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(this.getHarvestedAge())), 2);
                this.postHarvest(state, level, pos, player);
                return InteractionResult.CONSUME;
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return super.useWithoutItem(state, level, pos, player, hitResult);
    }

    protected void postHarvest(BlockState state, Level level, BlockPos pos, Player player) {
    }

    public ItemStack getHarvestItemStack(LevelReader level, BlockPos pos, BlockState state) {
        ItemStack seedStack = ((Item)BuiltInRegistries.ITEM.get(BuiltInRegistries.BLOCK.getKey((Object)this))).getDefaultInstance();
        if (seedStack.isEmpty() && ((Boolean)Config.SERVER.traitsOnVanillaCrops.get()).booleanValue()) {
            seedStack = ((Item)BuiltInRegistries.ITEM.get(ResourceLocation.withDefaultNamespace((String)BuiltInRegistries.BLOCK.getKey((Object)this).getPath()))).getDefaultInstance();
        }
        return seedStack;
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state) {
        BlockEntity blockEntity;
        ItemStack seedStack = ((Item)BuiltInRegistries.ITEM.get(BuiltInRegistries.BLOCK.getKey((Object)this).withPath(p -> p + (this.cropConfig.hasSeed() ? "_seeds" : "")))).getDefaultInstance();
        if (seedStack.isEmpty() && ((Boolean)Config.SERVER.traitsOnVanillaCrops.get()).booleanValue()) {
            seedStack = ((Item)BuiltInRegistries.ITEM.get(ResourceLocation.withDefaultNamespace((String)(BuiltInRegistries.BLOCK.getKey((Object)this).getPath() + (this.cropConfig.hasSeed() ? "_seeds" : ""))))).getDefaultInstance();
        }
        if (!seedStack.isEmpty() && (blockEntity = level.getBlockEntity(pos)) instanceof CropBlockEntity) {
            CropBlockEntity cropBlockEntity = (CropBlockEntity)blockEntity;
            cropBlockEntity.applyComponentsToItemStack(seedStack);
        }
        return seedStack;
    }

    @Override
    public IntegerProperty getAgeProperty() {
        return AGE_6;
    }

    public int getMaxAge() {
        return 6;
    }

    @Override
    public int getHarvestedAge() {
        return 0;
    }

    protected BlockState getStateForAge(BlockState state, Level level, BlockPos pos, int age) {
        return super.getStateForAge(age);
    }

    protected ItemLike getBaseSeedId() {
        return (ItemLike)this.itemSupplier.get();
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{this.getAgeProperty()});
    }

    public void growCrops(Level level, BlockPos pos, BlockState state) {
        int j;
        int i = this.getAge(state) + this.getBonemealAgeIncrease(level);
        if (i > (j = this.getMaxAge())) {
            i = j;
        }
        level.setBlock(pos, this.getStateForAge(state, level, pos, i), 2);
        this.increaseStatOnGrowth(level, state, pos);
    }

    protected int getBonemealAgeIncrease(Level pLevel) {
        return Mth.nextInt((RandomSource)pLevel.random, (int)(this.getMaxAge() > 4 ? 2 : 1), (int)(this.getMaxAge() < 4 ? 2 : 5));
    }

    protected List<ItemStack> getDrops(BlockState state, LootParams.Builder params) {
        List drops = super.getDrops(state, params);
        Object object = params.getOptionalParameter(LootContextParams.BLOCK_ENTITY);
        if (object instanceof CropBlockEntity) {
            CropBlockEntity cropBlockEntity = (CropBlockEntity)((Object)object);
            ArrayList<ItemStack> newDrops = new ArrayList<ItemStack>();
            drops.forEach(cropStack -> {
                ProductiveCropBlock cropBlock;
                Block patt0$temp = state.getBlock();
                if (patt0$temp instanceof ProductiveCropBlock && !(cropBlock = (ProductiveCropBlock)patt0$temp).getCropConfig().hasSeed()) {
                    cropBlockEntity.applyComponentsToItemStack((ItemStack)cropStack);
                }
                if (cropBlockEntity.hasMutation()) {
                    cropStack = cropBlockEntity.getMutatedSeedStack(cropBlockEntity.getMutation());
                }
                cropStack.grow(cropBlockEntity.getYield());
                newDrops.add((ItemStack)cropStack);
            });
            cropBlockEntity.setMutation(null);
            return newDrops;
        }
        return drops;
    }

    public static float getModifiedGrowthSpeed(BlockState blockState, BlockGetter level, BlockPos pos) {
        float speed = ProductiveCropBlock.getGrowthSpeed((BlockState)blockState, (BlockGetter)level, (BlockPos)pos) * 2.0f;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof SimpleCropBlockEntity) {
            SimpleCropBlockEntity cropBlockEntity = (SimpleCropBlockEntity)blockEntity;
            speed /= (float)(cropBlockEntity.getGrowth() + 1);
        }
        return Math.max(1.0f, speed);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new SimpleCropBlockEntity(pos, state);
    }

    public CropConfig getCropConfig() {
        return this.cropConfig;
    }

    private void increaseStatOnGrowth(Level level, BlockState growthState, BlockPos pos) {
        if (((Integer)growthState.getValue((Property)this.getAgeProperty())).intValue() == this.getMaxAge() && (double)level.getRandom().nextFloat() < (Double)Config.SERVER.traitIncreaseChance.get()) {
            String trait = (new String[]{"growth", "yield", "resistance", "mutability"})[level.random.nextInt(4)];
            Object object = level.getBlockEntity(pos);
            if (object instanceof CropBlockEntity) {
                CropBlockEntity cropBlockEntity = (CropBlockEntity)((Object)object);
                switch (trait) {
                    case "growth": {
                        cropBlockEntity.setGrowth(cropBlockEntity.getGrowth() + 1);
                        break;
                    }
                    case "yield": {
                        cropBlockEntity.setYield(cropBlockEntity.getYield() + 1);
                        break;
                    }
                    case "resistance": {
                        cropBlockEntity.setResistance(cropBlockEntity.getResistance() + 1);
                        break;
                    }
                    case "mutability": {
                        cropBlockEntity.setMutability(cropBlockEntity.getMutability() + 1);
                    }
                }
            }
        }
    }
}

