/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivefarming.common.block;

import cy.jdkdigital.productivefarming.common.block.AttachedFencedStemBlock;
import cy.jdkdigital.productivefarming.common.block.IAgeableCropBlock;
import cy.jdkdigital.productivefarming.common.block.entity.FencedCropBlockEntity;
import cy.jdkdigital.productivefarming.common.block.entity.FencedStemBlockEntity;
import cy.jdkdigital.productivefarming.registry.ModTags;
import cy.jdkdigital.productivefarming.util.CropConfig;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.StemBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.common.Tags;
import org.jetbrains.annotations.Nullable;

public class FencedStemBlock
extends StemBlock
implements IAgeableCropBlock,
EntityBlock {
    private static final VoxelShape AABBS = Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);

    public FencedStemBlock(CropConfig crop, BlockBehaviour.Properties properties) {
        super(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)(crop.name() + "_leaves"))), ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)("attached_" + crop.name() + "_stem"))), ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)(crop.name() + "_seeds"))), properties);
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return AABBS;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new FencedStemBlockEntity(pos, state);
    }

    @Override
    public IntegerProperty getAgeProperty() {
        return BlockStateProperties.AGE_7;
    }

    @Override
    public int getHarvestedAge() {
        return 0;
    }

    protected void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        FencedCropBlockEntity fencedStemBlockEntity;
        BlockEntity stemBlockEntity;
        float f;
        if (!level.isAreaLoaded(pos, 1)) {
            return;
        }
        if (level.getRawBrightness(pos, 0) >= 9 && CommonHooks.canCropGrow((Level)level, (BlockPos)pos, (BlockState)state, (random.nextInt((int)(25.0f / (f = CropBlock.getGrowthSpeed((BlockState)state, (BlockGetter)level, (BlockPos)pos))) + 1) == 0 ? 1 : 0) != 0) && (stemBlockEntity = level.getBlockEntity(pos)) instanceof FencedCropBlockEntity && (fencedStemBlockEntity = (FencedCropBlockEntity)stemBlockEntity).getFence() != null) {
            int i = (Integer)state.getValue((Property)AGE);
            if (i < 7) {
                level.setBlock(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(i + 1)), 2);
            } else {
                BlockPos leafPos = pos.relative(Direction.UP);
                BlockState fenceBlockState = level.getBlockState(leafPos);
                BlockState farmlandBlockState = level.getBlockState(pos.below());
                if (fenceBlockState.is(Tags.Blocks.FENCES) && farmlandBlockState.is(ModTags.Blocks.FARMLAND)) {
                    Registry registry = level.registryAccess().registryOrThrow(Registries.BLOCK);
                    Optional fruitBlock = registry.getOptional(this.fruit);
                    Optional attachedStemBlock = registry.getOptional(this.attachedStem);
                    if (fruitBlock.isPresent() && attachedStemBlock.isPresent()) {
                        FencedCropBlockEntity fencedCropBlockEntity;
                        level.setBlockAndUpdate(leafPos, ((Block)fruitBlock.get()).defaultBlockState());
                        level.setBlockAndUpdate(pos, ((Block)attachedStemBlock.get()).defaultBlockState());
                        BlockEntity blockEntity = level.getBlockEntity(leafPos);
                        if (blockEntity instanceof FencedCropBlockEntity) {
                            fencedCropBlockEntity = (FencedCropBlockEntity)blockEntity;
                            fencedCropBlockEntity.setFence(fenceBlockState);
                        }
                        if ((blockEntity = level.getBlockEntity(pos)) instanceof FencedCropBlockEntity) {
                            fencedCropBlockEntity = (FencedCropBlockEntity)blockEntity;
                            if (fencedStemBlockEntity.getFence() != null) {
                                fencedCropBlockEntity.setFence(fencedStemBlockEntity.getFence());
                            }
                        }
                    }
                }
            }
            CommonHooks.fireCropGrowPost((Level)level, (BlockPos)pos, (BlockState)state);
        }
    }

    protected boolean mayPlaceOn(BlockState state, BlockGetter level, BlockPos pos) {
        return state.is(ModTags.Blocks.FARMLAND);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        Item item;
        if (stack.is(Tags.Items.FENCES) && (item = stack.getItem()) instanceof BlockItem) {
            FencedStemBlockEntity fencedStemBlockEntity;
            BlockItem blockItem = (BlockItem)item;
            item = level.getBlockEntity(pos);
            if (item instanceof FencedStemBlockEntity && (fencedStemBlockEntity = (FencedStemBlockEntity)item).getFence() == null) {
                fencedStemBlockEntity.setFence(blockItem.getBlock().defaultBlockState());
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        FencedCropBlockEntity fencedCropBlockEntity;
        BlockEntity blockEntity;
        if (!state.is(newState.getBlock()) && !(newState.getBlock() instanceof AttachedFencedStemBlock) && (blockEntity = level.getBlockEntity(pos)) instanceof FencedCropBlockEntity && (fencedCropBlockEntity = (FencedCropBlockEntity)blockEntity).getFence() != null) {
            level.setBlockAndUpdate(pos, fencedCropBlockEntity.getFence());
        }
        super.onRemove(state, level, pos, newState, movedByPiston);
    }
}

