/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivefarming.common.block;

import com.mojang.datafixers.DataFixUtils;
import cy.jdkdigital.productivefarming.common.block.ProductiveCropBlock;
import cy.jdkdigital.productivefarming.common.block.entity.CropBlockEntity;
import cy.jdkdigital.productivefarming.common.block.entity.FencedCropBlockEntity;
import cy.jdkdigital.productivefarming.util.CropConfig;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.util.TriState;

abstract class FencedPlantLeafBlock
extends ProductiveCropBlock {
    protected final ResourceKey<Block> stem;
    protected final ResourceKey<Item> fruit;

    public FencedPlantLeafBlock(CropConfig crop, BlockBehaviour.Properties pProperties) {
        super(crop, pProperties);
        this.stem = ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)("attached_" + crop.name() + "_stem")));
        this.fruit = ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)crop.name()));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)BlockStateProperties.FACING, (Comparable)Direction.DOWN)).setValue((Property)BlockStateProperties.DISTANCE, (Comparable)Integer.valueOf(1)));
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext pContext) {
        Vec3 vec3 = state.getOffset(level, pos);
        return Shapes.block().move(vec3.x, vec3.y, vec3.z);
    }

    protected float getMaxHorizontalOffset() {
        return 0.05f;
    }

    protected float getMaxVerticalOffset() {
        return 0.03f;
    }

    public VoxelShape getCollisionShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return Shapes.block();
    }

    abstract Direction[] validGrowthDirections(Level var1, BlockPos var2);

    abstract boolean isValidPropagationLeaf(ServerLevel var1, BlockPos var2, Direction var3);

    protected BlockState propagationState(ServerLevel level, BlockPos fromPos, Direction dir) {
        BlockState attachedState = level.getBlockState(fromPos);
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.FACING, (Comparable)dir.getOpposite())).setValue((Property)BlockStateProperties.DISTANCE, (Comparable)Integer.valueOf(attachedState.hasProperty((Property)BlockStateProperties.DISTANCE) ? Math.min(7, (Integer)attachedState.getValue((Property)BlockStateProperties.DISTANCE) + 1) : 1));
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        FencedCropBlockEntity fencedCropBlockEntity;
        super.neighborChanged(state, level, pos, block, fromPos, isMoving);
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof FencedCropBlockEntity && (fencedCropBlockEntity = (FencedCropBlockEntity)blockEntity).getFence() != null && fencedCropBlockEntity.getFence().is(BlockTags.FENCES)) {
            for (Direction dir : Direction.values()) {
                if (!dir.getAxis().isHorizontal()) continue;
                BlockState fenceState = fencedCropBlockEntity.getFence();
                fenceState = level.getBlockState(pos.relative(dir)).is(BlockTags.FENCES) ? (BlockState)fenceState.setValue((Property)PipeBlock.PROPERTY_BY_DIRECTION.get(dir), (Comparable)Boolean.valueOf(true)) : (BlockState)fenceState.setValue((Property)PipeBlock.PROPERTY_BY_DIRECTION.get(dir), (Comparable)Boolean.valueOf(false));
                fencedCropBlockEntity.setFence(fenceState);
            }
            fencedCropBlockEntity.setChanged();
        }
    }

    @Override
    public ItemStack getHarvestItemStack(LevelReader level, BlockPos pos, BlockState state) {
        return this.getCloneItemStack(level, pos, state);
    }

    @Override
    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)DataFixUtils.orElse((Optional)level.registryAccess().registryOrThrow(Registries.ITEM).getOptional(this.fruit), (Object)this));
    }

    @Override
    protected void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!level.isAreaLoaded(pos, 1)) {
            return;
        }
        if (level.getRawBrightness(pos, 0) >= 9) {
            float f = FencedPlantLeafBlock.getGrowthSpeed((BlockState)state, (BlockGetter)level, (BlockPos)pos);
            for (Direction dir : this.validGrowthDirections((Level)level, pos)) {
                BlockState fenceState = level.getBlockState(pos.relative(dir));
                if (!fenceState.is(Tags.Blocks.FENCES) || !this.isValidPropagationLeaf(level, pos, dir) || random.nextInt((int)(25.0f / (f * (float)(this.getAge(state) + 1))) + 1) != 0) continue;
                level.setBlockAndUpdate(pos.relative(dir), this.propagationState(level, pos, dir));
                BlockEntity blockEntity = level.getBlockEntity(pos.relative(dir));
                if (!(blockEntity instanceof FencedCropBlockEntity)) continue;
                FencedCropBlockEntity fencedCropBlockEntity = (FencedCropBlockEntity)blockEntity;
                fencedCropBlockEntity.setFence(fenceState);
                BlockEntity blockEntity2 = level.getBlockEntity(pos);
                if (!(blockEntity2 instanceof CropBlockEntity)) continue;
                CropBlockEntity cropBlockEntity = (CropBlockEntity)blockEntity2;
                fencedCropBlockEntity.copyTraitsFromOtherCrop(cropBlockEntity);
            }
            int i = this.getAge(state);
            if (i < this.getMaxAge() && this.canGrow(level, pos, state) && CommonHooks.canCropGrow((Level)level, (BlockPos)pos, (BlockState)state, (random.nextInt((int)(25.0f / f) + 1) == 0 ? 1 : 0) != 0)) {
                level.setBlock(pos, (BlockState)state.setValue((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(i + 1)), 2);
                CommonHooks.fireCropGrowPost((Level)level, (BlockPos)pos, (BlockState)state);
            }
        }
    }

    protected boolean canGrow(ServerLevel level, BlockPos pos, BlockState state) {
        return true;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.createBlockStateDefinition(pBuilder);
        pBuilder.add(new Property[]{BlockStateProperties.FACING}).add(new Property[]{BlockStateProperties.DISTANCE});
    }

    public boolean hidesNeighborFace(BlockGetter level, BlockPos pos, BlockState state, BlockState neighborState, Direction dir) {
        return neighborState.is((Block)this);
    }

    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        FencedCropBlockEntity fencedCropBlockEntity;
        BlockEntity blockEntity;
        if (!state.is(newState.getBlock()) && (blockEntity = level.getBlockEntity(pos)) instanceof FencedCropBlockEntity && (fencedCropBlockEntity = (FencedCropBlockEntity)blockEntity).getFence() != null) {
            level.setBlockAndUpdate(pos, fencedCropBlockEntity.getFence());
        }
        super.onRemove(state, level, pos, newState, movedByPiston);
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        TriState soilDecision = level.getBlockState(pos.below()).canSustainPlant((BlockGetter)level, pos.below(), Direction.UP, state);
        if (!soilDecision.isDefault()) {
            return soilDecision.isTrue();
        }
        BlockState stateAt = level.getBlockState(pos);
        return (stateAt.is((Block)this) || stateAt.is(Tags.Blocks.FENCES)) && super.canSurvive(state, level, pos);
    }

    public TriState canSustainPlant(BlockState state, BlockGetter level, BlockPos soilPosition, Direction facing, BlockState plant) {
        return level.getBlockState(soilPosition).is((Block)this) ? TriState.TRUE : TriState.DEFAULT;
    }
}

