/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivefarming.common.block;

import com.mojang.serialization.MapCodec;
import cy.jdkdigital.productivefarming.Config;
import cy.jdkdigital.productivefarming.common.block.entity.FarmControllerBlockEntity;
import cy.jdkdigital.productivefarming.registry.FarmingRegistrator;
import cy.jdkdigital.productivefarming.registry.ModTags;
import cy.jdkdigital.productivelib.common.block.CapabilityContainerBlock;
import cy.jdkdigital.productivelib.common.block.IMultiBlockController;
import cy.jdkdigital.productivelib.exception.InvalidStructureException;
import cy.jdkdigital.productivelib.util.MultiBlockDetector;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class FarmControllerBlock
extends CapabilityContainerBlock
implements IMultiBlockController {
    public static final MapCodec<FarmControllerBlock> CODEC = FarmControllerBlock.simpleCodec(FarmControllerBlock::new);

    public FarmControllerBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)BlockStateProperties.ATTACHED, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @Nonnull
    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> blockStateBuilder) {
        blockStateBuilder.add(new Property[]{BlockStateProperties.ATTACHED}).add(new Property[]{BlockStateProperties.HORIZONTAL_FACING});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        return (BlockState)this.defaultBlockState().setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)pContext.getHorizontalDirection().getOpposite());
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return new FarmControllerBlockEntity(pPos, pState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return level.isClientSide ? null : FarmControllerBlock.createTickerHelper(blockEntityType, (BlockEntityType)((BlockEntityType)FarmingRegistrator.FARM_CONTROLLER_BLOCK_ENTITY.get()), FarmControllerBlockEntity::tick);
    }

    protected BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        ServerLevel serverLevel;
        BlockEntity blockEntity;
        if (level instanceof ServerLevel && (blockEntity = (serverLevel = (ServerLevel)level).getBlockEntity(pos)) instanceof FarmControllerBlockEntity) {
            FarmControllerBlockEntity blockEntity2 = (FarmControllerBlockEntity)blockEntity;
            try {
                blockEntity2.setMultiBlockData(FarmControllerBlock.detectMultiblock((Level)serverLevel, pos));
            }
            catch (InvalidStructureException invalidStructureException) {
                // empty catch block
            }
        }
        return super.updateShape(state, direction, neighborState, level, pos, neighborPos);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        BlockEntity blockEntity;
        if (!level.isClientSide() && (blockEntity = level.getBlockEntity(pos)) instanceof FarmControllerBlockEntity) {
            FarmControllerBlockEntity blockEntity2 = (FarmControllerBlockEntity)blockEntity;
            try {
                blockEntity2.setMultiBlockData(FarmControllerBlock.detectMultiblock(level, pos));
                level.setBlockAndUpdate(pos, (BlockState)blockEntity2.getBlockState().setValue((Property)BlockStateProperties.ATTACHED, (Comparable)Boolean.valueOf(true)));
                player.sendSystemMessage((Component)Component.translatable((String)"productivefarming.message.farm_formed", (Object[])new Object[]{blockEntity2.getMultiblockData().height() + 1}));
                this.openGui((ServerPlayer)player, blockEntity2);
            }
            catch (InvalidStructureException ise) {
                level.setBlockAndUpdate(pos, (BlockState)blockEntity2.getBlockState().setValue((Property)BlockStateProperties.ATTACHED, (Comparable)Boolean.valueOf(false)));
                player.sendSystemMessage((Component)Component.translatable((String)"productivefarming.message.farm_invalid", (Object[])new Object[]{ise.getMessage(), String.valueOf(level.getBlockState(ise.getPos()))}));
            }
        }
        return InteractionResult.SUCCESS;
    }

    public void openGui(ServerPlayer player, FarmControllerBlockEntity blockEntity) {
        player.openMenu((MenuProvider)blockEntity, packetBuffer -> packetBuffer.writeBlockPos(blockEntity.getBlockPos()));
    }

    public static MultiBlockDetector.MultiBlockData detectMultiblock(Level level, BlockPos pos) throws InvalidStructureException {
        return MultiBlockDetector.detectStructure((Level)level, (BlockPos)pos, ModTags.Blocks.FARM_BLOCKS, null, (boolean)false, (boolean)true, (int)((Integer)Config.SERVER.farmMaxVolume.get()), (int)((Integer)Config.SERVER.farmMaxCircumference.get()), (int)((Integer)Config.SERVER.farmMaxHeight.get()));
    }
}

