/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivefarming.common.block;

import cy.jdkdigital.productivefarming.common.block.ProductiveCropBlock;
import cy.jdkdigital.productivefarming.common.block.entity.CropBlockEntity;
import cy.jdkdigital.productivefarming.util.CropConfig;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.common.CommonHooks;

public class DoubleCropBlock
extends ProductiveCropBlock {
    public DoubleCropBlock(CropConfig crop, BlockBehaviour.Properties pProperties) {
        super(crop, pProperties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(0))).setValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF, (Comparable)DoubleBlockHalf.LOWER));
    }

    @Override
    protected void postHarvest(BlockState state, Level level, BlockPos pos, Player player) {
        BlockPos otherPos = ((DoubleBlockHalf)state.getValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF)).equals((Object)DoubleBlockHalf.LOWER) ? pos.above() : pos.below();
        level.setBlock(otherPos, (BlockState)level.getBlockState(otherPos).setValue((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(this.getHarvestedAge())), 2);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return context.getClickedPos().getY() < context.getLevel().getMaxBuildHeight() - 1 && context.getLevel().getBlockState(context.getClickedPos().above()).canBeReplaced(context) ? super.getStateForPlacement(context) : null;
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        level.setBlock(pos.above(), (BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF, (Comparable)DoubleBlockHalf.UPPER), 3);
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof CropBlockEntity) {
            CropBlockEntity lowerCropBlockEntity = (CropBlockEntity)blockEntity;
            blockEntity = level.getBlockEntity(pos.above());
            if (blockEntity instanceof CropBlockEntity) {
                CropBlockEntity upperCropBlockEntity = (CropBlockEntity)blockEntity;
                upperCropBlockEntity.copyTraitsFromOtherCrop(lowerCropBlockEntity);
            }
        }
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        if (((DoubleBlockHalf)state.getValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF)).equals((Object)DoubleBlockHalf.LOWER)) {
            if ((Integer)state.getValue((Property)this.getAgeProperty()) > 0) {
                BlockState aboveState = level.getBlockState(pos.above());
                return aboveState.is((Block)this) && ((DoubleBlockHalf)aboveState.getValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF)).equals((Object)DoubleBlockHalf.UPPER) && super.canSurvive(state, level, pos);
            }
            return super.canSurvive(state, level, pos);
        }
        BlockState belowState = level.getBlockState(pos.below());
        if (state.getBlock() != this) {
            return super.canSurvive(state, level, pos);
        }
        return belowState.is((Block)this) && ((DoubleBlockHalf)belowState.getValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF)).equals((Object)DoubleBlockHalf.LOWER);
    }

    public void performBonemeal(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        if (state.is((Block)this)) {
            if (((DoubleBlockHalf)state.getValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF)).equals((Object)DoubleBlockHalf.LOWER)) {
                this.growCrops((Level)level, pos, state);
                CommonHooks.fireCropGrowPost((Level)level, (BlockPos)pos, (BlockState)state);
            } else {
                this.performBonemeal(level, random, pos.below(), level.getBlockState(pos.below()));
            }
        }
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{BlockStateProperties.DOUBLE_BLOCK_HALF});
    }

    protected boolean isRandomlyTicking(BlockState state) {
        return super.isRandomlyTicking(state) && ((DoubleBlockHalf)state.getValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF)).equals((Object)DoubleBlockHalf.LOWER);
    }

    @Override
    public int getHarvestedAge() {
        return 2;
    }
}

