/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivefarming.common.block;

import cy.jdkdigital.productivefarming.common.block.IColorfulFlowerBlock;
import cy.jdkdigital.productivefarming.common.block.entity.ColorfulFlowerBlockEntity;
import cy.jdkdigital.productivefarming.registry.FarmingDataComponents;
import cy.jdkdigital.productivefarming.util.FarmUtil;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.TallFlowerBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;

public class ColorfulTallFlowerBlock
extends TallFlowerBlock
implements EntityBlock,
IColorfulFlowerBlock {
    private final int defaultColor;

    public ColorfulTallFlowerBlock(BlockBehaviour.Properties properties, int defaultColor) {
        super(properties);
        this.defaultColor = defaultColor;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new ColorfulFlowerBlockEntity(pos, state, this.defaultColor);
    }

    @Override
    public int getDefaultColor() {
        return this.defaultColor;
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        BlockPos blockpos = pos.above();
        level.setBlock(blockpos, ColorfulTallFlowerBlock.copyWaterloggedFrom((LevelReader)level, (BlockPos)blockpos, (BlockState)((BlockState)this.defaultBlockState().setValue((Property)HALF, (Comparable)DoubleBlockHalf.UPPER))), 3);
        BlockEntity blockEntity = level.getBlockEntity(blockpos);
        if (blockEntity instanceof ColorfulFlowerBlockEntity) {
            ColorfulFlowerBlockEntity topFlowerBlockEntity = (ColorfulFlowerBlockEntity)blockEntity;
            blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof ColorfulFlowerBlockEntity) {
                ColorfulFlowerBlockEntity flowerBlockEntity = (ColorfulFlowerBlockEntity)blockEntity;
                topFlowerBlockEntity.setColor(flowerBlockEntity.getColor());
            }
        }
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        if (!level.isClientSide) {
            if (player.isCreative()) {
                ColorfulTallFlowerBlock.preventDropFromBottomPart((Level)level, (BlockPos)pos, (BlockState)state, (Player)player);
            } else {
                ColorfulTallFlowerBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)this.getDrop((LevelReader)level, pos));
            }
        }
        return super.playerWillDestroy(level, pos, state, player);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        return this.getDrop(level, pos);
    }

    public void performBonemeal(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        ColorfulTallFlowerBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)this.getDrop((LevelReader)level, pos));
    }

    private ItemStack getDrop(LevelReader level, BlockPos pos) {
        ItemStack stack = new ItemStack((ItemLike)this);
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof ColorfulFlowerBlockEntity) {
            ColorfulFlowerBlockEntity flowerBlockEntity = (ColorfulFlowerBlockEntity)blockEntity;
            stack.set(FarmingDataComponents.COLOR, (Object)flowerBlockEntity.getColor());
        }
        return stack;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        tooltipComponents.add((Component)Component.translatable((String)FarmUtil.getDyeFromColor((Integer)stack.getOrDefault(FarmingDataComponents.COLOR, (Object)this.defaultColor)).getDescriptionId()).withColor(((Integer)stack.getOrDefault(FarmingDataComponents.COLOR, (Object)this.defaultColor)).intValue()).withStyle(ChatFormatting.ITALIC));
    }
}

