/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivefarming.common.block;

import cy.jdkdigital.productivefarming.common.block.entity.ColorfulFlowerPotBlockEntity;
import cy.jdkdigital.productivefarming.registry.FarmingDataComponents;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;

public class ColorfulFlowerPotBlock
extends FlowerPotBlock
implements EntityBlock {
    private final Supplier<? extends Block> flower;

    public ColorfulFlowerPotBlock(@Nullable Supplier<FlowerPotBlock> emptyPot, Supplier<? extends Block> flower, BlockBehaviour.Properties properties) {
        super(emptyPot, flower, properties);
        this.flower = flower;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new ColorfulFlowerPotBlockEntity(pos, state);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        ItemStack stack = new ItemStack((ItemLike)this.flower.get());
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof ColorfulFlowerPotBlockEntity) {
            ColorfulFlowerPotBlockEntity flowerBlockEntity = (ColorfulFlowerPotBlockEntity)blockEntity;
            stack.set(FarmingDataComponents.COLOR, (Object)flowerBlockEntity.getColor());
        }
        return stack;
    }
}

