/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivefarming.common.block;

import cy.jdkdigital.productivefarming.common.block.IColorfulFlowerBlock;
import cy.jdkdigital.productivefarming.common.block.entity.ColorfulFlowerBlockEntity;
import cy.jdkdigital.productivefarming.registry.FarmingDataComponents;
import cy.jdkdigital.productivefarming.util.FarmUtil;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;

public class ColorfulFlowerBlock
extends FlowerBlock
implements EntityBlock,
IColorfulFlowerBlock {
    private final int defaultColor;

    public ColorfulFlowerBlock(BlockBehaviour.Properties properties, int defaultColor) {
        super(MobEffects.NIGHT_VISION, 5.0f, properties);
        this.defaultColor = defaultColor;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new ColorfulFlowerBlockEntity(pos, state, this.defaultColor);
    }

    @Override
    public int getDefaultColor() {
        return this.defaultColor;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        ItemStack stack = new ItemStack((ItemLike)this);
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof ColorfulFlowerBlockEntity) {
            ColorfulFlowerBlockEntity flowerBlockEntity = (ColorfulFlowerBlockEntity)blockEntity;
            stack.set(FarmingDataComponents.COLOR, (Object)flowerBlockEntity.getColor());
        }
        return stack;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        tooltipComponents.add((Component)Component.translatable((String)FarmUtil.getDyeFromColor((Integer)stack.getOrDefault(FarmingDataComponents.COLOR, (Object)this.defaultColor)).getDescriptionId()).withColor(((Integer)stack.getOrDefault(FarmingDataComponents.COLOR, (Object)this.defaultColor)).intValue()).withStyle(ChatFormatting.ITALIC));
    }
}

