/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivefarming.common.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FaceAttachedHorizontalDirectionalBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClamBlock
extends FaceAttachedHorizontalDirectionalBlock
implements SimpleWaterloggedBlock {
    public static final MapCodec<ClamBlock> CODEC = ClamBlock.simpleCodec(ClamBlock::new);
    protected static final VoxelShape CEILING_AABB_X = Block.box((double)6.0, (double)14.0, (double)5.0, (double)10.0, (double)16.0, (double)11.0);
    protected static final VoxelShape CEILING_AABB_Z = Block.box((double)5.0, (double)14.0, (double)6.0, (double)11.0, (double)16.0, (double)10.0);
    protected static final VoxelShape FLOOR_AABB_X = Block.box((double)6.0, (double)0.0, (double)5.0, (double)10.0, (double)2.0, (double)11.0);
    protected static final VoxelShape FLOOR_AABB_Z = Block.box((double)5.0, (double)0.0, (double)6.0, (double)11.0, (double)2.0, (double)10.0);
    protected static final VoxelShape NORTH_AABB = Block.box((double)5.0, (double)6.0, (double)14.0, (double)11.0, (double)10.0, (double)16.0);
    protected static final VoxelShape SOUTH_AABB = Block.box((double)5.0, (double)6.0, (double)0.0, (double)11.0, (double)10.0, (double)2.0);
    protected static final VoxelShape WEST_AABB = Block.box((double)14.0, (double)6.0, (double)5.0, (double)16.0, (double)10.0, (double)11.0);
    protected static final VoxelShape EAST_AABB = Block.box((double)0.0, (double)6.0, (double)5.0, (double)2.0, (double)10.0, (double)11.0);
    protected static final VoxelShape OPEN_CEILING_AABB_X = Block.box((double)6.0, (double)15.0, (double)5.0, (double)10.0, (double)16.0, (double)11.0);
    protected static final VoxelShape OPEN_CEILING_AABB_Z = Block.box((double)5.0, (double)15.0, (double)6.0, (double)11.0, (double)16.0, (double)10.0);
    protected static final VoxelShape OPEN_FLOOR_AABB_X = Block.box((double)6.0, (double)0.0, (double)5.0, (double)10.0, (double)1.0, (double)11.0);
    protected static final VoxelShape OPEN_FLOOR_AABB_Z = Block.box((double)5.0, (double)0.0, (double)6.0, (double)11.0, (double)1.0, (double)10.0);
    protected static final VoxelShape OPEN_NORTH_AABB = Block.box((double)5.0, (double)6.0, (double)15.0, (double)11.0, (double)10.0, (double)16.0);
    protected static final VoxelShape OPEN_SOUTH_AABB = Block.box((double)5.0, (double)6.0, (double)0.0, (double)11.0, (double)10.0, (double)1.0);
    protected static final VoxelShape OPEN_WEST_AABB = Block.box((double)15.0, (double)6.0, (double)5.0, (double)16.0, (double)10.0, (double)11.0);
    protected static final VoxelShape OPEN_EAST_AABB = Block.box((double)0.0, (double)6.0, (double)5.0, (double)1.0, (double)10.0, (double)11.0);

    public ClamBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)BlockStateProperties.OPEN, (Comparable)Boolean.valueOf(false))).setValue((Property)FACE, (Comparable)AttachFace.FLOOR)).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends FaceAttachedHorizontalDirectionalBlock> codec() {
        return CODEC;
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        Direction direction = (Direction)pState.getValue((Property)FACING);
        boolean flag = (Boolean)pState.getValue((Property)BlockStateProperties.OPEN);
        switch ((AttachFace)pState.getValue((Property)FACE)) {
            case FLOOR: {
                if (direction.getAxis() == Direction.Axis.X) {
                    return flag ? OPEN_FLOOR_AABB_X : FLOOR_AABB_X;
                }
                return flag ? OPEN_FLOOR_AABB_Z : FLOOR_AABB_Z;
            }
            case WALL: {
                return switch (direction) {
                    default -> throw new MatchException(null, null);
                    case Direction.EAST -> {
                        if (flag) {
                            yield OPEN_EAST_AABB;
                        }
                        yield EAST_AABB;
                    }
                    case Direction.WEST -> {
                        if (flag) {
                            yield OPEN_WEST_AABB;
                        }
                        yield WEST_AABB;
                    }
                    case Direction.SOUTH -> {
                        if (flag) {
                            yield OPEN_SOUTH_AABB;
                        }
                        yield SOUTH_AABB;
                    }
                    case Direction.NORTH, Direction.UP, Direction.DOWN -> flag ? OPEN_NORTH_AABB : NORTH_AABB;
                };
            }
        }
        if (direction.getAxis() == Direction.Axis.X) {
            return flag ? OPEN_CEILING_AABB_X : CEILING_AABB_X;
        }
        return flag ? OPEN_CEILING_AABB_Z : CEILING_AABB_Z;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{BlockStateProperties.WATERLOGGED, BlockStateProperties.OPEN, FACING, FACE});
    }

    public void randomTick(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        super.randomTick(pState, pLevel, pPos, pRandom);
        if (!((Boolean)pState.getValue((Property)BlockStateProperties.OPEN)).booleanValue() && ((Boolean)pState.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue() && pLevel.getEntitiesOfClass(LivingEntity.class, new AABB(pPos).inflate(2.0)).isEmpty()) {
            pLevel.setBlockAndUpdate(pPos, (BlockState)pState.setValue((Property)BlockStateProperties.OPEN, (Comparable)Boolean.valueOf(true)));
        }
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        ClamBlock.popResource((Level)level, (BlockPos)pos.relative(hitResult.getDirection()), (ItemStack)new ItemStack((ItemLike)this));
        level.setBlock(pos, (Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED) != false ? Blocks.WATER.defaultBlockState() : Blocks.AIR.defaultBlockState(), 2);
        return InteractionResult.SUCCESS;
    }

    public boolean isRandomlyTicking(BlockState pState) {
        return (Boolean)pState.getValue((Property)BlockStateProperties.OPEN) == false;
    }

    public void entityInside(BlockState pState, Level pLevel, BlockPos pPos, Entity pEntity) {
        super.entityInside(pState, pLevel, pPos, pEntity);
        if (((Boolean)pState.getValue((Property)BlockStateProperties.OPEN)).booleanValue()) {
            pLevel.setBlockAndUpdate(pPos, (BlockState)pState.setValue((Property)BlockStateProperties.OPEN, (Comparable)Boolean.valueOf(false)));
        }
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        FluidState fluidstate = pContext.getLevel().getFluidState(pContext.getClickedPos());
        return (BlockState)super.getStateForPlacement(pContext).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.is((Fluid)Fluids.WATER)));
    }

    @NotNull
    public FluidState getFluidState(BlockState pState) {
        return (Boolean)pState.getValue((Property)BlockStateProperties.WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(pState);
    }
}

