/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivefarming.common.block;

import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import cy.jdkdigital.productivefarming.common.block.entity.FencedCropBlockEntity;
import cy.jdkdigital.productivefarming.common.block.entity.FencedStemBlockEntity;
import cy.jdkdigital.productivefarming.registry.ModTags;
import cy.jdkdigital.productivefarming.util.CropConfig;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.StemBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class AttachedFencedStemBlock
extends BushBlock
implements EntityBlock {
    public static final MapCodec<AttachedFencedStemBlock> CODEC = RecordCodecBuilder.mapCodec(p_308799_ -> p_308799_.group((App)ResourceKey.codec((ResourceKey)Registries.BLOCK).fieldOf("fruit").forGetter(block -> block.fruit), (App)ResourceKey.codec((ResourceKey)Registries.BLOCK).fieldOf("stem").forGetter(block -> block.stem), (App)ResourceKey.codec((ResourceKey)Registries.ITEM).fieldOf("seed").forGetter(block -> block.seed), (App)AttachedFencedStemBlock.propertiesCodec()).apply((Applicative)p_308799_, AttachedFencedStemBlock::new));
    private final ResourceKey<Block> fruit;
    private final ResourceKey<Block> stem;
    private final ResourceKey<Item> seed;
    private static final VoxelShape AABBS = Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);

    public AttachedFencedStemBlock(CropConfig crop, BlockBehaviour.Properties properties) {
        this((ResourceKey<Block>)ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)(crop.name() + "_leaves"))), (ResourceKey<Block>)ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)crop.name())), (ResourceKey<Item>)ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)crop.name())), properties);
    }

    public AttachedFencedStemBlock(ResourceKey<Block> fruit, ResourceKey<Block> stem, ResourceKey<Item> seed, BlockBehaviour.Properties properties) {
        super(properties);
        this.fruit = fruit;
        this.stem = stem;
        this.seed = seed;
    }

    protected MapCodec<? extends BushBlock> codec() {
        return CODEC;
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return AABBS;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new FencedStemBlockEntity(pos, state);
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)DataFixUtils.orElse((Optional)level.registryAccess().registryOrThrow(Registries.ITEM).getOptional(this.seed), (Object)((Object)this)));
    }

    protected BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        Optional optional;
        if (!facingState.is(this.fruit) && facing.equals((Object)Direction.UP) && (optional = level.registryAccess().registryOrThrow(Registries.BLOCK).getOptional(this.stem)).isPresent()) {
            return (BlockState)((Block)optional.get()).defaultBlockState().trySetValue((Property)BlockStateProperties.AGE_7, (Comparable)Integer.valueOf(7));
        }
        return super.updateShape(state, facing, facingState, level, currentPos, facingPos);
    }

    protected boolean mayPlaceOn(BlockState state, BlockGetter level, BlockPos pos) {
        return state.is(ModTags.Blocks.FARMLAND);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{HorizontalDirectionalBlock.FACING});
    }

    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        FencedCropBlockEntity fencedCropBlockEntity;
        BlockEntity blockEntity;
        if (!state.is(newState.getBlock()) && !(newState.getBlock() instanceof StemBlock) && !state.is(newState.getBlock()) && (blockEntity = level.getBlockEntity(pos)) instanceof FencedCropBlockEntity && (fencedCropBlockEntity = (FencedCropBlockEntity)blockEntity).getFence() != null) {
            level.setBlockAndUpdate(pos, fencedCropBlockEntity.getFence());
        }
        super.onRemove(state, level, pos, newState, movedByPiston);
    }
}

